/*
   id3.c - interface to id3 tag reading and writing

    Copyright (C) 2002  John Tobin <cedric@earthling.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  ***************************************************************************

  This file is based in part on:
*/

#include "id3.h"


id3Tag::id3Tag()
{

}


void id3Tag::writeTag(GtkWidget *main_win, char* file)
{
memset(&mp3_,0,sizeof(mp3info));
if ( !( mp3_.file=fopen(file,"rb+") ) ) {
       cout<<"Bad Filename "<<file<<endl;
		return;
	    }
strcpy(mp3_.id3.title, gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_title"))));
strcpy(mp3_.id3.artist, gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_artist"))));
strcpy(mp3_.id3.album, gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_album"))));
strcpy(mp3_.id3.year, gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_year"))));
strcpy(mp3_.id3.comment, gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_comments"))));
strcpy((gchar *)mp3_.id3.track, gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_track"))));
strcpy((gchar *)mp3_.id3.genre, gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_genre"))));
mp3_.filename=file;
write_tag(&mp3_);
fclose(mp3_.file);
}
void id3Tag::writeRippedTag(GtkWidget *main_win, const char* file, const char * title)
{
string filename1 = file;
filename1+=".mp3";
//filename1 = "\""+filename1+"\"";
const char* filename2=filename1.c_str();
if ( !( mp3_.file=fopen(filename2,"rb+") ) ) {
       cout<<"Bad Filename "<<file<<endl;
		return;
	    }
strcpy(mp3_.id3.title, title);
strcpy(mp3_.id3.artist, gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"rip_artist"))));
strcpy(mp3_.id3.album, gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"rip_album"))));
//strcpy(mp3_.id3.year, gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_year"))));
//strcpy(mp3_.id3.comment, gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_comments"))));
//strcpy((gchar *)mp3_.id3.track, gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_track"))));
//strcpy((gchar *)mp3_.id3.genre, gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_genre"))));
mp3_.filename=filename2;
write_tag(&mp3_);
fclose(mp3_.file);
	}		
		
void id3Tag::readTag(GtkWidget *main_win, char* file)
{
memset(&mp3_,0,sizeof(mp3info));
if ( !( mp3_.file=fopen(file,"rb+") ) ) {
       cout<<"Bad Filename "<<file<<endl;
		return;
	    }
mp3_.filename=file;
get_mp3_info(&mp3_, SCAN_QUICK,0);


//set file info labels
sprintf((char *)bitRate, "%d", int(header_bitrate(&mp3_.header)));
sprintf((char *)length, "%d:%d", int(mp3_.seconds/60), int(mp3_.seconds%60));
sprintf((char *)fileSize, "%d bytes", int(mp3_.datasize));
gtk_entry_set_text(GTK_ENTRY(get_widget(main_win,"mp3_filename_entry")),(gchar *)file);
gtk_label_set_text(GTK_LABEL(get_widget(main_win,"bitrate_label")),(gchar *)bitRate);
gtk_label_set_text(GTK_LABEL(get_widget(main_win,"length_label")),(gchar *)length);
gtk_label_set_text(GTK_LABEL(get_widget(main_win,"size_label")),(gchar *)fileSize);

//set entries
gtk_entry_set_text(GTK_ENTRY(get_widget(main_win,"id3_title")),(gchar *)mp3_.id3.title);
gtk_entry_set_text(GTK_ENTRY(get_widget(main_win,"id3_artist")),(gchar *)mp3_.id3.artist);
gtk_entry_set_text(GTK_ENTRY(get_widget(main_win,"id3_album")),(gchar *)mp3_.id3.album);
gtk_entry_set_text(GTK_ENTRY(get_widget(main_win,"id3_year")),(gchar *)mp3_.id3.year);
gtk_entry_set_text(GTK_ENTRY(get_widget(main_win,"id3_comments")),(gchar *)mp3_.id3.comment);
gtk_entry_set_text(GTK_ENTRY(get_widget(main_win,"id3_track")),(gchar *)mp3_.id3.track);
gtk_entry_set_text(GTK_ENTRY(get_widget(main_win,"id3_genre")),(gchar *)mp3_.id3.genre);
fclose(mp3_.file);
}

void id3Tag::readOggTag(GtkWidget *main_win, string file)
{
   String2int convert;
   MasterAudioCD audio;
   struct stat filesize;
   int seconds;
   string ftemp = "/tmp/"+convert.randName();
   string command = "vorbiscomment \""+file+"\" > "+ftemp;
   cout << command << endl;
   system(command.c_str());
   string fieldTemp;
   ifstream oggRead;
   gtk_entry_set_text(GTK_ENTRY(get_widget(main_win,"mp3_filename_entry")),(gchar *)file.c_str());
   oggRead.open(ftemp.c_str());
   getline(oggRead, fieldTemp);
   while(oggRead)
   {
      if (fieldTemp.find("ARTIST=")!= -1)
        {
           cout<< fieldTemp<<endl;
           string field = fieldTemp.substr(7, fieldTemp.length() - 7);
           gtk_entry_set_text(GTK_ENTRY(get_widget(main_win,"id3_artist")),(gchar *)field.c_str());
        }
      else if (fieldTemp.find("TITLE=")!= -1)
        {
           string field = fieldTemp.substr(6, fieldTemp.length() - 6);
           gtk_entry_set_text(GTK_ENTRY(get_widget(main_win,"id3_title")),(gchar *)field.c_str());
        }
      else if (fieldTemp.find("ALBUM=")!= -1)
        {
           string field = fieldTemp.substr(6, fieldTemp.length() - 6);
           gtk_entry_set_text(GTK_ENTRY(get_widget(main_win,"id3_album")),(gchar *)field.c_str());
        }
      else if (fieldTemp.find("TRACKNUMBER=")!= -1)
        {
           string field = fieldTemp.substr(12, fieldTemp.length() - 12);
           gtk_entry_set_text(GTK_ENTRY(get_widget(main_win,"id3_track")),(gchar *)field.c_str());
        }
      else if (fieldTemp.find("DATE=")!= -1)
        {
           string field = fieldTemp.substr(5, fieldTemp.length() - 5);
           gtk_entry_set_text(GTK_ENTRY(get_widget(main_win,"id3_year")),(gchar *)field.c_str());
        }
       getline(oggRead,fieldTemp);
   }
   oggRead.close();
   stat(file.c_str(), &filesize);
   audio.ogginfo(file.c_str(), seconds);
   sprintf((char *)length, "%d:%d", int(seconds/60), int(seconds%60));
   sprintf((char *)fileSize, "%d bytes", int(filesize.st_size));
   sprintf((char *)bitRate, "%d", int(filesize.st_size*8/seconds/1000));
   gtk_label_set_text(GTK_LABEL(get_widget(main_win,"bitrate_label")),(gchar *)bitRate);
   gtk_label_set_text(GTK_LABEL(get_widget(main_win,"length_label")),(gchar *)length);
   gtk_label_set_text(GTK_LABEL(get_widget(main_win,"size_label")),(gchar *)fileSize);
   unlink(ftemp.c_str());
}

void id3Tag::writeOggTag(GtkWidget *main_win, string file)
{
   string title, artist, album, year, track;
   char *field;
   field = (char *)gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_title")));
   title = field;
   field = (char *)gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_artist")));
   artist = field;
   field = (char *) gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_album")));
   album = field;
   field = (char *)gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_year")));
   year = field;
   field = (char *)gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_track")));
   track = field;
   //strcpy((gchar *)mp3_.id3.genre, gtk_entry_get_text(GTK_ENTRY(get_widget(main_win,"id3_genre"))));
   string command="vorbiscomment -a \""+file+"\" -t \"TITLE="+title+"\" -t \"ARTIST="+artist+"\" -t \"ALBUM="+album+"\" -t \"TRACKNUMBER="+track+"\" -t \"DATE="+year+"\"";
   cout << command<< endl;
   system(command.c_str());

}
