
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <dirent.h>
#include <string.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <fcntl.h>

#include "misc_utils.h"

int add_argv( char **dest, char *content )
{
	size_t i;

	i = 0;

	while ( content[ i++ ] != '\0' ) ;

	if ( ( *dest = (char *) malloc( i ) ) == NULL ) {
		//err_handler( MALLOC_ERR, NULL );
		return FALSE;
	}

	strcpy( *dest, content );
	return TRUE;
}

int process_options( char *options, char **argv, int start, int end )
{
	int current, i, j, flag;
	char buf[ MAX_SINGLE_OPTION_LENGTH ];

	current = start;
	i = 0;
	while ( options[ i ] != '\0' ) {
		while ( isspace( options[ i ] ) ) i++;
		j = 0;
		flag = 0;
		while ( !isspace( options[ i ] )
			        && options[ i ] != '\0'
			        && j < MAX_SINGLE_OPTION_LENGTH - 1 ) {
			/* It really has something other than spaces */
			flag = 1;
			buf[ j++ ] = options[ i++ ];
		}
		buf[ j ] = '\0';

		/* If it really has something */
		if ( flag ) {
			if ( current < end ) {
				if ( add_argv( &argv[ current ], buf ) == FALSE )
					return - 1;
			} else {
				//err_handler( TOO_MANY_ARGS_ERR, NULL );
			}
			current++;
		}
	}
	return current - start;
}

char **create_argv_for_execution_using_shell( char *command )
{
	char * shell;
	char **argv;

	//shell = config.shell_for_execution;

	if ( ( argv = ( char ** ) malloc( sizeof( char * ) * 4 ) ) == NULL ) {
		//err_handler( MALLOC_ERR, NULL );
		return NULL;
	}
	argv[ 0 ] = NULL;
	argv[ 1 ] = NULL;
	argv[ 2 ] = NULL;
	argv[ 3 ] = NULL;

	if ( add_argv( &( argv[ 0 ] ), shell ) == FALSE )
		return NULL;
	if ( add_argv( &( argv[ 1 ] ), "-c" ) == FALSE )
		return NULL;
	if ( add_argv( &( argv[ 2 ] ), command ) == FALSE )
		return NULL;
	return argv;
}

void free_argv( char **argv )
{
	int i;

	i = 0;
	while ( argv[ i ] != NULL )
		free( argv[ i++ ] );

	free( argv );
}

int parse_rx_format_string( char *target, int target_len,
                            char *format,
                            int track_no, char *w_fname, char *m_fname,
                            char *artist, char *album, char *song )
{
	int s, d, i;
	char space, ch;
	char *tmp;
	char track_no_str[ 4 ];

	track_no_str[ 0 ] = 0;
	if ( track_no >= 0 )
		snprintf( track_no_str, sizeof( track_no_str ), "%02d", track_no + 1 );

	s = 0; d = 0;

	while ( format[ s ] != '\0' && d < target_len - 1 ) {
		// determine space character and check for error
		space = ' ';
		if ( format[ s ] == '%' ) {
			ch = format[ s + 1 ];
			if ( ch == '\0' ) {
				return - 1;
			}
			if ( ch == '%' || ch == '#' || ch == 'w' || ch == 'm' ||
				        ch == 'a' || ch == 'v' || ch == 's' )
				s += 1;
			else {
				ch = format[ s + 2 ];
				if ( ch == '\0' ) {
					return - 1;
				}
				if ( ch == '%' || ch == '#' || ch == 'w' || ch == 'm' ||
					        ch == 'a' || ch == 'v' || ch == 's' ) {
					space = format[ s + 1 ];
					s += 2;
				}
			}

			// determine what to copy
			tmp = NULL;
			switch ( format[ s ] ) {
			case '%' :
				tmp = "%";
				break;
			case '#' :
				tmp = track_no_str;
				break;
			case 'w' :
				tmp = w_fname;
				break;
			case 'm' :
				tmp = m_fname;
				break;
			case 'a' :
				tmp = artist;
				break;
			case 'v' :
				tmp = album;
				break;
			case 's' :
				tmp = song;
				break;
			}
			if ( tmp == NULL ) {
				return - 1;
			}
			// expand
			for ( i = 0; tmp[ i ] != '\0'; )
				target[ d++ ] = tmp[ i++ ];
			s++;
		} else
			target[ d++ ] = format[ s++ ];
	}
	if ( format[ s ] != '\0' ) {
		//err_handler( RX_PARSING_ERR, "Buffer overflow" );
		return - 1;
	}

	target[ d ] = '\0';
	return 0;
}

char *time_to_readable( time_t sec )
{
	static char buf[ 10 ];

	sprintf( buf, "%2d:%02d", ( int ) sec / 60, ( int ) sec % 60 );
	return buf;
}

char *length_to_readable( unsigned length )
{
	time_t sec;

	sec = float (length) / CD_SECTORS_PER_SEC;
	return time_to_readable( sec );
}


char *expand_tilde( char *path )
{
	static char buf[ MAX_FILE_PATH_LENGTH + MAX_FILE_NAME_LENGTH ];

	if ( path[ 0 ] != '~' )
		return path;
	strcpy( buf, getenv( "HOME" ) );
	strcpy( buf + strlen( buf ), path + 1 );
	return buf;
}

char *construct_file_name( char *path, char *name )
{
	int offset;
	static char buf[ MAX_FILE_PATH_LENGTH + MAX_FILE_NAME_LENGTH ];

	strcpy( buf, path );
	offset = strlen( buf ) - 1;
	if ( buf[ offset ] != '/' )
		buf[ ++offset ] = '/';

	offset++;

	strcpy( buf + offset, name );
	return buf;
}

char *file_name_without_path( char *src )
{
	int offset;

	offset = strlen( src ) - 1;

	while ( src[ offset ] != '/' && offset >= 0 )
		offset--;

	return src + ++offset;
}

char *file_path_without_name( char *src )
{
	static char buf[ MAX_FILE_PATH_LENGTH ];
	int offset;

	offset = strlen( src ) - 1;

	while ( src[ offset ] != '/' && offset >= 0 )
		offset--;

	strncpy( buf, src, offset );
	return buf;
}
/*
void auto_append_extension( char *src, int type )
{
	int offset;

	offset = strlen( src ) - 4;
	/* aasdfasdfasd.wav * /
	/*             ^    * /

	if ( type == WAV ) {
		if ( strcmp( ".wav", src + offset ) != 0 ) {
			offset += 4;
			strcpy( src + offset, ".wav" );
			return;
		}
	} else if ( type == OGG) {
		if ( strcmp( ".ogg", src + offset ) != 0 ) {
			offset += 4;
			strcpy( src + offset, ".ogg" );
			return;
		}
	} else {
		if ( strcmp( ".mp3", src + offset ) != 0 ) {
			offset += 4;
			strcpy( src + offset, ".mp3" );
			return;
		}
	}
}
char *get_default_file_name( int type, int track )
{
	char name_format[ MAX_FILE_NAME_LENGTH ];
	char name_buf[ MAX_FILE_NAME_LENGTH ], name_buf2[ MAX_FILE_NAME_LENGTH ];
	char path_buf[ MAX_FILE_PATH_LENGTH ];
	char track_no_buf[ 5 ];
	int read_offset, write_offset, return_val;
	struct stat st;

	if ( type == WAV ) {
		strcpy( name_format, config.wav_file_name_format );
		strcpy( path_buf, config.wav_path );
	} else {
		strcpy( name_format, config.mp3_file_name_format );
		strcpy( path_buf, config.mp3_path );
	}

	read_offset = -1;
	write_offset = 0;
	while ( name_format[ ++read_offset ] != '\0' ) {
		if ( name_format[ read_offset ] == '%' ) {
			snprintf( track_no_buf, 5, "%d", track + 1 );
			strcpy( name_buf + write_offset, track_no_buf );
			write_offset += strlen( track_no_buf );
		} else name_buf[ write_offset++ ] = name_format[ read_offset ];
	}
	name_buf[ write_offset ] = '\0';

	return_val = stat( construct_file_name( path_buf, name_buf ), &st );
	while ( ( return_val == 0 || errno != ENOENT )    /* is errno != ENOENT right? (ralf) * /
		        && ( strlen( name_buf ) < MAX_FILE_NAME_LENGTH - 2 ) ) {
		strcpy( name_buf2, name_buf );
		name_buf[ 0 ] = config.prepend_char;
		strcpy( name_buf + 1, name_buf2 );

		return_val = stat( construct_file_name( path_buf, name_buf ), &st );
	}
	return construct_file_name( path_buf, name_buf );
}
*/
/* This code is borrowed from telnetd source code which was in the
   inetutils-1.3.2 package from GNU */
int open_a_pty( int *pty, int *tty )
{
	char line[ 12 ];
	char *p1, *p2;
	char *cp;
	int i;

	sprintf( line, "/dev/ptyXX" );
	p1 = &line[ 8 ];
	p2 = &line[ 9 ];

	for ( cp = "pqrstuvwxyzPQRST"; *cp; cp++ ) {
		struct stat stb;

		*p1 = *cp;
		*p2 = '0';
		/*
		 * This stat() check is just to keep us from
		 * looping through all 256 combinations if there
		 * aren't that many ptys available.
		 */
		if ( stat( line, &stb ) < 0 )
			break;
		for ( i = 0; i < 16; i++ ) {
			*p2 = "0123456789abcdef"[ i ];
			*pty = open( line, O_RDWR );
			if ( *pty > 0 ) {
				line[ 5 ] = 't';
				/* Now open appropriate tty */
				if ( ( *tty = open( line, O_RDWR ) ) < 0 ) {
					line[ 5 ] = 'p';
					close( *pty );
					continue;
				}
				return 0;
			}
		}
	}
	return - 1;
}

int is_str_blank( char *str )
{
	int i;

	i = 0;
	while ( str[ i++ ] != '\0' )
		if ( !isspace( str[ i ] ) && str[ i ] != '\0' )
			return FALSE;
	return TRUE;
}

void remove_non_unix( char *src )
{
	int i;

	for ( i = 0; src[ i ] != 0; i++ ) {
		if ( src[i] == '-' ) continue;
		if ( !isalnum(src[ i ]) ) {
			src[ i ] = '-';
		}
	}
}

void convert_spaces( char *src )
{
	int i;

	for ( i = 0; src[ i ]; i++ )
		if ( src[ i ] == ' ' )
			src[ i ] = '_';
}


/***************************************************
 * 
 * Function implementations immigrated from misc.c
 *
 */


char *get_string_piece( FILE* file, int delim )
{
	/* gets one complete row from 'file' and save it in 'buffer'.
	buffer's memory will be freed and allocated to fit the stringsize
	automatically. */

	char * buffer1 = ( char* ) malloc( 1 ),
	                 *buffer2 = ( char* ) malloc( 1 ),
	                            *tmp = ( char* ) malloc( 1024 );
	char **active, **inactive;
	int i = 0;

	strcpy( buffer1, "" );
	strcpy( buffer2, "" );
	strcpy( tmp, "" );
	do {
		/*switch the frames*/
		if ( inactive == &buffer1 ) {
			active = &buffer1;
			inactive = &buffer2;
		} else {
			active = &buffer2;
			inactive = &buffer1;
		}
		/*get the next part, and handle EOF*/
		if ( fgets( tmp, 1024, file ) == NULL ) { /* ok, so we reached the end of the
									            			                                                                                    																 file w/o finding the delimiter */
			free( *active );
			return NULL;
		}

		free( *active );
		*active = ( char* ) malloc( ( ++i ) * 1024 );
		sprintf( *active, "%s%s", *inactive, tmp );

	} while ( strchr( *active, delim ) == NULL );

	free( *inactive );
	return *active;
}

char *get_ascii_file( FILE* file )
{
	/* gets one complete row from 'file' and save it in 'buffer'.
	buffer's memory will be freed and allocated to fit the stringsize
	automatically. */

	char * buffer1 = ( char* ) malloc( 1 ),
	                 *buffer2 = ( char* ) malloc( 1 ),
	                            *tmp = ( char* ) malloc( 1024 );
	char **active, **inactive;
	int i = 0;

	strcpy( buffer1, "" );
	strcpy( buffer2, "" );
	strcpy( tmp, "" );
	do {
		/*switch the frames*/
		if ( inactive == &buffer1 ) {
			active = &buffer1;
			inactive = &buffer2;
		} else {
			active = &buffer2;
			inactive = &buffer1;
		}
		/*get the next part, and handle EOF*/
		if ( fgets( tmp, 1024, file ) == NULL ) {
			free( *active );
			return *inactive;
		}

		free( *active );
		*active = ( char* ) malloc( ( ++i ) * 1024 );
		sprintf( *active, "%s%s", *inactive, tmp );
	} while ( 1 );
}

void strip_trailing_space( char **string )
{
	int i = strlen( *string ) - 1;
	char *return_string;

	if ( string == NULL || *string == NULL )
		return;
	while ( isspace( ( *string ) [ i ] ) )
		i--;
	i++;
	return_string = ( char* ) malloc( i + 1 );
	strncpy( return_string, *string, i ); return_string[ i ] = 0;
	free( *string );
	*string = return_string;
}

void strip_leading_space( char **string )
{
	char * tmp = *string,
	             *return_string;

	if ( string == NULL || *string == NULL )
		return;

	while ( isspace( *tmp ) )
		tmp++;

	return_string = strdup( tmp );
	free( *string );
	*string = return_string;
}


char *string_append( char **dest, char *appendage )
{
	char * holder;

	if ( dest == NULL || appendage == NULL )
		return NULL;

	if ( *dest != NULL ) {
		holder = *dest;
		*dest = ( char* ) malloc( strlen( holder ) + strlen( appendage ) + 1 );
		sprintf( *dest, "%s%s", holder, appendage );
		free( holder );
	} else
		*dest = strdup( appendage );

	return *dest;
}

void charpp_to_charp( char **dest, char**src, int num, char* separator )
{
	int i, size = 0, sep_size = 0;

	if ( src == NULL || num == 0 )
		return;

	if ( separator == NULL )
		separator = strdup( "" );

	sep_size = strlen( separator );

	for ( i = 0; i < num; i++ )
		size += strlen( src[ i ] ) + sep_size;
	if ( *dest != NULL )
		free( *dest );

	*dest = ( char* ) malloc( size + 1 );
	strcpy( *dest, "" );

	for ( i = 0; i < num - 1; i++ ) {
		strcat( *dest, src[ i ] );
		strcat( *dest, separator );
	} /* do it this way, so no separator will get in as the last part */
	strcat( *dest, src[ num - 1 ] );

}

FILE *socket_init( const char *server, short int port )
{
	struct hostent * host;
	struct sockaddr_in socket_address;
	int hsocket;

	/* see if some default values have been set */
	if ( server == NULL ) {
		return NULL;
	}

	host = gethostbyname( server );
	if ( host == NULL )
		return NULL;          /* we don't know the host */

	/* set socket address */
	memset( &socket_address, 0, sizeof( socket_address ) );
	memcpy( ( char* ) & socket_address.sin_addr, host->h_addr, host->h_length );
	socket_address.sin_family = host->h_addrtype;
	socket_address.sin_port = htons( port );

	/* get the actual socket handle */
	hsocket = socket( host->h_addrtype, SOCK_STREAM, 0 );
	if ( hsocket < 0 )        /* we couldn't grab the socket */
		return NULL;

	if ( connect( hsocket, ( struct sockaddr* ) & socket_address,
					              sizeof( socket_address ) ) < 0 )
					return NULL;

	return fdopen( hsocket, "r+" );          /* we made it */
}


int get_subdirs( const char *path, char **buffer )
{
	int hits = 0, status;
	char *subdirname;
	DIR *dirp;
	struct dirent *dir_contents;
	struct stat file_stats;

	if ( path == NULL || ( dirp = opendir( path ) ) == NULL ) {
		return hits;
	}

	while ( ( dir_contents = readdir( dirp ) ) != NULL ) {
		if ( strcmp( dir_contents->d_name, "." ) != 0 &&
			        strcmp( dir_contents->d_name, ".." ) != 0 ) {

			subdirname = ( char* ) malloc( strlen( path ) + strlen( dir_contents->d_name ) + 2 );
			sprintf( subdirname, "%s/%s", path, dir_contents->d_name );
			status = stat( subdirname, &file_stats );

			if ( status == 0 && hits < 1000 ) {
				if ( S_ISDIR( file_stats.st_mode ) ) { /* we are a subdir */
					buffer[ hits ] = strdup( subdirname );
					hits++;
				}
			}
			free( subdirname );
		}
	}

	return hits;
}

char* int2str( int integer )
{
	char * newstr = ( char* ) malloc( 10 );
	sprintf( newstr, "%d", integer );
	return newstr;
}

long check_free_space(char* dir) {
    FILE *file;
    long len;
    char cmd[MAX_FILE_NAME_LENGTH];
    char buffer[MAX_FILE_NAME_LENGTH];
    
    snprintf(cmd, MAX_FILE_NAME_LENGTH - 1, 
             "df -k '%s' |awk '{print $4}'", dir);
    file = popen(cmd, "r");
    fscanf(file, "%s\n", &buffer); /* read the Available title */
    fscanf(file, "%ld", &len); /* now read the length */
    pclose(file);
    return len;
}

int check_dir(char *dir) {
    int rc;
    struct stat ds;

    rc = access(dir, F_OK);
    if (rc != 0) {
        return MISC_DOES_NOT_EXISTS;
    }
    rc = stat(dir, &ds);
    if (rc != 0) {
        return MISC_NOT_DIR;
    } 
    if (!S_ISDIR(ds.st_mode)) {
        return MISC_NOT_DIR;
    }
    rc = access(dir, X_OK | W_OK | R_OK);
    if (rc != 0) {
        return MISC_NOT_WRITABLE;
    }
    return MISC_OK;
}

int create_dir(char *path) {
    char *parent;
    char *tmp;
    int rc;

    tmp = strdup(path); /*preserve our string */
    //parent = dirname(tmp);
    fprintf(stderr, "parent is : %s\n", parent);
    rc = check_dir(parent);
    if (strcmp(parent, "/") == 0) {
        return -1; /* stop endless loop */
    }
    if (rc == MISC_NOT_DIR || rc == MISC_NOT_WRITABLE) { 
        return -1;
    } else if (rc == MISC_DOES_NOT_EXISTS) {
                /* recursively create */
        if (create_dir(parent) != 0) {
            fprintf(stderr, "failed to create %s\n", parent);
            return -1;
        }
        fprintf(stderr, "created %s\n", parent);
    }
    rc = mkdir(path, 0755);
    free(tmp);
    return rc;
}

int is_found(char *plugin) {
    FILE *pf;
    char buffer[MAX_COMMAND_LENGTH];
    char cmd[MAX_COMMAND_LENGTH];

    snprintf(cmd, sizeof(cmd) -1, "%s 2>&1", plugin);

    pf = popen(cmd, "r");
    if (pf == NULL) {
        return 0;
    }
    fgets(buffer, sizeof(buffer) - 1, pf);
    pclose(pf);
    if (strncmp(buffer, "sh:", 3) != 0) {
        return 1;
    }
    return 0;
}

