/*
 SimpleCDR Copyright (C) 2001 John Tobin

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 If you would like to negotiate alternate licensing terms, you may do
 so by contacting the author: John Tobin <ogre@sirinet.net>

 rifffile.h - Copyright (c) 1996, 1998 by Timothy J. Weber */
using namespace std;
#ifndef __RIFFFILE_H
#define __RIFFFILE_H

/* Headers required to use this module */
#include <stack>
#include <string>
#include <vector>

#include <stdio.h>

/***************************************************************************
	macros, constants, and enums
***************************************************************************/

/***************************************************************************
	typedefs, structs, classes
***************************************************************************/

class RiffFile;
class RiffChunk {
public:
	char name[5];
	unsigned long size;  // the length, read from the second chunk header entry
	char subType[5];  // valid for RIFF and LIST chunks
	long start;  // the file offset in bytes of the chunk contents
	long after;  // the start of what comes after this chunk

	// initialize at the file's current read position, and mark the file as bad
	// if there's an error.
	RiffChunk()
		{};
	RiffChunk(RiffFile& file);

	bool operator < (const RiffChunk& other) const
		{ return start < other.start; };
	bool operator == (const RiffChunk& other) const
	{ return strcmp(name, other.name) == 0
		&& size == other.size
		&& strcmp(subType, other.subType) == 0
		&& start == other.start; };
};

class RiffFile {
	FILE* fp;

	unsigned long formSize;

	std::stack<RiffChunk, std::vector<RiffChunk> > chunks;

public:
	RiffFile(const char *name);
	~RiffFile();

	bool rewind();
	bool push(const char* chunkType = 0);
	bool pop();
	long chunkSize() const;
	const char* chunkName() const;
	const char* subType() const;
	bool getNextExtraItem(std::string& type, std::string& value);
	FILE* filep()
		{ return fp; };

protected:
	bool readExtraItem(std::string& type, std::string& value);
};

/***************************************************************************
	public variables
***************************************************************************/

#ifndef IN_RIFFFILE
#endif

/***************************************************************************
	function prototypes
***************************************************************************/

#endif
/* __RIFFFILE_H */
