/*
 SimpleCDR Copyright (C) 2001 John Tobin

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 If you would like to negotiate alternate licensing terms, you may do
 so by contacting the author: John Tobin <ogre@sirinet.net>
 */
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <string>
#include <iostream>
#include <fstream>
#include <cstdlib>

#include "simplecdr.h"
#include "string2int.h"
#include "play.h"
#include "progress.h"
#include "ucdrom.h"

using namespace std;


#ifndef __RIP_H__
#define __RIP_H__ 

class RipEncode
{
public:
int encSel(string, string, string, string, Setup);
void encAll(string, string, string, Setup);
void encInd(string, string, Setup);
int rip(string, string, string, Setup);
void ripAll(string, string, Setup);
void cdrom(int&, Setup);
void track(int, string, string, Setup);
void trackList(RipType, string, string, string, string, Setup);
ofstream logFile;

private:
Setup setupData1;
String2int convert;
string prompt, suffix;
Play play;
RipType ripping;
};

#endif //__RIP_H__
