/*
 * Copyright (c) 1997 - 2001 Hansjrg Malthaner
 *
 * This file is part of the Simutrans project under the artistic licence.
 * (see licence.txt)
 */

#ifndef simbau_h
#define simbau_h

#include "../boden/wege/weg.h"
#include "../tpl/vector_tpl.h"
#include "../simtypes.h"
#include "../simwerkz.h"


class weg_besch_t;
class kreuzung_besch_t;
class bruecke_besch_t;
class tunnel_besch_t;
class karte_t;
class spieler_t;
class grund_t;

class werkzeug_parameter_waehler_t;


/**
 * Diese Klasse bernimmt Wegsuche und Bau von Strassen, Schienen etc.
 * @author Hj. Malthaner
 */
class wegbauer_t
{
public:
	static const weg_besch_t *leitung_besch;

	static bool register_besch(const weg_besch_t *besch);
	static bool alle_wege_geladen();

	// generates timeline message
	static void neuer_monat(karte_t *welt);

	/**
	 * Finds a way with a given speed limit for a given waytype
	 * @author prissi
	 */
	static const weg_besch_t *  weg_search(const waytype_t wtyp,const uint32 speed_limit,const uint16 time, const weg_t::system_type system_type);

	static const weg_besch_t * gib_besch(const char *way_name,const uint16 time=0);

	/**
	 * Fill menu with icons of given waytype
	 * @author Hj. Malthaner
	 */
	static void fill_menu(werkzeug_waehler_t *wzw, const waytype_t wtyp, const weg_t::system_type styp, karte_t *welt );

	enum bautyp_t {
		strasse=road_wt,
		schiene=track_wt,
		schiene_tram=tram_wt, // Dario: Tramway
		monorail=monorail_wt,
		maglev=maglev_wt,
		wasser=water_wt,
		luft=air_wt,
		narrowgauge=narrowgauge_wt,
		leitung=powerline_wt,
		bautyp_mask=255,
		bot_flag=0x100,					// do not connect to other ways
		elevated_flag=0x200,			// elevated structure
		tunnel_flag=0x800				// underground structure
	};

private:
	struct next_gr_t
	{
		next_gr_t() {}
		next_gr_t(grund_t* gr_, long cost_) : gr(gr_), cost(cost_) {}

		grund_t* gr;
		long		cost;
	};
	vector_tpl<next_gr_t> next_gr;

	enum { unseen = 9999999 };
	enum { max_route_laenge = 1024 };

	spieler_t *sp;

	/**
	 * Type of building operation
	 * @author Hj. Malthaner
	 */
	enum bautyp_t bautyp;

	/**
	 * Type of way to build
	 * @author Hj. Malthaner
	 */
	const weg_besch_t * besch;

	/**
	 * Type of bridges to build (zero=>no bridges)
	 * @author Hj. Malthaner
	 */
	const bruecke_besch_t * bruecke_besch;

	/**
	 * Type of bridges to build (zero=>no bridges)
	 * @author Hj. Malthaner
	 */
	const tunnel_besch_t * tunnel_besch;

	/**
	 * If a way is built on top of another way, should the type
	 * of the former way be kept or replced (true == keep)
	 * @author Hj. Malthaner
	 */
	bool keep_existing_ways;
	bool keep_existing_faster_ways;
	bool keep_existing_city_roads;

	karte_t *welt;
	uint32 maximum;    // hoechste Suchtiefe

	vector_tpl<koord3d> route;

	koord3d position_bei(unsigned i) const { return route[i]; }

	// allowed owner?
	bool check_owner( const spieler_t *sp1, const spieler_t *sp2 ) const;

	// allowed slope?
	bool check_slope( const grund_t *from, const grund_t *to );

	/* This is the core routine for the way search
	* it will check
	* A) allowed step
	* B) if allowed, calculate the cost for the step from from to to
	* @author prissi
	*/
	bool is_allowed_step( const grund_t *from, const grund_t *to, long *costs );

	// checks, if we can built a bridge here ...
	// may modify next_gr array!
	void check_for_bridge(const grund_t* parent_from, const grund_t* from, koord3d ziel);

	long intern_calc_route(koord3d start, const koord3d ziel);
	void intern_calc_straight_route(const koord3d start, const koord3d ziel);

	// runways need to meet some special conditions enforced here
	bool intern_calc_route_runways(koord3d start, const koord3d ziel);

	ribi_t::ribi calc_ribi(int step);

	void baue_tunnel_und_bruecken();

	// adds the ground before underground construction (always called before the following construction routines)
	bool baue_tunnelboden();

	// adds the grounds for elevated tracks
	void baue_elevated();

	void baue_strasse();
	void baue_schiene();
	void baue_leitung();

public:
	koord3d gib_route_bei(int i) const { return route[i]; }

	int n, max_n;

	/**
	 * If a way is built on top of another way, should the type
	 * of the former way be kept or replced (true == keep)
	 * @author Hj. Malthaner
	 */
	void set_keep_existing_ways(bool yesno);

	/* If a way is built on top of another way, should the type
	 * of the former way be kept or replaced, if the current way is faster (true == keep)
	 * @author Hj. Malthaner
	 */
	void set_keep_existing_faster_ways(bool yesno);

	/* Always keep city roads (for AI)
	 * @author prissi
	 */
	void set_keep_city_roads(bool yesno) { keep_existing_city_roads = yesno; }

	void route_fuer(enum bautyp_t wt, const weg_besch_t * besch, const tunnel_besch_t *tunnel_besch=NULL, const bruecke_besch_t *bruecke_besch=NULL);

	void set_maximum(uint32 n) { maximum = n; }

	wegbauer_t(karte_t *welt, spieler_t *spl);

	void calc_straight_route(koord3d start, const koord3d ziel);
	void calc_route(koord3d start3d, koord3d ziel);

	/* returns the amount needed to built this way
	* author prissi
	*/
	long calc_costs();

	bool check_crossing(const koord zv, const grund_t *bd,waytype_t wtyp, const spieler_t *sp) const;
	bool check_for_leitung(const koord zv, const grund_t *bd) const;

	void baue();
};

#endif
