#include "udpmessagetransmitter.h"
#include "messageioconst.h"
#include <string>
using namespace std;


UDPMessageTransmitter::UDPMessageTransmitter(asio::io_service& io_service, const asio::ip::udp::endpoint & senderEndpoint) :ioservice(io_service), senderEndpoint(senderEndpoint)
{
}


void UDPMessageTransmitter::send(const Message & message)
{
  asio::ip::udp::socket sock(ioservice,senderEndpoint.protocol());
  sock.set_option(asio::socket_base::broadcast(true));

  if (message.size()<=maxMessageIOSize)
  {
    sock.send_to(asio::buffer(message.getDataPtr(), message.size()), senderEndpoint);
  }
}
