#ifndef _broadcastreceiver_h
#define _broadcastreceiver_h

#include <asio.hpp>
#include "message.h"
#include "sinfo.h"


class BroadcastReceiver
{
private:
  enum { max_length = 65535 }; // maximum UDP packet size
  char data[max_length];
  asio::ip::udp::endpoint sender_endpoint;

  asio::io_service & ioservice;
  asio::ip::udp::socket sock;

  bool & restartCounterEventFlag;
  std::list < Wsinfo > & wsinfoList;

  void  receiveMessage(std::string inetaddrString, unsigned long inetaddrHostByteOrder, Message & message);

public:
  BroadcastReceiver(asio::io_service& io_service, bool & _restartCounterEventFlag, std::list < Wsinfo > & _wsinfoList);
  void handle_receive_from(const asio::error_code& err, size_t length);
};


#endif
