%define name		siproxd
%define ver		0.5.5
%define release		1
%define serial		1
%define prefix		%{_prefix}
%define sysconfdir	/etc

Name:		%{name}
Summary:	A SIP masquerading proxy with RTP support
Version: 	%{ver}
Release: 	%{release}
Copyright: 	GPL
Group:		Applications/Communications
Source0: 	%{name}-%{ver}.tar.gz

URL: 		http://siproxd.sourceforge.net/
BuildRoot:	%{_tmppath}/%{name}-%{ver}-root
Docdir: 	%{_docdir}

Requires:	libosip2 >= 2.0.2
BuildRequires:	libosip2 >= 2.0.2

Vendor:		Thomas Ries

Packager:       Thomas Ries <tries@gmx.net>

%description
Siproxd is an proxy/masquerading daemon for the SIP protocol.
It handles registrations of SIP clients on a private IP network
and performs rewriting of the SIP message bodies to make SIP
connections possible via an masquerading firewall.
It allows SIP clients (like kphone, linphone) to work behind
an IP masquerading firewall or router.


%prep
%setup -q

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{prefix} \
                                    --sysconfdir=%{sysconfdir}
make

%install
make prefix=$RPM_BUILD_ROOT%{prefix} \
     sysconfdir=$RPM_BUILD_ROOT%{sysconfdir} \
     install
mv $RPM_BUILD_ROOT%{sysconfdir}/siproxd.conf.example \
   $RPM_BUILD_ROOT%{sysconfdir}/siproxd.conf

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc COPYING README AUTHORS INSTALL NEWS ChangeLog doc/FAQ doc/FLI4L_HOWTO.txt
%{_sbindir}/siproxd
%config %{sysconfdir}/siproxd.conf
%config %{sysconfdir}/siproxd_passwd.cfg

%post
echo "Edit the config file %{sysconfigdir}/siproxd.conf!"


%changelog
* Fri Oct 31 2003 Thomas Ries <tries@gmx.net>
- siproxd is now installed to sbin directory

* Fri Oct 24 2003 Thomas Ries <tries@gmx.net>
- added config files and some more doc files
- rename sample config file and remind user to edit it.
- minor cleanup

* Sat Aug 30 2003 Thomas Ries <tries@gmx.net>
- always use /etc as sysconfdir

* Sat Sep 21 2002 Thomas Ries <tries@gmx.net>
- first RPM support

