#ifndef _AVI_H_
#define _AVI_H_
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_FFMPEG

#include <libavcodec/avcodec.h>
#include <libavformat/avformat.h>
#include <libswscale/swscale.h>
#include <libavutil/pixfmt.h>

#include "siril.h"

#define AVI_SUCCESS 0
#define AVI_ERROR -1
#define AVI_END_OF_SEQUENCE -42


struct avi_struct {
	// ffmpeg data
	AVFormatContext* format_context;
	int stream_number;
	AVCodecContext* codec_context;
	AVCodec* codec;

	int nb_layers;		// 1 for gray, 3 for rgb, 0 for uninit
	enum PixelFormat dest_fmt;	// destination format, depending on nb_layers

	int frame_count;	// number of frames
#if 0
	int *frame_index;	// index of frames, table index is frame, content is avi frame
	int index_size;		// size of frame_index
#endif
	int current_frame;
	AVPacket pkt;

	// image data
	struct SwsContext *convert_context;
	AVFrame *frame;		// the natively decoded frame (not necessarily in RGB24)
	AVFrame *frameRGB;	// the converted frame, 1 or 3 layer

	char *filename;
};

/* external functions */
int avi_open_file(const char *filename, struct avi_struct *avi_file);
void avi_close_file(struct avi_struct *avi_file);
int avi_read_frame(struct avi_struct *avi_file, int frame_no, fits *fit);
void avi_init_struct(struct avi_struct *avi_file);
void avi_display_info(struct avi_struct *avi_file);

/* internal stuff */
int allocate_frames_and_conversion(struct avi_struct *avi_file);
void check_video_number_of_layers(struct avi_struct *avi);
int decode_packet(struct avi_struct *avi_file, int *got_frame, int cached, fits *fit);

#endif
#endif
