/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.multipart;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.dispatcher.StrutsRequestWrapper;
import org.apache.struts2.dispatcher.multipart.MultiPartRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPartRequestWrapper
extends StrutsRequestWrapper {
    protected static final Logger LOG = LoggerFactory.getLogger(MultiPartRequestWrapper.class);
    Collection<String> errors;
    MultiPartRequest multi;

    public MultiPartRequestWrapper(MultiPartRequest multiPartRequest, HttpServletRequest request, String saveDir) {
        super(request);
        this.multi = multiPartRequest;
        try {
            this.multi.parse(request, saveDir);
            for (Object o : this.multi.getErrors()) {
                String error = (String)o;
                this.addError(error);
            }
        }
        catch (IOException e) {
            this.addError("Cannot parse request: " + e.toString());
        }
    }

    public Enumeration<String> getFileParameterNames() {
        if (this.multi == null) {
            return null;
        }
        return this.multi.getFileParameterNames();
    }

    public String[] getContentTypes(String name) {
        if (this.multi == null) {
            return null;
        }
        return this.multi.getContentType(name);
    }

    public File[] getFiles(String fieldName) {
        if (this.multi == null) {
            return null;
        }
        return this.multi.getFile(fieldName);
    }

    public String[] getFileNames(String fieldName) {
        if (this.multi == null) {
            return null;
        }
        return this.multi.getFileNames(fieldName);
    }

    public String[] getFileSystemNames(String fieldName) {
        if (this.multi == null) {
            return null;
        }
        return this.multi.getFilesystemName(fieldName);
    }

    public String getParameter(String name) {
        return this.multi == null || this.multi.getParameter(name) == null ? super.getParameter(name) : this.multi.getParameter(name);
    }

    public Map getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            map.put(name, this.getParameterValues(name));
        }
        return map;
    }

    public Enumeration getParameterNames() {
        if (this.multi == null) {
            return super.getParameterNames();
        }
        return this.mergeParams(this.multi.getParameterNames(), super.getParameterNames());
    }

    public String[] getParameterValues(String name) {
        return this.multi == null || this.multi.getParameterValues(name) == null ? super.getParameterValues(name) : this.multi.getParameterValues(name);
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public Collection<String> getErrors() {
        return this.errors;
    }

    protected void addError(String anErrorMessage) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(anErrorMessage);
    }

    protected Enumeration mergeParams(Enumeration params1, Enumeration params2) {
        Vector temp = new Vector();
        while (params1.hasMoreElements()) {
            temp.add(params1.nextElement());
        }
        while (params2.hasMoreElements()) {
            temp.add(params2.nextElement());
        }
        return temp.elements();
    }
}

