/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.interceptor.ValidationWorkflowAware;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.lang.reflect.Method;

public class DefaultWorkflowInterceptor
extends MethodFilterInterceptor {
    private static final long serialVersionUID = 7563014655616490865L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultWorkflowInterceptor.class);
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private String inputResultName = "input";

    public void setInputResultName(String inputResultName) {
        this.inputResultName = inputResultName;
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        ValidationAware validationAwareAction;
        Object action = invocation.getAction();
        if (action instanceof ValidationAware && (validationAwareAction = (ValidationAware)action).hasErrors()) {
            InputConfig annotation;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Errors on action " + validationAwareAction + ", returning result name 'input'", new String[0]);
            }
            String resultName = this.inputResultName;
            if (action instanceof ValidationWorkflowAware) {
                resultName = ((ValidationWorkflowAware)action).getInputResultName();
            }
            if ((annotation = action.getClass().getMethod(invocation.getProxy().getMethod(), EMPTY_CLASS_ARRAY).getAnnotation(InputConfig.class)) != null) {
                if (!annotation.methodName().equals("")) {
                    Method method = action.getClass().getMethod(annotation.methodName(), new Class[0]);
                    resultName = (String)method.invoke(action, new Object[0]);
                } else {
                    resultName = annotation.resultName();
                }
            }
            return resultName;
        }
        return invocation.invoke();
    }
}

