/**
 * Copyright (C) 2009 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import junit.framework.TestCase;

/**
 * @author jessewilson@google.com (Jesse Wilson)
 */
public class FindCommentStartTest extends TestCase {

  public void testFindCommentStartPlain() {
    assertEquals(5, Munge.findCommentStart("ABCDE/*FGHI", 0));
    assertEquals(5, Munge.findCommentStart("ABCDE/*FGHI", 4));
    assertEquals(5, Munge.findCommentStart("ABCDE/*FGHI", 5));
  }

  public void testFindCommentStartMultiline() {
    assertEquals(5, Munge.findCommentStart("AB\n\nE/*FGHI", 0));
    assertEquals(5, Munge.findCommentStart("AB\n\nE/*FGHI", 4));
    assertEquals(5, Munge.findCommentStart("AB\n\nE/*FGHI", 5));
  }

  public void testFindCommentStartEndOfLineComment() {
    assertEquals(5, Munge.findCommentStart("//\n\nE/*FGHI", 0));
    assertEquals(5, Munge.findCommentStart("//*\n\n/*FGHI", 0));
    assertEquals(5, Munge.findCommentStart("///*\n/*FGHI", 0));
  }

  public void testFindCommentStartString() {
    assertEquals(5, Munge.findCommentStart("\"BC\"E/*", 0));
    assertEquals(5, Munge.findCommentStart("\"/*\"E/*", 0));
    assertEquals(7, Munge.findCommentStart("\"\" + \"\"/*", 0));
  }

  public void testRealWorldCode() {
    assertEquals(-1, Munge.findCommentStart("  filter(\"/*\").through(TestFilter.class);", 0));
    assertEquals(-1, Munge.findCommentStart("  filter(\"/public/login/*\").through(Key", 0));
    assertEquals(-1, Munge.findCommentStart("      // a servlet mapping of /thing/*", 0));
  }

}
