=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: generates naive cgi search form for search of sisu database (pgsql sqlite)
   * $Id$

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.
  
 * Ralph Amissah mailto:ralph@amissah.com
   Ralph Amissah mailto:amissah@gmail.com

=end
module  SiSU_CGI                                                                 #% database building documents
  require "#{SiSU_lib}/sysenv"
  require "#{SiSU_lib}/cgi_pgsql"
  require "#{SiSU_lib}/cgi_sqlite"
  include SiSU_CGI_pgsql
  class SiSU_search
    def initialize(webserv,cf)
      @webserv,@cf=webserv,cf
      #p @webserv
      webrick_port=SiSU_Env::Info_dir.new.webrick_port
      @port=case @webserv
      when /webrick/
        @webrick_port=":#{webrick_port}"
        "        '#@webrick_port'\n"
      else
        @webrick_port=''
        "        ''\n"
      end
      #@html,@pdf='.html','.pdf' # @html,@pdf='',''
    end
    def read
      SiSU_CGI_sqlite::SiSU_search_sqlite.new(@webserv,@cf).sqlite
      SiSU_CGI_pgsql::SiSU_search_pgsql.new(@webserv,@cf).pgsql
    end
  end
end
__END__
