=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: remote put, copy output to remote server
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Notes: this operation should probably be threaded & run at its own pace,
     independent of rest of program
     primary problem will be with notification of progress, 
     implement naively to start with
 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Remote
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  pwd=Dir.pwd
  class Put 
    def initialize(sf,cf)
      @fns,@cf=sf,cf
      @dir=SiSU_Env::Info_dir.new(@fns)
      @put=unless @fns =~/\.t[1-3]/: @fns
      else @fns.gsub(/(.+)?\.t([0-3])$/,"\\1.r\\2")
      end
      @remote=SiSU_Env::Info_remote.new(@put,@cf)
    end
    def scp 
      tell=SiSU_Screen::Ansi.new(@cf,'Remote placement ->',@put)
      tell.darkgreyTitleHi unless @cf =~/q/
      @remote.scp
    end
    def rsync 
      tell=SiSU_Screen::Ansi.new(@cf,'Remote placement ->',@put)
      tell.darkgreyTitleHi unless @cf =~/q/
      @remote.rsync
    end
  end
  class Put_base 
    def initialize(cf)
      @cf=cf
      @remote=SiSU_Env::Info_remote_base.new(@cf)
    end
    def scp_base 
      tell=SiSU_Screen::Ansi.new(@cf,'Remote placement of base site ->','excluding images')
      tell.darkgreyTitleHi unless @cf =~/q/
      @remote.scp_base
    end
    def scp_base_all 
      tell=SiSU_Screen::Ansi.new(@cf,'Remote placement ->','complete')
      tell.darkgreyTitleHi unless @cf =~/q/
      @remote.scp_base_all
    end
    def rsync_base
      tell=SiSU_Screen::Ansi.new(@cf,'Remote placement ->','rsync')
      tell.darkgreyTitleHi unless @cf =~/q/
      @remote.rsync_base
    end
    def rsync_base_sync
      tell=SiSU_Screen::Ansi.new(@cf,'Remote placement ->','rsync and sync')
      tell.darkgreyTitleHi unless @cf =~/q/
      @remote.rsync_base_sync
    end
  end
end
__END__
