=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: rexml testing of xml
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com

 * Notes: tidy -xml sax.xml >> index.tidy
=end
module SiSU_Rexml
  # load XML file for REXML parsing
  require 'rexml/document' if FileTest.directory?("#{Config::CONFIG['rubylibdir']}/rexml") #Config::CONFIG['sitedir']
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  $program='rexml'
  class Rexml
    require 'rexml/document' if FileTest.directory?("#{Config::CONFIG['rubylibdir']}/rexml") #Config::CONFIG['sitedir']
    def initialize(md,fno,cf)
      @md,@fno,@cf=md,fno,cf
      @fns=@md.fns
      @fnb,@suffix=/(.+?)\.([_-]?sst)$/i.match(@fns).captures
      @dir=SiSU_Env::Info_dir.new(@fns)
      @prog=SiSU_Env::Info_program.new #(md.fns) #if md
      @fnap="#{@dir.data_o}/#@fnb/#@fno" #index.xml causes problems with index.html in server config
      @e_head='/document/head'
      @e_title='/document/head/title'
      @e_object='/document/body/object'
      @e_ocn='/document/body/object/ocn'
      @e_text='/document/body/object/text'
      @e_endnote='/document/body/object/endnote'
      #@ocn='/document/body/object/ocn'
    end
    def xml
      begin
        if FileTest.file?(@fnap)
          if @prog.rexml !=false and FileTest.directory?('/usr/lib/ruby/1.8/rexml/') #note values can be other than true
            xfile=File.new(@fnap)
            xmlfile=(xfile.collect).join
            xfile.close
            @xmldoc=REXML::Document.new xmlfile
            tell=SiSU_Screen::Ansi.new(@cf,'invert','REXML',"XML document #@fnap loaded")  #% tell
            tell.colorize unless @cf =~/q/
            #% substantive text
            if @cf =~ /v/i
              @xmldoc.elements.each(@e_head) do |e|
                tell=SiSU_Screen::Ansi.new(@cf,'brown',e)
                tell.colorize unless @cf =~/q/
              end
            end
          end
        else
          tell=SiSU_Screen::Ansi.new(@cf,'fuschia',"File Not Found #{xmlfile}",'requested XML processing skipped')
          tell.colorize unless @cf =~/q/
          exit
        end
      rescue: SiSU_Errors::Info_error.new($!,$@,@cf,@fns).error
      ensure
      end
    end
  end
end

<<WOK 
REXML: A pure Ruby XML library
http://www.whytheluckystiff.net/articles/2003/08/04/rubyOneEightOh
 
REXML is an XML library of the highest order. It is simple to use, full of features, faithful to Ruby's ideals and quite swift. Many who have been frustrated by the design of other XML libraries, find complete satisfaction in REXML. Allow me a short demonstration.

One of REXML's greatest features is it's XPath support. Let's suppose we have an XML document stored in a string, such as:

xmlstr=<<EOF
  <mydoc>
    <someelement attribute="nanoo">Text, text, text</someelement>
  </mydoc>
EOF

Now, let's load the above document into a REXML::Document object:

require 'rexml/document'
xmldoc=REXML::Document.new xmlstr

If we want to access the text in the /mydoc/someelement node, we can simply access the elements property with an XPath string between square brackets:

xmldoc.elements['/mydoc/someelement'].text
#=> "Text, text, text"

Attributes can be accessed via the REXML::Attributes object:

xmldoc.elements['/mydoc/someelement'].attributes['attribute']
#=> "nanoo"

You can do a surprising amount with knowledge of just the above techniques. I will leave you with one other before I hand you off to REXML's documentation.

The REXML::Elements#each method is useful for cycling through a set of matching XML nodes. Supposing we wanted to cycle through all someelement nodes:

xmldoc.elements.each('/mydoc/someelement') do |ele|
  puts ele.text
end

REXML also has APIs for creating XML, stream parsing, event-based (SAX) parsing, entity processing, and a wealth of encodings.

For more information, I would suggest studying in the following order:
   1. REXML Tutorial: An introduction to REXML by its author.
      http://www.germane-software.com/software/rexml/docs/tutorial.html
   2. David Mertz' The REXML Library: An introduction to REXML and comparison to other XML parsing techniques.
      http://www-106.ibm.com/developerworks/xml/library/x-matters18.html
   3. REXML FAQ: A handful of useful pointers.
      http://www.germane-software.com/software/rexml/faq.html
   4. Full API Documentation (RDoc): Everything else.
      http://www.germane-software.com/software/rexml/doc/
WOK
__END__

 misc
e.each do |element|
  element.each do |child|
    if child.is_a?(REXML::Text)
      puts "Text: #{child.to_s.inspect}"
    else
      puts "SubElement: #{child.name}"
    end
  end
end

