=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: create sisudoc filetype and copy it to output directory!
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Notes: tidy -ascii index.xml >> index.tidy

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Doc
  require 'fileutils'
  include SiSU_Env
  class Source
    include FileUtils #::Verbose
    require "#{SiSU_lib}/sysenv"
    def initialize(fns,cf)
      @fns,@cf=fns,cf
      @home,@pwd=ENV['HOME'],ENV['PWD']
      m=/.+\/(\S+)/im
      @pwd_stub=@pwd[m,1]
      @date=SiSU_Env::Info_date.new.dt
      @dir=SiSU_Env::Info_dir.new(@fns)
    end
    def read
      tell=SiSU_Screen::Ansi.new(@cf,'Share SiSU Document (tar gzip)',@fns)
      tell.greenHiBlue unless @cf =~/q/
      unless @fns.empty?
        tell=SiSU_Screen::Ansi.new(@cf,"Make sisu document (tar gzip) and place in output directory","#@fns.tgz -> #@zap_path")
        tell.warn unless @cf =~/q/
        #tell=SiSU_Screen::Ansi.new('',"#@fns.tgz")
        #tell.blue_tab unless @cf =~/q/
        directories
        sisudoc_build
        sisudoc_zip
      else
        tell=SiSU_Screen::Ansi.new(@cf,"Make (tar gzip) of sisu work directory","#@pwd_stub\_#@date.tgz")
        tell.warn unless @cf =~/q/
        tell.blue_tab unless @cf =~/q/
        zip_directory
      end
    end
    def zip_directory
      v=if @cf =~/[VM]/: 'v'
      else               ''
      end
      system(%{ cd ..     
        tar c#{v}zf #@pwd_stub\_#@date.tgz #@pwd_stub/*.{s,r}{1,2,3} #@pwd_stub/_sisu/{conf,image} &&
        cd #@pwd })
      tell=SiSU_Screen::Ansi.new(@cf,'Share SiSU Document (tar gzip)',@fns)
      tell.greenHiBlue unless @cf =~/q/
      tell=SiSU_Screen::Ansi.new(@cf,"Copy sisu document to output directory","#@fns -> #@zap_path")
      tell.warn unless @cf =~/q/
      tell=SiSU_Screen::Ansi.new('',"#@fns.tgz")
      tell.blue_tab unless @cf =~/q/
    end
    def directories
      SiSU_Env::Info_dir.new.sisudoc
    end
    def select(skin='')                                                          # skin loading logic here
      load "#{SiSU_lib}/defaults.rb"
      @skin=Hash.new
      skin_path = [
        "#@pwd/_sisu/skin",
        "#@home/.sisu/skin",
        "/etc/sisu/skin",
        "#{@dir.processing}/external_document/skin"
      ]
      sk_doc,sk_dir="doc/#{skin}.rb","dir/skin_#@pwd_stub.rb"
      skin_path.each do |v|                                                    #document skin priority 1
        if FileTest.file?("#{v}/#{sk_doc}")
          @skin[:name],@skin[:type]="#{v}/#{sk_doc}",'doc'
          break
        end
      end
      unless @skin
        skin_path.each do |v|                                                  #directory skin priority 2
          if FileTest.file?("#{v}/#{sk_dir}")
            @skin[:name],@skin[:type]="#{v}/#{sk_dir}",'dir'
            break
          end
        end
      end
      @skin
    end
    def sisudoc_build
      @rgx_rb_image=/["'](\S+?\.(?:png|jpg))["']/
      @rgx_image=/\{\s*(\S+?\.(?:png|jpg))/
      @rgx_skin=/0~skin\s+(\S+)/
      file_array=IO.readlines(@fns,'')
      #sisudoc=Array.new
      skin=Array.new
      images=Array.new
      file_array.collect.each do |f|                                             #% work area
        unless f =~/^%\s/
          skin << f.scan(@rgx_skin).uniq if f =~@rgx_skin     
          images << f.scan(@rgx_image).uniq if f =~@rgx_image     
        end
      end
      if skin and skin.length > 0
        docskin=skin.pop.flatten.join
        skin_source=select(docskin)
        docskin_pwd="#{pwd}/_sisu/sisu_doc/_sisu/skin/#{skin_source[:type]}"
        cp_r(skin_source[:name], "#{docskin_pwd}/#{docskin}.rb") 
        if skin_source[:type] =~/dir/
          File.symlink("#{docskin_pwd}/#{docskin}.rb","#{docskin_pwd}/skin_#@stub.rb")
        end
        skinfile_array=IO.readlines(skin_source[:name],'')
        para_images=Array.new
        skinfile_array.collect.each do |f|                                       #% work area
          unless f =~/^#/
            images << f.scan(@rgx_rb_image).uniq if f =~@rgx_rb_image #and FileTest.file?(f.scan(@rgx_rb_image).uniq)    
            #does not really discriminate, 
            #may duplicate images in sisu file, and 
            #may take images from default image pool
          end
        end
        #1. mapping in doc dir?
        #2. need images used by skin, scan skin??
      else #search for doc skin, search for site skin
      end
      if images and images.length > 1
        images.flatten!.uniq! 
        image_path_pwd='_sisu/image'
        image_path_doc='_sisu/sisu_doc/_sisu/image'
        #unattractive hard coding ... !
        pwd=Dir.pwd
        images_pwd="#{pwd}/#{image_path_pwd}"
        images_pwd_doc="#{pwd}/#{image_path_doc}"
        if FileTest.directory?(image_path_pwd)
          images=images.uniq
          images.each do |i|
            cp_r("#{images_pwd}/#{i}", "#{images_pwd_doc}/#{i}") if FileTest.file?("#{images_pwd}/#{i}")
          end
          #chmod(0755, dir_images_www)
        else puts "\tWARN, did not find - #{image_path_pwd}"
        end
      end
      x=@dir.document_language_versions_found   #check multiple document language versions (param not used)
      if x[:f] and x[:f].length > 1             #store multiple document language versions, sisupod
        x[:f].each do |f|
          cp_r("#@pwd/#{f}","#@pwd/_sisu/sisu_doc/#{f}") 
        end
      else cp_r("#@pwd/#@fns","#@pwd/_sisu/sisu_doc/#@fns") 
      end
    end
    def sisudoc_zip
      dir=SiSU_Env::Info_dir.new(@fns)
      local_path="#{dir.data_o}/#{dir.fnb}"
      v=if @cf =~/[VM]/: 'v'
      else                ''
      end
      system(%{
        cd #@pwd/_sisu &&     
        tar c#{v}zf #@fns.tgz sisu_doc &&
        mv #@fns.tgz #{local_path}/sisudoc.tgz &&
        #mv #@fns.tgz ../ &&
        rm -r sisu_doc/* &&
        cd #@pwd
      })
      tell=SiSU_Screen::Ansi.new('',"#@fns.tgz")
      tell.blue_tab unless @cf =~/q/
    end
  end
end
__END__
question?:                   should you permit the packing of multiple files in single .gz ?

  open fns, parse file
    extract from file content:
      images and copy each image from whatever image source to _sisu/sisu_doc/sisu/_sisu/image
      skin and copy active skin from whatever source to _sisu/sisu_doc/sisu/_sisu/skin/doc
      extract from skin images required by skin

   remove previously existing contents of _/sisu/sisu_doc &
   make directory structure:
   
   _sisu
     sisu_doc
       sisu
         content.sst              [file content]
         filename.sst             [link to content.sst]
         _sisu
           conf
             skin/
               doc                [relevant skin if any other than default]
           image                  [all images for specific document gathered here]

sisu
  _sisu
    sisurc.yaml
    skin/
      dir/
      doc/
      misc/
      site/
      yaml/
    convert/
    standard_terms/
    image
    processing
      metaverse/
      tex/
      texinfo/
      tune/
    sisudoc

special case

composite file, e.g.
SiSU.r3
