=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: urls for output files
   * $Date$
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_urls
  $program||='tbl'
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  include SiSU_Screen
  require "#{SiSU_lib}/param"
  include SiSU_Param
  class Source
    attr_reader :fnb,:cf
    def initialize(fns,cf)
      @fns=fns
      @fnb=fns #correct later
      #p @fnb
      @cf=/([a-zA-Z0-9]+)/.match(cf)[1]
    end
    def read
      begin
        SiSU_urls::Output_urls.new(@fnb,@cf).songsheet if @fnb[/.+?\.(?:[_-]?sst|ssm)$/]
      rescue: SiSU_Errors::Info_error.new($!,$@,nil,@cf).error
      ensure
      end
    end
  end
  class Output_urls
    include SiSU_Param
    attr_reader :fns,:fnb,:cf,:dir,:m_regular,:u
    def initialize(fns='',cf='')
      @fns=fns
      fn_set_lang=SiSU_Env::Standardise_language.new.file_to_language(@fns)
      @cf=/([a-zA-Z0-9]+)/.match(cf)[1]
      env=SiSU_Env::Env_call.new(@fns)
      @fnb=env.fnb
      @dir=SiSU_Env::Info_dir.new(@fns)
      fn_set_lang=SiSU_Env::Standardise_language.new.file_to_language(@fns)
      @fnl=@dir.lang_filename(fn_set_lang[:c])
      @fn=SiSU_Env::Env_call.new(@fns).lang(fn_set_lang[:c])
      @m_regular=/(.+?)\.(?:[_-]?sst|ssm)$/
      @path=SiSU_Env::Info_dir.new(@fns)
      @webserv_url=@path.tell_output_location
      @tool=@dir.text_editor
      @editor=@dir.text_editor
      @browser=@dir.web_browser
      @console_browser=@dir.console_web_browser
      @pdf_viewer=@dir.pdf_viewer
      @odf_viewer=@dir.odf_viewer
      @u ||= {
        'a (plaintext (footnotes))'=>@fn[:plain],
        'A (plaintext (footnotes) dos)'=>@fn[:plain],
        'b (XMTML sax)'=>@fn[:xhtml],
        'B (Docbook XML)'=>@fn[:docbook],
        'D[iu] (DBI import/update postgresql)'=>'dbi psql',
        'd[iu] (DBI import/update sqlite)'=>'dbi sqlite',
        'e (plaintext (endnotes))'=>@fn[:plain],
        'E (plaintext (endnotes) dos)'=>@fn[:plain],
        'h (html segmented)'=>@fn[:toc],
        'h (html scroll)'=>@fn[:doc],
        'I (info file)'=>'info',
        'm (metaverse)'=>'meta',
        'N (md5 digests)'=>@fn[:digest],
        'o (opendocument)'=>@fn[:odf],
        'p (pdf landscape)'=>@fn[:pdf_l],
        'p (pdf portrait)'=>@fn[:pdf_p],
        'P[iu] (DB postgresql import/update)'=>'psql',
        's (sisu markup)'=>"#@fns",
        'S (sisudoc)'=>'sisudoc.tgz',
        'x (XML sax type)'=>@fn[:sax],
        'X (XML dom type)'=>@fn[:dom],
        'y (manifest html)'=>@fn[:manifest],
        'w (word map)'=>@fn[:wmap],
      }.sort {|a,b| a[0].downcase<=>b[0].downcase}
    end
    def songsheet
      begin
        urls_all if @cf=~/U/
        urls_select if @cf=~/[uvVM]/
      rescue: SiSU_Errors::Info_error.new($!,$@,@cf,@fns).error
      ensure
      end
    end
    def urls_maintenance(cf,x,y)
      if x=~/^([aAbBceEhHmNopwxXy])/ and cf=~/[aAbBceEhHmNopwxXy]/ and x=~/^[#{cf}]/
        m=$1
        f=y
        tool=@editor
        if x =~/^m/ and @cf=~/m/ and x=~/^[#{cf}]/ and @cf =~/M/
          tell=SiSU_Screen::Ansi.new(@cf,"-#{x}","#@editor #{@dir.metaverse}/#@fns.meta")
          tell.maintenance unless @cf =~/q/
          if cf =~ /[hH]/i
            tell=SiSU_Screen::Ansi.new(@cf,"-#{x}","#@editor #{@dir.tune}/#@fns.tune")
            tell.maintenance unless @cf =~/q/
          end
        end
        if x=~/^([hHw])/ and @cf=~/[hHw]/ and x=~/^[#@cf]/
          f=if x !~/segmented/: "#{y}.html"
          else                  "#{y}.index.html"
          end
        end
        if x=~/^p/ and @cf=~/p/ and x=~/^[#@cf]/
          tool=@pdf_viewer
          if cf =~/M/
            fns=@fns.gsub(/~/,'-')
            tell=if y =~/landscape/
              SiSU_Screen::Ansi.new(@cf,"-#{x}","#@editor #{@dir.tex}/#{fns}.landscape.tex")
            else SiSU_Screen::Ansi.new(@cf,"-#{x}","#@editor #{@dir.tex}/#{fns}.tex")
            end
            tell.maintenance unless @cf =~/q/
          end
        end
        if x=~/^o/ and @cf=~/o/ and x=~/^[#@cf]/
          tool=@odf_viewer
        end
        if x !~/^m/
          tell=SiSU_Screen::Ansi.new(@cf,"-#{x}","#{tool} #{@dir.data_o}/#@fnb/#{y}")
          tell.maintenance unless @cf =~/q/
        end
        @cf.gsub!(/#{m}/,'')
      end
    end
    def urls_select
      tell=SiSU_Screen::Ansi.new(@cf,"URLs")
      tell.greyTitleHi unless @cf =~/q/
      tell=SiSU_Screen::Ansi.new(@cf,@fns,"#{@dir.data_o}/#@fnb")
      tell.flow unless @cf =~/q/
      m=/.+\/(\S+)/im
      @pwd_stub="#@webserv_url"[m,1]
      @u.each do |x,y|
        if @fns =~ @m_regular
          if x=~/^([aAbBceEhHNopsSwxXy])/ and @cf=~/[aAbBceEhHNopsSwxXy]/ and x=~/^[#@cf]/
            m=$1
            tell=SiSU_Screen::Ansi.new(@cf,"-#{x}","#@browser #@webserv_url/#@fnb/#{y}")
            tell.result unless @cf =~/q/
            @cf.gsub!(/#{m}/,'')
          end
          if x=~/^I/ and @cf =~/I/
            tell=SiSU_Screen::Ansi.new(@cf,"-#{x}","cd #{@path.texinfo}; pinfo ./#@fnb.#{y}; cd -")
            tell.result unless @cf =~/q/
            @cf.gsub!(/I/,'')
          end
          if x=~/^D/ and @cf =~/D/
            tell=SiSU_Screen::Ansi.new(@cf,"-#{x} DBI psql","#@pwd_stub::#@fns",y)
            tell.result unless @cf =~/q/
            @cf.gsub!(/D[iu]/,'')
          end
          if x=~/^d/ and @cf =~/d/
            tell=SiSU_Screen::Ansi.new(@cf,"-#{x} DBI sqlite","sqlite #{@dir.data_o}/sisu_sqlite.db", "#{y}")
            tell.result unless @cf =~/q/
            @cf.gsub!(/d[iu]/,'')
          end
          if x=~/^P/ and @cf =~/P/
            tell=SiSU_Screen::Ansi.new(@cf,"-#{x} Psql","#@pwd_stub::#@fns",y)
            tell.result unless @cf =~/q/
            @cf.gsub!(/P[iu]/,'')
          end
          urls_maintenance(@cf,x,y) if @cf =~/[MV]/
        end
      end
    end
    def urls_all
      tell=SiSU_Screen::Ansi.new(@cf,'URLs')
      tell.greyTitleHi unless @cf =~/q/
      tell=SiSU_Screen::Ansi.new(@cf,@fns,"#{@dir.data_o}/#@fnb")
      tell.flow unless @cf =~/q/
      @u.each do |x,y|
        tell=case x
        when /^m/
          SiSU_Screen::Ansi.new(@cf,"-#{x}","#{@dir.text_editor} ~#{y}/#@fnb.#{y}")
        when /^[aAbBcdeEhHNpswxXy]/
          tellx=SiSU_Screen::Ansi.new(@cf,"-p (latex)","#{@dir.text_editor} ~work/tex_rz/#@fnb.tex") if y=~/landscape/
          SiSU_Screen::Ansi.new(@cf,"-#{x}","#@browser #@webserv_url/#@fnb/#{y}")
        when /^I/
          SiSU_Screen::Ansi.new(@cf,"-#{x}","cd #{@path.texinfo}; pinfo ./#@fnb.#{y}; cd -")
        end
        tellx.result if tellx
        tell.result if tell
        tellx=nil
      end
    end
  end
end
__END__
