=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: Vocabulary, wordlist legal, lex, (first used by wordmap)
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module Wordlists
  require "#{SiSU_lib}/vocab"
  class Lists
    def initialize
    end
    #/<i>(?:[a-z0-9]+[\b\s]+){2,7}?<\/i>|(?:
    #/<i>(?:[a-zA-Z0-9]+[\s]*){2,7}?<\/i>|(?:
    #/<i>(?:[\S]+[\s]*){2,7}<\/i>|http:\/\/\S+|(?: #demands much processing ! cannot use :-(
    #/<i>(?:[\S]+[\s]*){2,7}?<\/i>|http:\/\/\S+|(?:
    #/<i>(?:\S+\s*){1,7}?<\/i>|(?: 
      #/<i>(?:[\S]+[\s]*){2,7}?<\/i>|http:\/\/\S+|(?:
    def scanlist
      #/<i>(?:[\w0-9"]+[\s]*){2,7}?<\/i>|http:\/\/\S+|(?:
      /(?:
      a|advance payments?|actions? for annulment|alternative dispute resolution|anticipatory breach|applicable law|arbitral (?:courts?|institutions?)|arbitral process|arbitral tribunal|arbitration agreement|arbitration awards?|arbitration between states|arbitration clause|arbitration rules?|autonomous contract|autonomy of contract|autonomy of parties|
      b|bilateral agreement|bill of exchange|bill of lading|binding agreementss?|breach of contract|buyer's obligations?|buyer's rights?|
      c|carriage of goods(?: by sea)|choice of law|commercial dispute|conformity of (?:contract|documents|goods)|contemporaneous performance|contra proferentem|contract of (?:carriage|insurance|sale)|contract rate|contract(?:ual)? price|cost of (?:carriage|credit|goods|insurance|transport(?:ation)?)|cross examination|currency regulations?|
      d|date of (?:delivery|payment|shipment)|delivery (?:date|of (?:substitute )?goods)|delocalisation theory|discovery of documents|dispute resolution|dissenting opinions?|distributorship agreements?|due process|
      e|employment agreements?|enforceability of award|equality of treatment|equity and good concience|equity clauses?|european convention|european (?:economic )?community|european union|examination (?:in chief|of goods)|excess of authority|exclusion (?:of claims|of convention|period)|ex parte|
      f|factoring convention|federal states?|force majeure|formal requirements?|fundamental breach|future disputes?|
      g|gap filling|general (?:business conditions|conditions of business|terms)|general principles?(?: of law)?|geneva convention|good faith|grain and feed trade association|governing law|
      h|harmoni[sz]ation of laws?|
      i|identification of goods|immediate (?:delivery|payment)|institutional rules|intellectual property(?: rights?)?|interim awards?|international bank for reconstruction and development|international bar association|international centre for the settlement of investment disputes|international chamber of commerce|investment securities|
      j|judicial proceedings?|
      l|lack of conformity|language of hearings?|league of nations|legal (?:remed(?:ies|y)|rights?)|letter of credit|lex fori|lex mercatoria|lex loci contractus|limitation period|
      m|majority awards?|matrimonial disputes?|maximum period|mini trials?|minutes of meetings?|minutes of trials?|model law|monetary payments?|moral obligations?|moveable goods|
      n|nachfrist notice|national law|new international economic order|notice of non-?conformity|number of|
      o|obligation to(?: dispatch|give (?:advice|notice)|preserve(?: goods)?)?|
      p|partial (?:delivery|performance)|party autonomy|passing of risk|payment (?:by install?ments|in advance|guarantees?|of price)|peace palace|period (?:for payment|of delivery|of performance|of time)|permanent court of international justice|personal injury|preliminary meetings?|possessory rights?|preliminary steps?|preservation of goods|private international law|procedural (?:law|orders?)|products? liability|professional institutions?|promissory notes?|public international law|
      r|reasonable (?:bystander|man|men|person)\b|red book|regional conventions?|registration of awards?|resolution of disputes?|retention of title|revocation of offer|right (?:of|to) (?:delivery?|perform|performance|reject(?:ion)?|refuse|refusal|retain|retention)|
      s|sea waybill|seat theory|separate opinions|security for credit|separation of powers|seller'?s obligations?|seller's rights?|set off|settlement of disputes?|shipping instructions|sovereign immunity|specific performance|stabilisation clauses?|statement of reasons?|submission agreements?|substantive issues?|substantive law|suspension of performance|
      t|taking delivery|temporary (?:impediment|injunction)|terms of (?:payment|reference|trade)|third[ -]part(?:y|ies)(?: claims?| rights)?|terms of reference|time (?:limits?|of payment)|trade associations?|trade marks?|trade usages?|transfer of (?:obligations?|rights?)|
      u|unification of law|uniform (?:interpretation|rules)|use of goods|
      w|warehouse (?:certificates?|receipt)|
      x|
      y|
      z|
      conventions|new york convention on recognition and enforcement of arbitral awards|united nations conference on international trade law|
      cities|new york|los angeles|san fransisco|
      countries|hong kong|united kingdom|united states(?: of america)?|
      zz|\w+)/i
    end
    def special #the idea is that words like contract, arbitration, buyer, seller should be left intact in scanlist but captured if in a term here, information should not be duplicated in the two lists !
      #/<i>(?:[\w0-9"]+[\s]*){2,7}?<\/i>|http:\/\/\S+|(?:
      /<i>(?:[\w0-9"]+[\s]*){2,7}<\/i>|<b>(?:[\w0-9"]+[\s]*){2,7}<\/b>|https?:\/\/\S+|ftp:\/\/\S+|(?:
      a|add hoc(?: arbitration)?|agreement to arbitrate|american arbitration association|avoidance of (?:\S+\s+){0,2}contract|
      b|
      c|claim (?:\S+\s+){0,4}(?:damages|restitution)|commencement of arbitration|conclusion of (?:the )?contract|court of arbitration|
      d|domestic arbitration|
      e|
      f|formation of (?:\S+\s+){0,2}contract|fundamental breach (?:\S+\s+){1,2}contract|
      g|
      h|
      i|informal arbitrations?|install?ment contracts?|institutional arbitration|international arbitration|
      j|joint debtors?|
      l|language of (?:the )?arbitration|leasing contract|liquidated damages|(?:buyer|seller) loses? the right|
      m|mitigation of (?:damages?|loss)|
      n|nuclear damage|
      o|
      p|panels? of arbitrators|performance of (?:the)?contract|permanent court of arbitration|place of (?:arbitration|business|payment|performance)|preparation of contract|presiding arbitrators?|
      r|regulation of international arbitration|removal of arbitrators?|right (?:\S+\s+){0,3}to (?:declare the contract avoided|claim(?: damages)?)|right or claim of (?:a|the) third party|right to rely on|
      s|statutory arbitrations?|
      t|termination of contract|trade arbitrations?|
      u|
      w|
      x|
      y|
      institutions|american bar association|international montetary fund|london court of international arbitration|united nations|world bank|world intellectual property organi[sz]ation|world trade organi[sz]ation|
      zz|(?:buyer's|seller's) right|
      zz|\w+)/i
    end
    def greater #line break will not be matched
      /^(?:
      a|arbitrat(e|ors?|ions?)|anticipatory|assurance|
      b|breach|
      c|care|commercial|consideration|contract|cost|credit|
      d|damages|duty|effect|enforce[ds]?|evidence|examples?|exchange|exception|exclude[ds]?|exclusion|exclusive|excuse[ds]?|executed?|exempt(?:s|ed|ing)?|excercise[ds]?|expir[ey]|
      f|fair|fees?|finance|(un)?foreseeab(ility|le)|form|free|freight|frustration|full|fundamental|
      g|general||global(ly)?|goods|govern(?:ed|ing|s)?|greater|grounds|
      h|harm|
      i|impact|impede|impediment|impracticab(ility|le)|inform|information|installments?|insur(ance|e[ds]?)|intent(ion|ional|ionally)?|interest|international(ly)?|interpret(ation)?|
      l|law(s|yers?)?|limit(ation|ed|ing|s)?|
      m|mitigat(e|ed|ing|ion)|model|modern|monetary|money|
      n|noti(ce|fy|fication)|neither|new|no|nor|
      o|oblig(ations?|ors?)|
      p|parol|part(?:ial|ies|y)|perform(ance)?|period|postal|preamble|preserve|principles?|procedur(e|al)|proceeds|provide(ed|s)|provisions?|purpose|
      r|rational|reasonable|recind|rectif(ication|y)|recourse|recovery?|reduction|reliance|relief|rely|remed(ies|y|ying)|reports?|requests?|require(s|ments)?|reservation|review|revis(e|ion|ed)|retain(ed|er)|rights?|rule(s|ed)?|ruling|
      s|sales?|secretary|section|service|sources?|status|standard|sufficient|
      t|terminat(e|ed|ion)|tort|trade(er|ing)?|transnational|treaty|
      u|uniform(ity)?
      z)$/i
    end
  end
end
__END__

