=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download
 * Description: Document skin used for Free as in Freedom 
 * License: Same as SiSU see http://www.jus.uio.no/sisu
 * Notes: Site default appearance variables set in defaults.rb
     Generic site wide modifications set here scribe_skin.rb, and this file required by other "scribes" instead of defaults.rb
=end
module SiSU_Viz
  require "#{SiSU_lib}/defaults"
	include SiSU_Viz
  class Home
    def index
    end
    def toc
    end
  end
  class Path
    def root                                                                     # the only parameter that cannot be changed here
      './sisu/'
    end
    def rel
      '../'
    end
  end
  class Url
    def home
      'http://www.gnu.org'
    end
    def site                                                                     # used in pdf header
      'http://www.gnu.org'
    end
    def txt                                                                      # text to go with url usually stripped url
      'www.gnu.org'
    end
    def home_url
      '../index.html'
    end
    #def root_http
      #root server path info, used in document information
    #end
  end
  class Color
    def band1
      '"#cccccc"'      
      #'"#000070"'      
    end
  end
  class Txt
    def hp
    	'Free as in Freedom'
    end
    def home                                                                     # this should be the name of the site eg. Lex Mercatoria or if you prefer to see a url the url in text form copy & ...
      #"www.jus.uio.no/sisu/" 
    	'Free as in Freedom'
    end
  end
  class Icon
    def home_button
      'free_as_in_freedom.png'
    end
    def home_banner
      self.home_button
    end
  end
  class Banner
    def home_button
		  %{<table summary="home button" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor="#cccccc"><a href="#{@url.site}/">#{@png.home}</a></td></tr></table>\n}
    end
    def home_and_index_buttons
	    %{<table><tr><td width="20%"><table summary="home and index buttons" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor="#cccccc"><a href="#{@url.site}/" target="_top">#{@png.home}</a>#{@table.close}</td><td width="60%"><center><center><table summary="buttons" border="1" cellpadding="3" cellspacing="0"><tr><td align="center" bgcolor="#f1e8de"><font face="arial" size="2"><a href="toc" target="_top">&nbsp;This&nbsp;text&nbsp;sub-&nbsp;<br />&nbsp;Table&nbsp;of&nbsp;Contents&nbsp;</a></font>#{@table.close}</center></center></td><td width="20%">&nbsp;#{@table.close}}
    end
    def band
      %{<table summary="band" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor="#cccccc"><a href="#{@url.site}/" target="_top">#{@png.home}</a>#{@table.close}}
    end
    def home_guide
    end
  end
  class Credits
    def levitating_gnu
      '<center><a href="http://www.fsf.org/"><img border="0" height="133" width="135" src="../_sisu/image_local/levitating_gnu.png" alt="RMS/FSF - Levitating Gnu --&gt;" /></a></center>'
    end
    def credits
      %{<center><table summary="credits" align="center"bgcolor="#ffffff"><tr><td><font color="#666666">#{levitating_gnu}#{@widget.sisu}#{@widget.wayBetter}#{@widget.browsers}#{@widget.pdfviewers}</font></center></td></tr></table></center>}
    end
  end
  class Tex
    def header_center
	    "\\chead{\\href{#{@url.site}/}{www.jus.uio.no/sisu/}}"
    end
    def home_url
	    "\\href{#{@url.site}/}{www.gnu.org}"
    end
    def home
	    "\\href{#{@url.site}/}{GNU - Free Software Foundation}"
    end
    def owner_chapter
      "Document owner details"
    end
  end
  class Stamp
    def stmp
  	  "\\copyright Ralph Amissah to be released under the GPL (or QT License equivalent as to be decided) \\\\\n ralph@amissah.com \\\\\n www.jus.uio.no/sisu/"
    end
  end
end
