=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph@Amissah.com
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download
 * Description: Document skin for SiSU descriptive pages, ... 
 * License: Same as SiSU see http://www.jus.uio.no/sisu
 * Notes: Site default appearance variables set in defaults.rb
     Generic site wide modifications set here scribe_skin.rb, and this file required by other "scribes" instead of defaults.rb
=end
module SiSU_Viz
  require "#{SiSU_lib}/defaults"
	include SiSU_Viz
  class Path
    def root
      './sisu/'                                                                  # the only parameter that cannot be changed here
    end
    def rel
      '../'
    end
  end
  class Url
    def home
      'http://www.jus.uio.no/sisu/'
    end
    def site                                                                     # used in pdf header
      'http://www.jus.uio.no/sisu' 
    end
    def txt                                                                      # text to go with url usually stripped url
      'www.jus.uio.no/sisu/'
    end
    def home_url
      '../index.html'
    end
    #def root_http
      #root server path info, used in document information
    #end
  end
  class Color
    def band1
      '"#ffffff"'      
    end
    def band2
      '"#ffffff"'
    end
  end
  class Txt
    def hp
    	%{&nbsp;SiSU}
    end
    def home
      #"www.jus.uio.no/sisu/" 
      'SiSU' 
    end
  end
  class Icon
    def home_button
      'sisu.home.png'
    end
    def home_banner
      self.home_button
    end
  end
  class Banner
    def home_button
		  %{<table summary="home button" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor="#ffffff"><a href="#{@url.site}/">#{@png.home}</a></td></tr></table>\n}
    end
    def home_and_index_buttons
	    %{<table><tr><td width="20%"><table summary="home and index buttons" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor="#ffffff"><a href="#{@url.site}/" target="_top">#{@png.home}</a>#{@table.close}</td><td width="60%"><center><center><table summary="buttons" border="1" cellpadding="3" cellspacing="0"><tr><td align="center" bgcolor="#ffffff"><font face="arial" size="2"><a href="toc" target="_top">&nbsp;This&nbsp;text&nbsp;sub-&nbsp;<br />&nbsp;Table&nbsp;of&nbsp;Contents&nbsp;</a></font>#{@table.close}</center></center></td><td width="20%">&nbsp;#{@table.close}}
    end
    def band
      %{<table summary="band" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor="#ffffff"><a href="#{@url.site}/" target="_top">#{@png.home}</a>#{@table.close}}
    end
    def home_guide
    end
  end
  class Credits
    def credits
      %{<center><table summary="credits" align="center"bgcolor="#ffffff"><tr><td>#{@widget.sisu}#{@widget.wayBetter}#{@widget.browsers}#{@widget.pdfviewers}</td></tr></table></center>}
    end
  end
  class Tex
    def header_center
	    "\\chead{\\href{#{@url.site}/}{www.jus.uio.no/sisu/}}"
    end
    def home_url
	    "\\href{#{@url.site}/}{www.jus.uio.no/sisu/}"
    end
    def home
	    "\\href{#{@url.site}/}{Ralph Amissah}"
    end
    def owner_chapter
      "Document owner details"
    end
  end
  class Stamp
    def stmp
  	  "\\copyright Ralph Amissah, released under the GPL \\\\\n ralph@amissah.com \\\\\n www.jus.uio.no/sisu/"
    end
  end
  class Home
    def index
      <<WOK
<html><head>
<title>SiSU - Simple information Structuring Universe - Structured information, Serialized Units - software for electronic texts, documents, books, digital libraries in plaintext, html, xhtml, XML, ODF (OpenDocument), LaTeX, pdf, SQL (PostgreSQL and SQLite), and for search</title>
<meta name="dc.title" content="SiSU information Structuring Universe - Simple - information Structuring Universe,<br> SiSU is Structuring Unit<br> programme & program description, 2005" />
<meta name="dc.creator" content="Ralph Amissah" />
<meta name="dc.subject" content="ebook, epublishing, electronic book, electronic publishing, electronic document, electronic citation, data structure, citation systems, search, digital library" />
<meta name="dc.publisher" content="SiSU http://www.jus.uio.no/sisu" />
<meta name="dc.language" content="en" />
<meta name="dc.rights" content="Copyright Ralph Amissah" />
<meta name="generator" content="#@ver" />
<link rel="generator" href="http://www.jus.uio.no/sisu" />
<link rel="stylesheet" href="./_sisu/css/html.css" type="text/css" />      
<link rel="shortcut icon" href="./_sisu/image/rb7.ico" />
</head>
<body>
<!-- Divide: Top Band --!>
<div id="top_band">
<p class="top_band_image">
  <a href="http://www.jus.uio.no/sisu/SiSU" target="_top" >
    <img border="0" src="./_sisu/image/sisu.home.png" alt="SiSU &gt;&gt;">
  </a>
</p>
<h1 class="top_band">
  SiSU information Structuring Universe
</h1>
<h2 class="top_band_tiny">
  Structured information, Serialized Units
</h2>
<h2 class="top_band_tiny">
software for electronic texts, document collections, books, digital libraries, and search
</h2>
<h2 class="top_band_tiny">
 with "atomic search" and text positioning system (shared text citation numbering: "<i>ocn</i>")
</h2>
<h2 class="top_band_tiny">
outputs include: plaintext, html, xhtml, XML, ODF (OpenDocument), LaTeX, pdf, SQL (PostgreSQL and SQLite)
</h2>
</div>
<!-- Divide: Left Column --!>
<div id="column_left">
<p class="bold">
  <a href="http://www.jus.uio.no/sisu/SiSU" target="_top" >
    SiSU
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_description/1#summary" target="_top" >
    What does SiSU do? Summary
  </a>
  <a href="http://www.jus.uio.no/sisu/SiSU/1#summary" target="_top" >
    <sup>[*]</sup>
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_examples/1#books" target="_top" >
    Book Samples
  </a>
  <a href="http://www.jus.uio.no/sisu/SiSU/2#books" target="_top" >
    <sup>[*]</sup>
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_examples/1#markup" target="_top" >
    Markup Examples
  </a>
  <a href="http://www.jus.uio.no/sisu/SiSU/2#markup" target="_top" >
    <sup>[*]</sup>
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_description/1#ocn" target="_top" >
    Object Citation Numbering - <i>ocn</i>
  </a>
  <a href="http://www.jus.uio.no/sisu/SiSU/1#ocn" target="_top" >
    <sup>[*]</sup>
  </a>
</p>
<p class="tiny">(a text positioning system)</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_description/1#search" target="_top" >
    Search - "<i>Atomic</i>"
  </a>
  <a href="http://www.jus.uio.no/sisu/SiSU/1#search" target="_top" >
    <sup>[*]</sup>
  </a>
</p>
<p class="tiny">
  Of interest is the ease of streaming documents to a relational database, at an object (roughly paragraph) level and the potential for increased precision in the presentation of matches that results thereby. The ability to serialise html, LaTeX, XML, SQL, (whatever) is also inherent in / incidental to the design. For a description see the
  <a href="http://www.jus.uio.no/sisu/sisu_provisional_patent_application_200408" target="_top" >
    abandoned U.S. provisional patent application
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_license/license" target="_top" >
    License
  </a>
  <a href="http://www.jus.uio.no/sisu/SiSU/license" target="_top" >
    <sup>[*]</sup>
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_download/download" target="_top" >
    <b>Download</b>
  </a>
  <a href="http://www.jus.uio.no/sisu/SiSU/download" target="_top" >
    <sup>[*]</sup>
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_changelog/changelog" target="_top" >
    Changelog
  </a>
  <a href="http://www.jus.uio.no/sisu/SiSU/changelog" target="_top" >
    <sup>[*]</sup>
  </a>
</p>
<p>
  Gnu / Linux / Unix
</p>
<p class="tiny">
  -------------
</p>
<p>
  man pages: 
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/man/sisu.1" target="_top" >
    sisu.1
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/man/sisu.8" target="_top" >
    sisu.8
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/man/sisu_examples.1" target="_top" >
    sisu_examples.1
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/man/sisu_webrick.1" target="_top" >
    sisu_webrick.1
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/man/sisu_vim.1" target="_top" >
    sisu_vim.1
  </a>
</p>
<p class="tiny">
  document preparation can be on any platform, in any editor:
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sample" target="_top" >
    Markup Syntax
  </a>
</p>
<p class="tiny">
  -------------
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/SiSU" target="_top" >
    * Composite document
  </a>
</p>
<p class="tiny">
  the composite document is a superset of the following documents:
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_description" target="_top" >
    SiSU description
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_examples" target="_top" >
    SiSU examples
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_chronology" target="_top" >
    SiSU chronology
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_technical_info" target="_top" >
    SiSU technical
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_faq" target="_top" >
    SiSU FAQ
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_download" target="_top" >
    SiSU download
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_changelog" target="_top" >
    SiSU changelog
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_license" target="_top" >
    SiSU license
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_standard" target="_top" >
    SiSU standard
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_provisional_patent_application_200408" target="_top" >
    SiSU abandoned provisional patent
  </a>
</p>
<p class="tiny">
  Note: the placement of SiSU documents on the Net predate the release of SiSU.
</p>
</div>
<!-- Divide: Center Column --!>
<div id="column_center">
<p class="bold">
  For less markup than the most elementary HTML you can have so much more.
</p>
<p><a href="http://www.jus.uio.no/sisu/SiSU" target="_top" ><b>SiSU</b> - Structured information, Serialized Units</a> for Electronic Documents, is a document creation/management framework with the following features:</p>
<p><b>(i)</b> markup syntax: (a) simpler than html, (b) mnemonic, influenced by mail/messaging/wiki markup practices, (c) human readable, and easily writable,</p>
<p><b>(ii)</b> (a) minimal markup requirement, (b) single file marked up for multiple outputs,</p>
<p><b>(iii)</b> (a) multiple outputs include amongst others: html; pdf via LaTeX; (structured) XML; ODF (OpenDocument); sql - currently PostgreSQL (and SQLite); ascii, (also texinfo), (b) takes advantage of the strengths implicit in these very different output types, (e.g. pdfs produced using typsetting of LaTeX, databases populated with documents at an individual object/paragraph level, with implications for search possibilities...)</p>
<p><b>(iv)</b> provides a common object positioning and citation system for all outputs, which is human relevant and machine usable: <u><i>object citation numbering</i></u>, all objects (paragraphs, headings, verse, tables etc. and images) are numbered identically, for citation purposes, in all outputs (html, pdf, sql etc.),</p>
<p><b>(v)</b> use of Dublin Core and other meta-tags to permit the addition of some semantic information on documents, and making easy integration of rdf/rss feeds etc.,</p>
<p><b>(vi)</b> creates organised directory/file structure for (file-system) output, easily mapped with its clearly defined structure, with all text objects numbered, you know in advance where in each document output type, a bit of text will be found (eg. from an sql search, you know where to go to find the prepared html output or pdf etc.)... there is more; easy directory management and document associations, the document preparation (sub-)directory may be used to determine output (sub-)directory, the skin used, and the sql database used,</p>
<p><b>(vii)</b> search of document sets, at object/paragraph level, the relational database retains information on the document structure, and citation numbering makes it possible for example to present search matches as an index of documents and locations within the document where the match is found,</p>
<p><b>(viii)</b> "word maps" rudimentary index, consisting of all the words in a document and their (text/ object) locations within the text, (and the possibility of adding vocabularies),</p>
<p><b>(ix)</b> document content certification and comparison considerations: (a) the document and each object within it stamped with an md5 hash making it possible to easily check or guarantee that the substantive content of a document is unchanged, (b) version control, documents integrated with time based version control system, default RCS or CVS with use of $Id$ tag, which SiSU checks
<p><b>(x)</b> SiSU's minimalist markup makes for meaningful "diffing" of the substantive content of markup-files,</p>
<p><b>(xi)</b> easily skinnable, document appearance on a project/site wide, directory wide, or document instance level easily controlled/changed,</p>
<p><b>(xii)</b> in many cases a regular expression may be used (once in the document header) to define all or part of a documents structure obviating or reducing the need to provide structural markup within the document,</p>
<p><b>(xiii)</b> is a batch processor for handling large document sets, ... though once generated they need not be re-generated, unless changes are made to the desired presentation of a particular output type,</p>
<p><b>(xiv)</b> possible to pre-process, which permits: the easy creation of standard form documents, and templates/term-sheets, or; building of composite documents (master documents) from other sisu marked up documents, or marked up parts, i.e. import documents or parts of text into a main document should this be desired</p>
<p><b>(xv)</b> future proofing, a framework for adding further capability or updating existing capability as required: (a) modular, (thanks in no small part to Ruby) another output format required, write another module....(b) easy to update output formats (eg html, xhtml, latex/pdf produced can be updated in program and run against whole document set), (c) easy to add, modify, or have alternative syntax rules for input, should you need to,</p>
<p><b>(xvi)</b> scalability, dependent on your file-system (in my case Reiserfs) and on the relational database used (currently Postgresql and SQLite), and your hardware,</p>
<p><b>(xvii)</b> only marked up files need be backed up, to secure the larger document set produced,</p>
<p><b>(xviii)</b> document management,</p>
<p><b>(xix)</b> use your favourite editor, syntax highlighting files for markup, primarily (g)vim so far,</p>
<p><b>(xx)</b> remote operations: (a) run SiSU on a remote server, (having prepared sisu markup documents locally or on that server, i.e. this solution where sisu is installed on the remote server, would work whatever type of machine you chose to prepare your markup documents on), (b) alternatively, (assuming sisu is available to you locally but not installed on the remote server) configure sisu to securely copy (rsync or scp) its output to your remote host and run sisu locally, (c) request a remotely located sisu markup file and process it locally by identifying it by its' url.</p>
<br />
<p>More information on <a href="http://www.jus.uio.no/sisu/SiSU/"><b>SiSU</b></a> provided at <a href="http://www.jus.uio.no/sisu/SiSU/">www.jus.uio.no/sisu/SiSU</a></p>
</div>
<!-- Divide: Right Column --!>
<div id="column_right">
<p>
  More information on <a href="http://www.jus.uio.no/sisu/SiSU/"><b>SiSU</b></a> provided at:
  <a href="http://www.jus.uio.no/sisu/SiSU/">
    www.jus.uio.no/sisu/SiSU
  </a>
</p>
<p>SiSU was developed in relation to legal documents, and is strong across a wide variety of texts (law, literature...(humanities, law and part of the social sciences)). SiSU handles images but is not suitable for formulae/ statistics, or for technical writing at this time.</p>
<p>SiSU has been developed and has been in use for several years. Requirements to cover a wide range of documents within its use domain have been explored.</p>
<p>Some modules are more mature than others, the most mature being Html and LaTeX / pdf. PostgreSQL and search functions are useable and together with <i>ocn</i> unique (to the best of my knowledge). The XML output document set is "well formed" but largely proof of concept, as is the OpenDocument output which is a limited SiSU feature set (SiSU is interested in a very limited ODF feature set).</p>
<p>
<a href="mailto://ralph@amissah.com">
ralph@amissah.com
</a>
</p>
<p>
<a href="mailto://ralph.amissah@gmail.com">
ralph.amissah@gmail.com
</a>
</p>
<p class="tiny">
w3 since October 3 1993
</p>
</div>
</body>
</html>
WOK
    end
    def redirect
      <<WOK
<html><head>
<title>SiSU</title>
<meta http-equiv="refresh" content="0, url=http://www.jus.uio.no/sisu/SiSU/">
</head>
<body>
SiSU informtion provided at <a href="http://www.jus.uio.no/sisu/SiSU/">www.jus.uio.no/sisu/SiSU</a><p />
If your browser supports redirection, you will be escorted there shortly.
</body>
</html>
WOK
    end
  end
end

