=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: generates naive cgi search form for search of sisu database (pgsql sqlite)

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah mailto:ralph@amissah.com
   Ralph Amissah mailto:amissah@gmail.com

=end
module SiSU_CGI_sql
  class SiSU_CGI_common
    def initialize(webserv,cmd,port,webrick_port,url_base,dir)
      @webserv,@cmd,@port,@webrick_port,@url_base,@env=webserv,cmd,port,webrick_port,url_base,dir
    end
    def tail
      <<-WOK_SQL
      class Tail
        def tail
          <<-'WOK'
      <br /><hr /><br />
      <center><table align="center"bgcolor="#ffffff"><tr><td><font color="#666666"><table summary="" bgcolor="#ffffff" cellpadding="4" border="0" align="center">
      
      <tr align="center">
        <td align="center"><p class="center"><font color="#666666" size="2">
        presentations' look and feel<br />
        generated by<br />
        <a href="http://www.jus.uio.no/sisu" ><img border="0" src="#@url_base/sisu.png" alt="SiSU on Debian/Gnu/Linux or a FreeBSD &amp; Ruby - better ways, well actually, Way Better!" width="120" height="38"></a><br />
        <a href="http://www.jus.uio.no/sisu" >SiSU</a><br />
        version 0.37<br />2006w12/1 (20060320)<br />
      
        <table summary="SiSU rights" bgcolor="#ffffff" cellpadding="4" border="0" align="center" width="40%">
          <sup>&copy;</sup> Ralph Amissah<br />
        1993, current 2006<br />
        GPL 2<br />
        <i>w3 since October 3 1993</i><br />
        <a href="mailto://ralph@amissah.com" >ralph@amissah.com</a><br />
      </font></p>
      </td></tr></table>
      
      <p><center><font color="#666666" size="2">Developed<br />using <a href="http://www.ruby-lang.org/en/">Ruby</a><br />on <a href="http://www.debian.org/">Debian/Gnu/Linux</a> software infrastructure,<br />with the usual GPL (or OSS) suspects.<br />Better - "performance, reliability, scalability, security<br />& total cost of ownership"<br />[not to mention flexibility &amp; choice]<br /><br />&lt;&lt;<a href="http://www.jus.uio.no/sisu/">Way Better!</a>&gt;&gt;</font></center></p><tr align="center"><td align="center">
      
      <table summary="browser suggestions" bgcolor="#ffffff" cellpadding="4" border="0">
      <tr><td>
      <p>
      <font color="#666666" size="2">
      If you have problems viewing pages on this site please update your browser:
      </font>
      </p>
      </td></tr>
      </table>
      
      <table summary="browser suggestions" bgcolor="#ffffff" cellpadding="4" border="0">
      <tr><td>
      <p>
      <font color="#666666" size="1">
      <a href="http://www.gnome.org/projects/epiphany/" target="external">
      <img border="0" width="25" height="25" src="#@url_base/gnome.png" alt="Epiphany">
      &nbsp;Epiphany
      </a>
      <sup>&reg;</sup>&nbsp;|
      </font>
      </p>
      </td>
      
      <td>
      <p>
      <font color="#666666" size="1">
      <a href="http://galeon.sourceforge.net/" target="external">
      <img border="0" width="24" height="24" src="#@url_base/galeon.png" alt="Galeon">
      &nbsp;Galeon
      </a>
      <sup>&reg;</sup>&nbsp;|
      </font>
      </p>
      </td>
      
      <td>
      <p>
      <font color="#666666" size="1">
      <a href="http://www.microsoft.com/windows/ie/default.asp" target="external">
      <img border="0" width="29" height="25" src="#@url_base/internet.explorer.png" alt="MS I-Explorer">
      I-Explorer
      </a>
      <sup>&reg;</sup>&nbsp;|
      </font>
      </p>
      </td>

      <td>
      <p>
      <font color="#666666" size="1">
      <a href="http://kazehakase.sourceforge.jp/" target="external">
      Kazehakase</a>
      <sup>&reg;</sup>&nbsp;|</font></p>
      </td>

      <td>
      <p>
      <font color="#666666" size="1">
      <a href="http://www.konqueror.org/" target="external">
      <img border="0" width="29" height="25" src="#@url_base/konqueror.png" alt="Konqueror">
      Konqueror</a>
      <sup>&reg;</sup>&nbsp;|</font></p>
      </td>
      
      <td>
      <p>
      <font color="#666666" size="1">
      <a href="http://www.mozilla.org/" target="external">
      <img border="0" width="30" height="24" src="#@url_base/mozilla.png" alt="Mozilla">
      Mozilla
      </a>
      <a href="http://www.mozilla.org/products/firefox/" target="external">
      <img border="0" width="25" height="25" src="#@url_base/firefox.png" alt="Firefox">
      <b>Firefox</b>
      </a>
      <sup>&reg;</sup>&nbsp;|
      </font>
      </p>
      </td>
      
      <td>
      <p>
      <font color="#666666" size="1">
      <a href="http://home.netscape.com/comprod/mirror/client_download.html" target="external">
      <img border="0" width="29" height="25" src="#@url_base/netscape.png" alt="Netscape">
      Netscape
      </a>
      <sup>&reg;</sup>&nbsp;|
      </font>
      </p>
      </td>
      
      <td>
      <p>
      <font color="#666666" size="1">
      <a href="http://www.opera.com/" target="external">
      <img border="0" width="29" height="25" src="#@url_base/opera.png" alt="Opera">
      Opera
      </a>
      <sup>&reg;</sup>&nbsp;|
      </font>
      </p>
      </td>
      
      <td>
      <p>
      <font color="#666666" size="1">
      <a href="http://www.apple.com/safari/" target="external">
      <img border="0" width="24" height="25" src="#@url_base/safari.png" alt="Safari">
      Safari
      </a>
      <sup>&reg;</sup>
      </font>
      </p>
      </td></tr>
      </table>
      
      <table summary="lightweight browser and text browser suggestions" bgcolor="#ffffff" cellpadding="4" border="0">
      <tr><td>
      <p>
      <font color="#666666" size="1">
      for console/text viewing:
      </font>
      </p>
      </td>
      <td>
      <p>
      <font color="#666666" size="1">
      <a href="http://elinks.or.cz/" target="external">
      <b>elinks</b>
      </a>&nbsp;|
      </font>
      </p>
      </td>
      
      <td>
      <p>
      <font color="#666666" size="1">
      <a href="http://atrey.karlin.mff.cuni.cz/~clock/twibright/links" target="external">
      <b>links2</b>
      </a>&nbsp;|
      </font>
      </p>
      </td>
      
      <td>
      <p>
      <font color="#666666" size="1">
      <a href="http://w3m.sourceforge.net/" target="external">
      <b>w3m</b>
      </a>
      </font>
      </p>
      </td>
      
      <td>
      <p>
      <font color="#666666" size="1">
      for lightweight gui (X) viewing try:
      </font>
      </p>
      </td>
      <td>
      <p>
      <font color="#666666" size="1">
      <a href="http://www.dillo.org/" target="external">
      Dillo
      </a>&nbsp;|</font></p>
      </td>
      
      <td>
      <p>
      <font color="#666666" size="1">
      <a href="http://www.gnome.org/projects/epiphany/" target="external">
      <img border="0" width="25" height="25" src="#@url_base/gnome.png" alt="Epiphany">
      &nbsp;Epiphany
      </a>
      <sup>&reg;</sup>&nbsp;|
      </font>
      </p>
      </td>
      
      <td>
      <p>
      <font color="#666666" size="1">
      <a href="http://galeon.sourceforge.net/" target="external">
      <img border="0" width="24" height="24" src="#@url_base/galeon.png" alt="Galeon">
      &nbsp;Galeon
      </a>&nbsp;|
      </font>
      </p>
      </td>
      
      <td>
      <p>
      <font color="#666666" size="1">
      <a href="http://atrey.karlin.mff.cuni.cz/~clock/twibright/links" target="external">
      <b>links2 -g</b>
      </a>
      </font>
      </p>
      </td></tr>
      </table>
      </td></tr>
      
      <tr align="center"><td align="center">
      
      <table summary="pdf viewer suggestions" bgcolor="#ffffff" cellpadding="4" border="0">
      
      <tr><td>
      <p class="center">
      <font color="#666666" size="1">
      &amp; for
      <a href="http://www.adobe.com/products/acrobat/adobepdf.html" target="external">
      pdf
      </a>
      viewings of this site we recommend stand alone viewers
      <br />
      (rather than web browser plugins):
      </font>
      </p>
      </td></tr>
      </table>
      
      <table summary="" bgcolor="#ffffff" cellpadding="4" border="0" align="center">
      <tr align="center"><td align="center">
      <p class="center">
      <font color="#666666" size="1">
      <a href="http://www.adobe.com/products/acrobat/readstep2.html" target="external">
      <img border="0" height="18" width="15" src="#@url_base/b_pdf.png" alt="Adobe Acrobat Reader">
      Acrobat Reader
      </a>
      <sup>&reg;</sup>
      &nbsp;|
      </font>
      </p>
      </td>
      
      <td>
      <p class="center">
      <font color="#666666" size="1">
      <a href="http://www.gnome.org/projects/evince/" target="external">
      <img border="0" width="25" height="25" src="#@url_base/gnome.png" alt="Evince">
      <b>Evince</b>
      </a>
      <sup>&reg;</sup>
      </font>
      </p>
      </td>
      
      <td>
      <p class="center"><font color="#666666" size="1">
      <a href="http://www.cs.wisc.edu/~ghost/gv/" target="external">
      &nbsp;GhostView<sup>&reg;</sup>&nbsp;</a>,
      <a href="http://wwwthep.physik.uni-mainz.de/~plass/gv/" target="external">
      GV<sup>&reg;</sup>
      </a>
      &amp;
      <a href="http://www.cs.wisc.edu/~ghost/gsview/" target="external">
      GSview<sup>&reg;</sup>
      </a>
      &nbsp;|
      </font>
      </p>
      </td>
      
      <td>
      <p class="center">
      <font color="#666666" size="1">
      <a href="http://www.foolabs.com/xpdf/" target="external">
      <img border="0" width="16" height="16" src="#@url_base/xpdf.png" alt="Xpdf">
      &nbsp;Xpdf
      </a>
      <sup>&reg;</sup>
      </font>
      </p>
      </td></tr>
      </table>
      
      </font></center></td></tr></table></center> <a name="bottom" id="bottom"></a><a name="down" id="down"></a><a name="end" id="end"></a><a name="finish" id="finish"></a><a name="stop" id="stop"></a><a name="credits" id="credits"></a>
      </body></html>
      WOK
        end
      end
      WOK_SQL
    end
    def main1
      <<-'WOK_SQL'
      @counter_txt_doc,@counter_txt_ocn,@counter_endn_doc,@counter_endn_ocn=0,0,0,0
      @counters_txt,@counters_endn,@sql_select_body,@sql_select_endnotes='','','',''
      FCGI.each_cgi do |cgi|
        begin # all code goes in begin section
          @search=Hash.new
          @search[:text],@search[:endnotes]=Array.new,Array.new
          q=CGI.new
          @db=if cgi['db'] =~/\S+/: 
            @stub=/SiSU_(\S+)/.match(cgi['db'])[1] 
            cgi['db']
          else
            @stub='sisu'
            'SiSU_sisu'
          end
          checked_url,checked_searched,checked_tip,checked_echo,checked_sql,checked_all,checked_none,checked_ignore,selected_db='','','','','','','',''
          if cgi['view']=~/text/: checked_index,checked_text='','checked'
          else                    checked_index,checked_text='checked',''
          end
          checked_url='checked' if cgi['url'] =~/\S/ or cgi['u'].to_i==1 
          checked_searched='checked' if cgi['searched'] =~/\S/ 
          checked_tip='checked' if cgi['tip'] =~/\S/ 
          checked_echo='checked' if cgi['echo'] =~/\S/ 
          checked_sql='checked' if cgi['sql'] =~/\S/ 
          if cgi['checks'] =~/check_all/ or cgi['check_all'] =~/\S/ or cgi['a'].to_i==1 
            checked_all=checked_url=checked_searched=checked_tip=checked_echo=checked_sql='checked'
            checked_none='' 
          elsif cgi['checks'] =~/check_none/ #or cgi['a'].to_i==0 
            checked_none='checked'
            checked_all=checked_url=checked_searched=checked_tip=checked_echo=checked_sql='' 
          else checked_ignore='checked'
          end
      WOK_SQL
    end
    def main2
      <<-'WOK_SQL'
          search_field=cgi['find'] if cgi['find'] # =~/\S+/
          @search_for=Search_request.new(search_field,q) #.analyze               #% search_for
                                                                                 #% searches
          #Canned_search.new(@base,@search_for.text1,cgi)
          if @search_for.text1=~/\S+/ or @search_for.author=~/\S+/ #and search_field =~/\S/
            s1='s1=' + CGI.escape(@search_for.text1) if @search_for.text1=~/\S/
            key='key=' + CGI.escape(@search_for.keywords) if @search_for.keywords=~/\S/
            ti='&ti=' + CGI.escape(@search_for.title) if @search_for.title=~/\S/
            au='&au=' + CGI.escape(@search_for.author) if @search_for.author=~/\S/
            sj='&sj=' + CGI.escape(@search_for.subject) if @search_for.subject=~/\S/
            dsc='&dsc=' + CGI.escape(@search_for.description) if @search_for.description=~/\S/
            pb='&pb=' + CGI.escape(@search_for.publisher) if @search_for.publisher=~/\S/
            cntr='&cntr=' + CGI.escape(@search_for.contributor) if @search_for.contributor=~/\S/
            dt='&dt=' + CGI.escape(@search_for.date) if @search_for.date=~/\S/
            ty='&ty=' + CGI.escape(@search_for.type) if @search_for.type=~/\S/
            id='&id=' + CGI.escape(@search_for.identifier) if @search_for.identifier=~/\S/
            src='&src=' + CGI.escape(@search_for.source) if @search_for.source=~/\S/
            lang='&lang=' + CGI.escape(@search_for.language) if @search_for.language=~/\S/
            rel='&rel=' + CGI.escape(@search_for.relation) if @search_for.relation=~/\S/
            cov='&cov=' + CGI.escape(@search_for.coverage) if @search_for.coverage=~/\S/
            cr='&cr=' + CGI.escape(@search_for.rights) if @search_for.rights=~/\S/
            co='&co=' + CGI.escape(@search_for.comment) if @search_for.comment=~/\S/
            ab='&ab=' + CGI.escape(@search_for.abstract) if @search_for.abstract=~/\S/
            dtc='&dtc=' + CGI.escape(@search_for.date_created) if @search_for.date_created=~/\S/
            dti='&dti=' + CGI.escape(@search_for.date_issued) if @search_for.date_issued=~/\S/
            dtm='&dtm=' + CGI.escape(@search_for.date_modified) if @search_for.date_modified=~/\S/
            dta='&dta=' + CGI.escape(@search_for.date_available) if @search_for.date_available=~/\S/
            dtv='&dtv=' + CGI.escape(@search_for.date_valid) if @search_for.date_valid=~/\S/
            canned_search_url=if checked_all =~/checked/
              "#@base?#{s1}#{key}#{ti}#{au}#{sj}#{dsc}#{pb}#{cntr}#{dt}#{ty}#{id}#{src}#{lang}#{rel}#{cov}#{cr}#{co}#{ab}#{dtc}#{dti}#{dtm}#{dta}#{dtv}&db=#{cgi['db']}&view=#{cgi['view']}&a=1"
            #elsif checked_none =~/checked/
            #  "#@base?#{s1}#{key}#{ti}#{au}#{sj}#{dsc}#{pb}#{cntr}#{dt}#{ty}#{id}#{src}#{lang}#{rel}#{cov}#{cr}#{co}#{ab}#{dtc}#{dti}#{dtm}#{dta}#{dtv}&db=#{cgi['db']}&view=#{cgi['view']}&a=0"
            else "#@base?#{s1}#{key}#{ti}#{au}#{sj}#{dsc}#{pb}#{cntr}#{dt}#{ty}#{id}#{src}#{lang}#{rel}#{cov}#{cr}#{co}#{ab}#{dtc}#{dti}#{dtm}#{dta}#{dtv}&db=#{cgi['db']}&view=#{cgi['view']}&u=1&e=1"
            end      
            @search[:text][1]=%{documents.clean~'#{@search_for.text1}'} #s1
            @search[:endnotes][1]=%{endnotes.clean~'#{@search_for.text1}'} #s1
            canned_note='previous search url:'
          else
            canned_search_url="#@base?s1=United+Nations&db=documents&view=index"
            canned_note='search url example:'
          end
          if search_field =~/\S+/
            analyze_format=search_field.gsub(/\s*\n/,'; ')
          elsif checked_all =~/checked/ or checked_url =~/checked/
            canned_search=canned_search_url.scan(/(?:s1|au|ti)=[^&]+/)
            af=canned_search.join('; ')
            af.gsub!(/s1=/,'text: ')
            af.gsub!(/au=/,'author: ')
            af.gsub!(/ti=/,'title: ')
            af.gsub!(/%2B/,' ')
            analyze_format=af
            st=af.split(/\s*;\s*/)
            search_field=st.join("\n")      
          end
          green=%{<font size="2" color="#004000">}
          the_can=%{<font size="2" color="#666666">#{canned_note}<br> <a href="#{canned_search_url}">#{canned_search_url}</a></font><br>}
          p_text=p_keywords=p_title=p_author=p_subject=p_description=p_publisher=p_contributor=p_date=p_type=p_format=p_identifier=p_source=p_language=p_relation=p_coverage=p_rights=p_comment=p_abstract=p_subject=''
          p_text=%{text: #{green}#{@search_for.text1}</font><br>} if @search_for.text1 =~/\S+/
          p_keywords=%{keywords: #{green}#{@search_for.keywords}</font><br>} if @search_for.keywords =~/\S+/
          p_title=%{title: #{green}#{@search_for.title}</font><br>} if @search_for.title =~/\S+/
          p_author=%{author: #{green}#{@search_for.author}</font><br>} if @search_for.author =~/\S+/
          p_subject=%{subject: #{green}#{@search_for.subject}</font><br>} if @search_for.subject =~/\S+/
          p_description=%{description: #{green}#{@search_for.description}</font><br>} if @search_for.description =~/\S+/
          p_publisher=%{publisher: #{green}#{@search_for.publisher}</font><br>} if @search_for.publisher =~/\S+/
          p_contributor=%{contributor: #{green}#{@search_for.contributor}</font><br>} if @search_for.contributor =~/\S+/
          p_date=%{date: #{green}#{@search_for.date}</font><br>} if @search_for.date =~/\S+/
          p_type=%{type: #{green}#{@search_for.type}</font><br>} if @search_for.type =~/\S+/
          p_format=%{format: #{green}#{@search_for.format}</font><br>} if @search_for.format =~/\S+/
          p_identifier=%{identifier: #{green}#{@search_for.identifier}</font><br>} if @search_for.identifier =~/\S+/
          p_source=%{source: #{green}#{@search_for.source}</font><br>} if @search_for.source =~/\S+/
          p_language=%{language: #{green}#{@search_for.language}</font><br>} if @search_for.language =~/\S+/
          p_relation=%{relation: #{green}#{@search_for.relation}</font><br>} if @search_for.relation =~/\S+/
          p_coverage=%{coverage: #{green}#{@search_for.coverage}</font><br>} if @search_for.coverage =~/\S+/
          p_rights=%{rights: #{green}#{@search_for.rights}</font><br>} if @search_for.rights =~/\S+/
          p_comment=%{comment: #{green}#{@search_for.comment}</font><br>} if @search_for.comment =~/\S+/
          p_abstract=%{abstract: #{green}#{@search_for.abstract}</font><br>} if @search_for.abstract =~/\S+/
          search_note=<<-WOK
      <font size="2" color="#666666">
      <br><b>previous selection</b>:<br>
      database: #{green}#@db</font>; selected view: #{green}#{cgi['view']}</font><br>
      search string: "#{green}#{analyze_format}</font>"<br>
      #{p_text} #{p_keywords} #{p_title} #{p_author} #{p_subject} #{p_description} #{p_publisher} #{p_contributor} #{p_date} #{p_type} #{p_format} #{p_identifier} #{p_source} #{p_language} #{p_relation} #{p_coverage} #{p_rights} #{p_comment} #{p_abstract}
      </font>
      WOK
          #eg = %{canned search e.g.:<br> <a href="#{url}">#{url}</a><br>find: #{analyze}<br>database: #{database}}
          #dbi_canning
          @header=Form.new(@base,search_field,selected_db,checked_index,checked_text,checked_tip,checked_searched,checked_url,checked_echo,checked_sql,checked_all,checked_none,checked_ignore,search_note,the_can).submission_form #% form
          @tail=Tail.new.tail
          unless q['s1'] =~/\S/ or q['au'] =~/\S/ or @search[:text][1] =~/\S/ 
            print "Content-type: text/html\n\n"
            puts (@header+@tail)
          else #% searches
            s1=if @search_for.text1 =~/\S/
              @search_for.text1
            else 'Unavailable'
            end
            @search[:text]<<%{documents.clean~'#{CGI.unescape(s1)}'}
            @search[:endnotes]<<%{endnotes.clean~'#{CGI.unescape(s1)}'}
          #dbi_request
            dbi_statement=Dbi_search_statement.new(@conn,@search_for,q)
            @text_search_flag=false
            @text_search_flag=dbi_statement.text_search_flag
            s_contents=dbi_statement.contents
            s_endnotes=dbi_statement.endnotes
            @body_main=Array.new
            @endnotes=Array.new
            oldtid=0
            if @text_search_flag 
              if checked_sql =~/\S/
                sql_select_body=dbi_statement.sql_select_body_format
                sql_select_endnotes=dbi_statement.sql_select_endnotes_format
              else sql_select_body,sql_select_endnotes='',''
              end
              @body_main << "<p><hr><br><b>Main Text:</b><br>" << sql_select_body
              @endnotes  << "<p><hr><br><b>Endnotes:</b><br>"  << sql_select_endnotes
            else
            end
            #text_objects_body
            s_contents.each do |c|                                               #% text body
              location=c["filename"][/(.+?)\.(?:_?sst|ssm)$/,1]
              file_suffix=c["filename"][/.+?\.(_?sst|ssm)$/,1]
            #metadata_found_body
              if c["tid"].to_i != oldtid.to_i
                title=%{<a href="#@hosturl/#@stub/#{location}/">#{c["title"]}</a> by #{c["creator"]} <a href="#@hosturl/#@stub/#{location}/portrait.pdf"><img border="0" width="15" height="18" src="#@url_base/b_pdf.png" alt="pdf portrait"></a><a href="#@hosturl/#@stub/#{location}/landscape.pdf"><img border="0" width="18" height="15" src="#@url_base/b_pdf.png" alt="pdf landscape"></a><br>}  if file_suffix=~/s/ #hmm watch file_suffix
                 if @text_search_flag: title='<br><hr>'+title 
                 else                  title='<br>'+title 
                 end
                 @counter_txt_doc+=1
                 oldtid=c["tid"].to_i
                else                    title=''
                end
                if @text_search_flag 
                  if cgi['view']=~/text/                                         #% txt body
                    text=if c["suffix"] !~/1/ #seg
                      if @search_for.text1 =~/\S+/ or q['s1'] =~/\S+/                         #% only this branch is working !!
                        if @search_for.text1 =~/\S+/:     unescaped_search=CGI.unescape(@search_for.text1)
                        elsif q['s1'] =~/\S+/:           unescaped_search=CGI.unescape(q['s1'])
                        end
                        search_regex=Array.new
                        build=unescaped_search.scan(/\S+/).each do |g|
                           if g.to_s =~/(AND|OR)/
                             search_regex << '|'
                           else search_regex << %{#{g.to_s}}
                           end
                        end
                        search_regex=search_regex.join(' ')
                        search_regex=search_regex.gsub(/\s*\|\s*/,'|')
                        @search_regx=search_regex.to_s
                      end
                      matched_para=c["body"].gsub(/(#@search_regx)/i,%{<span style="background-color: #ffff48">\\1</span>})
                      %{<hr><p><font size="2">ocn <b><a href="#@hosturl/#@stub/#{location}/#{c["seg"]}.html##{c["ocn"]}">#{c["ocn"]}</a></b>:</font></p>#{matched_para}} 
                    elsif c["suffix"] =~/1/ #doc
                      %{#{title}<hr><p><font size="2">ocn #{c["ocn"]}:#{c["body"]}}
                    end
                    @counter_txt_ocn+=1
                    output=if c["seg"] =~/\S+/: title+text
                    else                        text 
                    end
                  elsif cgi['view']=~/index/                                     #% idx body
                    if c["suffix"] !~/1/ #seg
                      index=%{<a href="#@hosturl/#@stub/#{location}/#{c["seg"]}.html##{c["ocn"]}">#{c["ocn"]}</a>, } if @text_search_flag 
                    elsif c["suffix"] =~/1/ #doc
                      index=%{<a href="#@hosturl/#@stub/#{location}/doc.html##{c["ocn"]}">#{c["ocn"]}</a>, } 
                    end
                    if c["seg"] =~/\S+/ 
                      if @text_search_flag 
                        @counter_txt_ocn+=1
                        output=title+index
                      end
                    else
                      @counter_txt_ocn+=1
                      output=unless c["suffix"] =~/1/: title+index
                      else %{#{title}#{c["ocn"].sort}, }
                      end
                    end
                  end
                else output=title 
                end 
              @counters_txt=if @counter_txt_doc > 0
                %{<font size="2" color="#666666">Found in the main body of #@counter_txt_doc documents, and at #@counter_txt_ocn locations within.</font><br />}
              else ''
              end
              @body_main << output #+ details
            end
            #text_objects_endnote
            oldtid = 0
            s_endnotes.each do |e|                                               #% endnotes
              location=e["filename"][/(.+?)\.(?:_?sst|ssm)$/,1]
              file_suffix=e["filename"][/.+?\.(_?sst|ssm)$/,1]
            #metadata_found_endnotes
              if @text_search_flag
                if e["metadata_tid"].to_i != oldtid.to_i 
                  title=%{<br><hr><a href="#@hosturl/#@stub/#{location}/">#{e["title"]}</a> by #{e["creator"]} <a href="#@hosturl/#@stub/#{location}/portrait.pdf"><img border="0" width="15" height="18" src="#@url_base/b_pdf.png" alt="pdf portrait"></a><a href="#@hosturl/#@stub/#{location}/landscape.pdf"><img border="0" width="18" height="15" src="#@url_base/b_pdf.png" alt="pdf landscape"></a><br>}  if file_suffix=~/s/
                  @counter_endn_doc+=1
                  oldtid=e["metadata_tid"].to_i
                else title = ''
                end
                if cgi['view']=~/text/                                           #% txt endnotes
                  @counter_endn_ocn+=1
                  matched_endnote=e["body"].gsub(/(#@search_regx)/i,%{<span style="background-color: #ffff48">\\1</span>})
                  output=%{#{title}<hr><font size="2">note <b><a href="#@hosturl/#@stub/#{location}/endnotes.html##{e["nr"]}">#{e["nr"]}</a></b> referred to from ocn <a href="#@hosturl/#@stub/#{location}/doc.html##{e["ocn"]}">#{e["ocn"]}</a>:</font> #{matched_endnote}} 
                elsif cgi['view']=~/index/                                       #% idx endnotes
                  @counter_endn_ocn+=1
                  output=%{#{title}<a href="#@hosturl/#@stub/#{location}/endnotes.html#_#{e["nr"]}">#{e["nr"]}</a> [&sect; <a href="#@hosturl/#@stub/#{location}/doc.html##{e["ocn"]}">#{e["ocn"]}</a>], }
                end
                @counters_endn=if @counter_endn_doc > 0
                %{<font size="2" color="#666666">Found in the endnotes of #@counter_endn_doc documents, and at #@counter_endn_ocn locations within.</font><br />}
                end
                @endnotes << output #+ details
              else @endnotes=Array.new #does not take out yet
              end
            end
            cgi.out{@header + @counters_txt + @counters_endn + @body_main.join + @endnotes.join + @tail} #% print cgi_output_header+counters+body+endnotes
          end
        rescue Exception => e
          s='<pre>' + CGI::escapeHTML(e.backtrace.reverse.join("\n"))
          s << CGI::escapeHTML(e.message) + '</pre>'
          cgi.out{s}
          next
        ensure # eg. disconnect from server
          @conn.disconnect if @conn
        end
      end
      WOK_SQL
    end
  end
end
