=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: modules shared by flatfile output generators

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_text_parts_flatfile
  class Split_text_object
    @@dl=nil
    attr_reader :format,:text,:ocn,:lev_para_ocn
    def initialize(md,para)
      @md,@para=md,para
      @format,@ocn='null','null'
      #@format,@ocn=nil,nil
      @@dl ||=SiSU_Env::Info_dir.new.digest_length
    end
    def lev_segname_para_ocn 
      if @para =~/^(\d~|<:.+?>).+?<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{#{@@dl}}:[0-9a-f]{#{@@dl}}>.*/
        if /([1-6])~(\S+)\s+(\S.+?)<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{#{@@dl}}:[0-9a-f]{#{@@dl}}>/im.match(@para)
          @format,segname,@text,@ocn=$1,$2,$3,$4
          @format="#@format~#{segname}" # 
        elsif  /([1-6]~)\s+(\S.+?)<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{#{@@dl}}:[0-9a-f]{#{@@dl}}>/im.match(@para)
          @format,@text,@ocn=$1,$2,$3 #,$4
        elsif /<:(.+?)>\s*(\S.+?)<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{#{@@dl}}:[0-9a-f]{#{@@dl}}>/im.match(@para)
          @format,@text,@ocn=$1,$2,$3
        elsif /([1-6])~(\S+)\s+(\S.+?)<~(0);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{#{@@dl}}:[0-9a-f]{#{@@dl}}>/im.match(@para)
          @@alt_id_count+=1
          @format,segname,@text,@ocn=$1,$2,$3,"x#{@@alt_id_count}"
          @format="#@format~#{segname}" # 
        elsif /([1-6]~)\s+(\S.+?)<~(0);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{#{@@dl}}:[0-9a-f]{#{@@dl}}>/im.match(@para)
          @@alt_id_count+=1
          @format,@text,@ocn=$1,$2,"x#{@@alt_id_count}"
        end
      else
        if /(.+?)<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{#{@@dl}}:[0-9a-f]{#{@@dl}}>/im.match(@para)
          @text,@ocn=$1,$2
        end
        if @para !~/<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{#{@@dl}}:[0-9a-f]{#{@@dl}}>|^$/ #added 2002w06
          @text=/(.+?)/im.match(@para)[1]
        end
        if /^(\d)~(?:\S+)?\s+(.+)/im.match(@para)
          @format,@text=$1,$2
        end
      end
      @lev_para_ocn=if @para =~/.+<~\d+>/ #hmmm, watch
        Format::ParaSiSU.new(@md,@format,@text,@ocn)
      else Format::ParaSiSU.new(@md,@format,@text,'<~0>')
      end
      self
    end
  end
end
__END__

