=begin
 * Name: modify.rb
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download
 * Description: A conversion script for canned substitutions,
     a fairly generic simple tool that can be used to store other canned conversions,
     used here for altering SiSU markup

 * Copyright (C) 2004, 2006 Ralph Amissah

 * Packaged with: SiSU - Simple information Structuring Universe -
     Structured information, Serialized Units
 * SiSU Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com

 * Notes: configure rc in ~/.sisu/sisurc.yaml
=end
module SiSU_Modify
  require SiSU_lib + '/identify_markup'
  require SiSU_lib + '/convert_kdissert'
  class Convert_markup
    require 'fileutils'
    include FileUtils #::Verbose
    def initialize(opt)
      @opt=opt
      @description="This is a script that contains canned text conversions for reuse"
    end
    def current_match_and_replace
      convert_37_to_38
    end
    def message(text)
      response=''
      unless @opt.cmd=~/QQ/
        while response !~/yes/
          print %{
    #{  text}
    to   continue type "yes" [to exit type "no" or "quit"]: }
          response=File.new('/dev/tty').gets.strip
          @opt.cmd +='Q' if response =~/^yes$/
          exit if response =~/^(?:quit|no)$/
        end
      end
    end
    def help
    print <<WOK

#@description

sisu --convert --to38 [filename/wildcard]
  converts pre 0.37 sisu markup to 0.38 experimental
  [--37to38]

sisu --convert --to37 [filename/wildcard]
  converts pre 0.37 sisu markup to 0.38 experimental
  [--38to37]

sisu --convert --36to37 [filename/wildcard]
  converts pre 0.36 file-name, to 0.37 file-name
  [--36to37]

sisu --identify [filename]
  attempts to identify markup version used in file

sisu --query [version number]
  gives short summary of distinguishing characteristic
  of that version of markup

WOK
      exit
    end
    #%% substitutions to be made
    def convert_37_to_38
      message('convert sisu markup from 0.37 to 0.38')
      [
        [/^0~(\S+?)([+-])\s+/,    "@\\1:\\2 ",             //],          
        [/^0~(\S+)\s+/,           "@\\1: ",                //],
        [/^@toc:\s+/,             "@structure: ",          //],
        [/^1~/,                   ':A~',                   //],
        [/^2~/,                   ':B~',                   //],
        [/^3~/,                   ':C~',                   //],
        [/^4~/,                   '1~',                    //],
        [/^5~/,                   '2~',                    //],
        [/^6~/,                   '3~',                    //],
        [/1/,                     ':A',                    /^@(?:level|markup):\s/],
        [/2/,                     ':B',                    /^@(?:level|markup):\s/],
        [/3/,                     ':C',                    /^@(?:level|markup):\s/],
        [/4/,                     '1',                     /^@(?:level|markup):\s/],
        [/5/,                     '2',                     /^@(?:level|markup):\s/],
        [/6/,                     '3',                     /^@(?:level|markup):\s/]
      ]
    end
    def convert_38_to_37
      message('convert sisu markup from 0.38 to 0.37')
      [
        [/^@(\S+?):([+-])\s+/,    "0~\\1\\2 ",             //],
        [/^@(\S+?):\s+/,          "0~\\1 ",                //],
        [/^0~structure\s+/,       "0~toc ",                //],
        [/^1~/,                   '4~',                    //],
        [/^2~/,                   '5~',                    //],
        [/^3~/,                   '6~',                    //],
        [/^:?A~/,                 '1~',                    //],
        [/^:?B~/,                 '2~',                    //],
        [/^:?C~/,                 '3~',                    //],
        [/1/,                     '4',                     /^0~(?:level|markup)\s/],
        [/2/,                     '5',                     /^0~(?:level|markup)\s/],
        [/3/,                     '6',                     /^0~(?:level|markup)\s/],
        [/:?A/,                   '1',                     /^0~(?:level|markup)\s/],
        [/:?B/,                   '2',                     /^0~(?:level|markup)\s/],
        [/:?C/,                   '3',                     /^0~(?:level|markup)\s/]
      ]
    end
    def convert_filename_36_to_37
      @opt.files.each do |f|
        s=case f
        when /(\.s[1-3])$/: f.sub($1,'.sst')
        when /(\.r[1-3])$/: f.sub($1,'.ssm')
        when /(\.ri)$/: f.sub($1,'.ssi')
        else f
        end
        pwd=Dir.pwd
        unless f == s
          unless File.exist?("#{pwd}/#{s}")
            p "./#{f} -> ./#{s}"
            cp("#{pwd}/#{f}","#{pwd}/#{s}") 
          else "File already exists, < #{s} >  will not overwrite"
          end
        end
      end
    end
    def convert_kdi_to_38
      SiSU_Kdissert::Convert.new(@opt).read   # -w
    end
    def conversion
      #%% do it                                   -------------------------->
      if @opt.files and @opt.files.length > 0
        mr=nil
        #%% changes to make m match, r replace      -------------------------->
        if @opt.mod_s =~/--help/: help
        else
          message("#{@opt.files.join(', ')}\n\nWARNING, PROCEED AT YOUR OWN RISK,\npermanent changes requested for the above named files\n  best that you check (manually) what this file is set to do\n  conversions set are at the top of the file")
          mr=case @opt.mod_s
          when /(?:(?:37)?to38)/:     convert_37_to_38
          when /(?:(?:38)?to37)/:     convert_38_to_37
          when /(?:36to37)/:          convert_filename_36_to_37
          when /=kdi/:                convert_kdi_to_38
          when /convert|default/:     current_match_and_replace
          else help
          end
        end
        unless @opt.mod_s =~/kdi/
          match_and_replace=mr
          #start_processing =/not used in this example/i
          end_processing =/END\s+OF\s+FILE/
          i=@opt.fns
          if i =~/(?:\.sst|\.ssm|\.ssi)$/
            @new,@matched,@flag_start,@flag_end,@empty1,@empty2=true,false,false,false,false,false
            o="#{i}.bk" #o is for old
            markup_version=SiSU_Markup::Markup_identify.new(@opt).markup_version?
            if (@opt.mod_s=~/to37/ and markup_version=~/0.38/) or
               (@opt.mod_s=~/to38/ and markup_version=~/0.37/)
              p "#{i} #{markup_version}"
              file=File.open(i,'r')
              cont=file.readlines
              file.close
              cont.each do |y|
                match_and_replace.each do |m,r,w|
                  if y =~m and y =~w
                    if @new
                      @new=false
                      File.unlink(o) if File.exists?(o)
                      File.rename(i,o)
                      File.unlink(i) if File.exists?(i)
                      @file=File.new(i,'w')
                      @matched=true
                      break
                    end
                  end
                end
              end
              if @matched
                puts "conversion match in #{i}" unless @opt.cmd=~/q/
                @flag_start=true
                cont.each do |y|
                  if y =~end_processing
                    @flag_end=true
                  end
                  if @flag_start and not @flag_end
                    match_and_replace.each do |m,r,w|
                      if y =~m and y =~w
                        p m.to_s + ' -> ' + r unless @opt.cmd=~/q/
                        puts "in:  #{y}" if @opt.cmd=~/[vVM]/
                        y.gsub!(m,r) if m and r
                        puts "out: #{y}" if @opt.cmd=~/[vVM]/
                      end
                    end
                  end
                  if y=~/^\s*$/: @empty1=true
                  else           @empty1=false
                  end
                  @file.puts y unless (@empty1==true and @empty2==true)
                  if y=~/^\s*$/: @empty2=true
                  else           @empty2=false
                  end
                  #@file << y + "\n"
                end
                @file.close
              else puts "NO conversion match in #{i}" unless @opt.cmd=~/q/
              end
            else puts "Requested conversion <<#{@opt.mod_s}>> markup <<#{markup_version}>> identified in <<#{i}>>"
            end
          end
        end
      else puts "this routine makes permanent changes to the contents of the files matched, as instructed within [no matches]"
      end
    end
  end
end
#%% files to match for this conversion set  ------------------------->
require SiSU_lib + '/options'
argv=$*
#sisu_files=Dir.glob("[a-z]*.ss?")
@opt=SiSU_commandline::Options.new(argv)
puts "#@opt.cmd #@opt.files" if @opt.cmd =~/[VM]/
#match_and_replace=Array.new
case @opt.mod_s
when /=kdi/: 
  SiSU_Modify::Convert_markup.new(@opt).conversion 
when /(?:36|37|38)?to(?:37|38)|convert|default/: 
@opt.files.each do |fns|
  @opt.fns=fns
  SiSU_Modify::Convert_markup.new(@opt).conversion 
end
else 
  @opt.mod='--help'
 SiSU_Modify::Convert_markup.new(@opt).help
end
__END__
