# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: remote operations, get source from or copy output to remote server

=end
module SiSU_Remote
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  pwd=Dir.pwd
  class Put
    def initialize(opt)
      @opt=opt
      @dir=SiSU_Env::Info_env.new(@opt.fns)
      @put=unless @opt.fns =~/\.ssm\.sst$/; @opt.fns
      else @opt.fns.gsub(/(.+)?\.ssm\.sst$/,'\1.ssm')
      end
      @remote=SiSU_Env::Info_remote.new(@opt)
    end
    def scp
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'Remote placement ->',@put)
      tell.dark_grey_title_hi unless @opt.cmd =~/q/
      @remote.scp
    end
    def rsync
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'Remote placement ->',@put)
      tell.dark_grey_title_hi unless @opt.cmd =~/q/
      @remote.rsync
    end
    def scp_base
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'Remote placement of base site ->','excluding images')
      tell.dark_grey_title_hi unless @opt.cmd =~/q/
      @remote.scp_base
    end
    def scp_base_all
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'Remote placement ->','complete')
      tell.dark_grey_title_hi unless @opt.cmd =~/q/
      @remote.scp_base_all
    end
    def rsync_base
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'Remote placement ->','rsync')
      tell.dark_grey_title_hi unless @opt.cmd =~/q/
      @remote.rsync_base
    end
    def rsync_base_sync
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'Remote placement ->','rsync and sync')
      tell.dark_grey_title_hi unless @opt.cmd =~/q/
      @remote.rsync_base_sync
    end
    def rsync_sitemaps
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'Remote placement sitemaps ->','rsync')
      tell.dark_grey_title_hi unless @opt.cmd =~/q/
      @remote.rsync_sitemaps
    end
  end
  class Get
    def initialize(opt,get_s)
      @opt,@get_s=opt,get_s
      @msg,@msgs='',nil
      @tell=lambda { SiSU_Screen::Ansi.new(@opt.cmd,@msg,"#{@msgs.inspect if @msgs}") }
    end
    def fns
      require 'open-uri'
      require 'pp'
      require "#{SiSU_lib}/composite"
      @rgx_image=/(?:^|[^_\\])\{\s*(\S+?\.(?:png|jpg|gif))/
      @rgx_skin=/(?:0~|@)skin:?\s+(\S+)/ #@rgx_skin=/^0~skin\s+(\S+)/
      threads=[]
      for requested_page in @get_s
        re_fnb=/((?:https?|file):\/\/[^\/ ]+?\/[^\/ ]+?)\/\S+?\/([^\/]+?)\.ss(t)/ #revisit and remove DO
        threads << Thread.new(requested_page) do |url|
          open(url) do |f|
            raise "#{url} not found" unless f
            base_uri,fnb,instr=re_fnb.match(url)[1..3] if re_fnb
            imagedir=base_uri + '/_sisu/image' #check on
            doc_skin_dir = /((?:https?|file):\/\/\S+?)\/[^\/]+?\.sst$/.match(url).captures.join + '/_sisu/skin/doc'
            #"Got file, and ready to process: #{fnb}.t#{instr}"
            downloaded_file=File.new("#{fnb}.-sst",'w+')
            image_download_url=SiSU_Assemble::Remote_image.new.image(imagedir)
            images=[]
            skin=SiSU_Assemble::Remote_image.new.image(doc_skin_dir)
            f.collect.each do |r|                            # work area
              unless r =~/^%+\s/
                skin << r.scan(@rgx_skin).uniq if r =~@rgx_skin
                if r !~/^%+\s/ \
                and r =~@rgx_image
                  images << r.scan(@rgx_image).uniq
                end
              end
              downloaded_file << r
            end
            if skin \
            and skin.length > 0
              SiSU_Assemble::Remote_image.new.download_doc_skin(skin)
            end
            if images \
            and images.length > 1
              images.flatten!
              images.uniq!
              images.delete_if {|x| x =~/http:\/\// }
              images.sort!
              @msg,@msgs='downloading images:', [ images.join(',') ]
              @tell.call.warn unless @opt.cmd =~/q/
              SiSU_Assemble::Remote_image.new.download_images(image_download_url,images)
              @msg,@msgs='downloading done',nil
              @tell.call.warn unless @opt.cmd =~/q/
            end
            downloaded_file.close
          end
        end
      end
      threads.each {|thr| thr.join} if threads #and threads.length > 0
    end
    def sisupod
      get_p=@get_s
      if get_p.length > 0                                     #% remote sisupod
         require 'net/http'
        for requested_pod in get_p
          pod_info=Remote_download.new(requested_pod)
          @opt.fns=pod_info.pod.name
          Net::HTTP.start(pod_info.pod.site) do |http|
            resp=http.get("#{pod_info.pod.path}/#{pod_info.pod.name_source}")
            open(pod_info.pod.name,'wb') do |file|
              file.write(resp.body)
             end
          end
        end
      end
    end
  end
  class Remote_download
    def initialize(requested_file)
      @requested_file=requested_file
    end
    def pod
      re_p_div=/http:\/\/([^\/]+)(\/\S+)\/(sisupod(?:\.zip)?|\S+?(?:\.ss[mt]\.zip)?|[^\/]+?\.ssp)$/
      re_p=/(sisupod(?:\.zip)?|\S+?\.ss[mt](?:\.zip)?|[^\/]+?\.ssp)$/
      if @requested_file =~ re_p_div
        @site,@pth,@pod= re_p_div.match(@requested_file).captures
      elsif @requested_file =~ re_p
        @pod= re_p.match(@requested_file).captures
      end
      def site
        @site
      end
      def path
        @pth
      end
      def dir_stub
        re_p_stub=/.+?([^\/]+)$/
        pod_stub= re_p_stub.match(path).captures.join if path
      end
      def name_source
        @pod
      end
      def name
        name_source
      end
      self
    end
  end
end
__END__
