# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: configuration

=end
module SiSU_Initialize
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  include SiSU_Screen
  require "#{SiSU_lib}/relaxng"
  include SiSU_relaxng
  require "#{SiSU_lib}/css"
  include SiSU_Style
  #require "#{SiSU_lib}/remote"
  #include SiSU_Remote
  class Source
    def initialize(opt)
      @opt=opt
    end
    def read
      SiSU_Config.new(@opt).make_homepage
      SiSU_Config.new(@opt).css
      SiSU_Config.new(@opt).dtd
      SiSU_Config.new(@opt).cp_local_images
      SiSU_Config.new(@opt).cp_external_images
      SiSU_Config.new(@opt).cp_webserver_images #if @opt.mod.inspect =~/--init(?:ialize)?=site/
      #if @opt.cmd =~/R/
      #  SiSU_Config.new(@opt).cp_remote_dirs
      #end
    end
  end
  class SiSU_Config #config files such as css are not updated if they already exist unless forced using the --init=site modifier
    require 'fileutils'
    require "#{SiSU_lib}/sysenv"
    include FileUtils #::Verbose
    def initialize(opt)
      @opt=opt
      @env=SiSU_Env::Info_env.new(@opt.fns)
      @suffix,@path={},{}
      @suffix[:rnc]='rnc'
      @suffix[:rng]='rng'
      @suffix[:xsd]='xsd'
      @path[:xml]= @env.path.output + '/_sisu/xml'
      @path[:xsd]= @env.path.output + '/_sisu/xml/xsd'
      @path[:rnc]= @env.path.output + '/_sisu/xml/rnc'
      @path[:rng]= @env.path.output + '/_sisu/xml/rng'
      #@path_dtd= @env.path.output + '/_sisu/dtd'
      @pwd,@home=Dir.pwd,@env.path.home
    end
    def make_homepage
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'invert','Make homepage','')
      tell.colorize unless @opt.cmd =~/q/
      SiSU_Env::Create_site.new(@opt.cmd).homepage
    end
    def cp_local_images
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'invert','Copy images','')
      tell.colorize unless @opt.cmd =~/q/
      SiSU_Env::Create_site.new(@opt.cmd).cp_local_images
      SiSU_Env::Create_site.new(@opt.cmd).cp_webserver_images_local #this should not have been necessary
      SiSU_Env::Create_site.new(@opt.cmd).cp_base_images #base images (nav etc.) used by all html
    end
    def cp_external_images
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'invert','Copy external images','')
      tell.colorize if @opt.cmd =~/V/
      SiSU_Env::Create_site.new(@opt.cmd).cp_external_images
    end
    def cp_webserver_images
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'invert','Copy webserver/output file images','')
      tell.colorize unless @opt.cmd =~/q/
      SiSU_Env::Create_site.new(@opt.cmd).cp_webserver_images
      SiSU_Env::Create_system_link.new.images
    end
    #def cp_remote_dirs
    #  if @opt.cmd =~/R/
    #    tell=SiSU_Screen::Ansi.new(@opt.cmd,'invert','Copy webserver/output file images to remote server','')
    #    tell.colorize unless @opt.cmd =~/q/
    #    SiSU_Remote::Put.new(@opt).rsync_base
    #  end
    #end
    def css
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'invert','Configuring CSSs','')
      tell.colorize unless @opt.cmd =~/q/
      SiSU_Env::Create_site.new(@opt.cmd).cp_css
    end
    def dtd
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'invert','Configuring DTDs','')
      tell.colorize unless @opt.cmd =~/q/
      @rxng=SiSU_relaxng::RelaxNG.new
      @path.each { |d| mkdir_p(d[1]) unless FileTest.directory?(d[1]) }
      #ugly code, sort later
      if @rxng.methods.join =~/[^_]dtd_sax\b/
        if @rxng.dtd_sax.length > 200
          dtd=File.new("#{@env.path.output}/#{@env.path.style}/#{@rxng.rng_name.output_sax}",'w')
          dtd << @rxng.dtd_sax
          dtd.close
        else trang_rnc_model_output_sax
        end
      else trang_rnc_model_output_sax
      end
      if @rxng.methods.join =~/[^_]dtd_dom\b/
        if @rxng.dtd_dom.length > 200
          dtd=File.new("#{@env.path.output}/#{@env.path.style}/#{@rxng.rng_name.output_dom}",'w')
          dtd << @rxng.dtd_dom
          dtd.close
        else trang_rnc_model_output_dom
        end
      else trang_rnc_model_output_dom
      end
      if @rxng.methods.join =~/[^_]dtd_node\b/
        if @rxng.dtd_node.length > 200
          dtd=File.new("#{@env.path.output}/#{@env.path.style}/#{@rxng.rng_name.input_node}",'w')
          dtd << @rxng.dtd_node
          dtd.close
        else trang_rnc_model_input_node
        end
      else trang_rnc_model_input_node
      end
      if @rxng.methods.join =~/[^_]dtd_xhtml\b/
        if @rxng.dtd_xhtml.length > 200
          #use dtd
          dtd=File.new("#{@env.path.output}/#{@env.path.style}/#{@rxng.rng_name.output_xhtml}",'w')
          dtd << @rxng.dtd_xhtml
          dtd.close
        else trang_rnc_model_output_xhtml
        end
      else trang_rnc_model_output_xhtml
      end
    end
    def trang_rnc_model_output_sax
      s=@suffix
      rnc_src=@env.path.dal + '/sax.' + s[:rnc]
      rnc_file=@path[:rnc] + '/' + @rxng.rnc_name.output_sax
      rng_file=@path[:rng] + '/' + @rxng.rng_name.output_sax
      xsd_file=@path[:xsd] + '/' + @rxng.xsd_name.output_sax
      rnc=File.new(rnc_src,'w')
      rnc << @rxng.rnc_model_output_sax
      rnc.close
      #xsd
      schema=SiSU_Env::System_call.new(rnc_src,xsd_file)
      schema.relaxng(@opt.cmd)
      #rng
      schema=SiSU_Env::System_call.new(rnc_src,rng_file)
      schema.relaxng(@opt.cmd)
      #rnc
      cp(rnc_src,rnc_file)
      chmod(0644,rnc_file)
    end
    def trang_rnc_model_output_dom
      s=@suffix
      rnc_src=@env.path.dal + '/dom.' + s[:rnc]
      rnc_file=@path[:rnc] + '/' + @rxng.rnc_name.output_dom
      rng_file=@path[:rng] + '/' + @rxng.rng_name.output_dom
      xsd_file=@path[:xsd] + '/' + @rxng.xsd_name.output_dom
      rnc=File.new(rnc_src,'w')
      rnc << @rxng.rnc_model_output_dom
      rnc.close
      #xsd
      schema=SiSU_Env::System_call.new(rnc_src,xsd_file)
      schema.relaxng(@opt.cmd)
      #rng
      schema=SiSU_Env::System_call.new(rnc_src,rng_file)
      schema.relaxng(@opt.cmd)
      #rnc
      cp(rnc_src,rnc_file)
      chmod(0644,rnc_file)
    end
    def trang_rnc_model_output_xhtml
      s=@suffix
      rnc_src=@env.path.dal + '/xhtml.' + s[:rnc]
      rnc_file=@path[:rnc] + '/' + @rxng.rnc_name.output_xhtml
      rng_file=@path[:rng] + '/' + @rxng.rng_name.output_xhtml
      xsd_file=@path[:xsd] + '/' + @rxng.xsd_name.output_xhtml
      rnc=File.new(rnc_src,'w')
      rnc << @rxng.rnc_model_output_xhtml
      rnc.close
      #xsd
      schema=SiSU_Env::System_call.new(rnc_src,xsd_file)
      schema.relaxng(@opt.cmd)
      #rng
      schema=SiSU_Env::System_call.new(rnc_src,rng_file)
      schema.relaxng(@opt.cmd)
      #rnc
      cp(rnc_src,rnc_file)
      chmod(0644,rnc_file)
    end
    def trang_rnc_model_input_sax
      rnc_file=@env.path.dal + '/sax.rnc'
      dtd_file=@path[:xsd] + '/' + @rxng.rng_name.input_sax
      rnc=File.new(rnc_file,'w')
      rnc << @rxng.rnc_model_output_sax
      rnc.close
      schema=SiSU_Env::System_call.new(rnc_file,dtd_file)
      schema.relaxng(@opt.cmd)
    end
    def trang_rnc_model_input_dom
      rnc_file=@env.path.dal + '/dom.rnc'
      dtd_file=@path[:xsd] + '/' + @rxng.rng_name.input_dom
      rnc=File.new(rnc_file,'w')
      rnc << @rxng.rnc_model_output_dom
      rnc.close
      schema=SiSU_Env::System_call.new(rnc_file,dtd_file)
      schema.relaxng(@opt.cmd)
    end
    def trang_rnc_model_input_node
      rnc_file=@env.path.dal + '/node.rnc'
      rng_file=@env.path.dal + '/node.rng'
      dtd_file=@path[:xsd] + '/' + @rxng.rng_name.input_node
      rnc=File.new(rnc_file,'w')
      rnc << @rxng.rnc_model_input_node
      rnc.close
      schema=SiSU_Env::System_call.new(rnc_file,dtd_file)
      schema.relaxng(@opt.cmd)
    end
  end
end
__END__
