# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: shared html parts

=end
module SiSU_HTML_table
  require "#{SiSU_lib}/defaults"
  class Table
    @@tablehead=0
    @@tablefoot=[] #watch
    def initialize(one)
      @one,@parablock,@vz=one,one,SiSU_Env::Get_init.instance.skin
    end
    def table_head(inf)
      %{
<div class="substance">
<label class="ocn">#{inf}</label>
<p class="norm" id="o#{inf}"><a name="#{inf}"></a>
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">}
    end
    def table_end(tablefoot='')
      %{</p>
#{tablefoot}
</div>
<div class="substance">
}
    end
    def table_row(inf,h=false)
      bold=if h; '<b>'
      else       ''
      end
      %{
<tr>
  <td width="#{inf}%" valign="top">#{@vz.paragraph_table}#{bold}}
    end
    def table_cell(inf,h=false)
      if h; %{</b></font></td><td width="#{inf}%" valign="top">#{@vz.paragraph_table}<b>}
      else  %{</font></td><td width="#{inf}%" valign="top">#{@vz.paragraph_table}}
      end
    end
    def table_row_close(h=false)
      bold_close=if h; '</b>'
      else             ''
      end
      "#{bold_close}</font></td></tr>"
    end
    def table
      m=@parablock[/<!f(.+?)!>/,1]
      @@tablefoot << m if m
      @parablock.gsub!(/<!f.+?!>/,'')
      @@tablehead=1 if @parablock =~/#{Mx[:gr_o]}Th#{Mx[:tc_p]}/u
      if @parablock =~/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}.+?#{Mx[:tc_p]}~(\d+);\w\d+;\w\d+#{Mx[:gr_c]}/u; @parablock=table_head($1)
      end
      if @parablock =~/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/
        tablefoot=[]
        @@tablefoot.each {|x| tablefoot << ''}
        @@tablefoot=[]
        if @parablock =~/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/; @parablock="</table></p>\n</div>" #table_end
        end
      end
      if @@tablehead == 1
        if @parablock =~/#{Mx[:tc_p]}#{Mx[:tc_p]}/u
          while @parablock =~/#{Mx[:tc_o]}#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+)#{Mx[:tc_p]}/u
            @parablock.sub!(/#{Mx[:tc_o]}#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+)#{Mx[:tc_p]}/u,table_row($1,true))
          end
          while @parablock =~/#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+)#{Mx[:tc_p]}/u
            @parablock.sub!(/#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+)#{Mx[:tc_p]}/u,table_cell($1,true))
          end
          if @parablock =~/#{Mx[:tc_c]}/
            @parablock.gsub!(/#{Mx[:tc_c]}/,table_row_close(true))
          end
          @@tablehead=0
        end
        @parablock
      else
        while @parablock =~/#{Mx[:tc_o]}#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+)#{Mx[:tc_p]}/u
          @parablock.sub!(/#{Mx[:tc_o]}#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+)#{Mx[:tc_p]}/u,table_row($1))
        end
        while @parablock =~/#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+)#{Mx[:tc_p]}/u
          @parablock.sub!(/#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+)#{Mx[:tc_p]}/u,table_cell($1))
        end
        if @parablock =~/#{Mx[:tc_c]}/
          @parablock.gsub!(/#{Mx[:tc_c]}/,table_row_close)
        end
        @parablock
      end
      @parablock
    end
    def table_split
      content=[]
      @one.split(/\n/).each do |parablock|
        table=Table.new("#{parablock}\n")
        content << table.table
      end
      content.join
    end
  end
end
__END__
