# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: rexml testing of xml

=end
module SiSU_Rexml
  # load XML file for REXML parsing
  require 'rexml/document' if FileTest.directory?("#{Config::CONFIG['rubylibdir']}/rexml") #Config::CONFIG['sitedir']
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  class Rexml
    require 'rexml/document' if FileTest.directory?("#{Config::CONFIG['rubylibdir']}/rexml") #Config::CONFIG['sitedir']
    def initialize(md,fno)
      @md,@fno=md,fno
      @env=SiSU_Env::Info_env.new(@md.fns)
      @prog=SiSU_Env::Info_program.new #(md.fns) #if md
      if File.file?"#{@env.path.output}/#{@md.fnb}/#@fno"
        @fnap="#{@env.path.output}/#{@md.fnb}/#@fno" #index.xml causes problems with index.html in server config
      elsif File.file?"#{Dir.pwd}/#@fno"
        @fnap="#{Dir.pwd}/#@fno"
      end
      @e_head='/document/head'
      @e_title='/document/head/title'
      @e_object='/document/body/object'
      @e_ocn='/document/body/object/ocn'
      @e_text='/document/body/object/text'
      @e_endnote='/document/body/object/endnote'
    end
    def xml
      begin
        if FileTest.file?(@fnap)
          if @prog.rexml !=false \
          and FileTest.directory?('/usr/lib/ruby/1.8/rexml/') #note values can be other than true
            xmlfile=IO.readlines(@fnap,'').join
            begin
              @xmldoc=REXML::Document.new xmlfile
              tell=SiSU_Screen::Ansi.new(@md.cmd,'invert','REXML',"XML document #@fnap loaded")  #% tell
              tell.colorize unless @md.cmd =~/q/
              if @md.cmd =~ /v/i        #% substantive text
                @xmldoc.elements.each(@e_head) do |e|
                  tell=SiSU_Screen::Ansi.new(@md.cmd,'brown',e)
                  tell.colorize unless @md.cmd =~/q/
                end
              end
            rescue REXML::ParseException
              puts 'broken XML'
            end
          end
        else
          tell=SiSU_Screen::Ansi.new(@md.cmd,'fuschia',"File Not Found #{xmlfile}",'requested XML processing skipped')
          tell.colorize unless @md.cmd =~/q/
          exit
        end
      rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
      ensure
      end
    end
  end
end
__END__
 misc
e.each do |element|
  element.each do |child|
    if child.is_a?(REXML::Text)
      puts "Text: #{child.to_s.inspect}"
    else
      puts "SubElement: #{child.name}"
    end
  end
end

