# coding: utf-8
=begin

 * Name: SiSU

 * Description: extract and print an XML rendition of document structure to screen

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: SiSU information Structuring Universe, processing

=end
module SiSU_XML_scaffold
  require "#{SiSU_lib}/particulars"
  include SiSU_Particulars
  require "#{SiSU_lib}/dal"
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  pwd=Dir.pwd
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::Combined_singleton.instance.get_all(opt)
      @sp='  '
    end
    def read
      begin
        @md,@dal_array=@particulars.md,@particulars.dal_array
        SiSU_XML_scaffold::Source::Scroll.new(@dal_array,@md).songsheet
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    private
    class Scroll <Source
      def initialize(data='',md='')
        @data,@md=data,md
      end
      def songsheet
        @t='docbook'         #@t='fictionbook'
        @s=['book',          #@s=['body',
          'part',            #  'section',
          'subpart N/A',     #  'section',
          'sub-subpart N/A', #  'section',
          'chapter',         #  'section',
          'sect1',           #  'section',
          'sect2'            #  'section'
        ]                    #]
        structure
      end
      def structure_outline(ds)
        puts "\ninfo outline --->\n\n"
        ds.each {|x| puts "#{x[:ocn]} #{x[:lev]} #{x[:hdr]}" }
      end
      def structure_simple(ds)
        puts "\nheading outline --->\n\n"
        ds.each_with_index do |x,i|
          #puts "#{x[:ocn]} #{x[:lev]} #{x[:hdr]}"
          if x[:lev] =~ /^([1-6])/; puts "<#{@s[$1.to_i]}>#{x[:ocn]} #{x[:lev]} #{x[:hdr]}</#{@s[$1.to_i]}>"
          end
        end
      end
      def structure_build_tag_close(lev,h)
        @sp='  '
        case h[0]
        when 1
          puts "#{@sp*1}</#{@s[1]}>" if (lev <= 1) and h[1]
          puts "</#{@s[0]}>"         if (lev == 0)
        when 2
          puts "#{@sp*2}</#{@s[2]}>" if (lev <= 2) and h[2]
          puts "#{@sp*1}</#{@s[1]}>" if (lev <= 1) and h[1]
          puts "</#{@s[0]}>"         if (lev == 0)
        when 3
          puts "#{@sp*3}</#{@s[3]}>" if (lev <= 3) and h[3]
          puts "#{@sp*2}</#{@s[2]}>" if (lev <= 2) and h[2]
          puts "#{@sp*1}</#{@s[1]}>" if (lev <= 1) and h[1]
          puts "</#{@s[0]}>"         if (lev == 0)
        when 4
          puts "#{@sp*4}</#{@s[4]}>" if (lev <= 4)
          puts "#{@sp*3}</#{@s[3]}>" if (lev <= 3) and h[3]
          puts "#{@sp*2}</#{@s[2]}>" if (lev <= 2) and h[2]
          puts "#{@sp*1}</#{@s[1]}>" if (lev <= 1) and h[1]
          puts "</#{@s[0]}>"         if (lev == 0)
        when 5
          puts "#{@sp*5}</#{@s[5]}>" if (lev <= 5)
          puts "#{@sp*4}</#{@s[4]}>" if (lev <= 4)
          puts "#{@sp*3}</#{@s[3]}>" if (lev <= 3) and h[3]
          puts "#{@sp*2}</#{@s[2]}>" if (lev <= 2) and h[2]
          puts "#{@sp*1}</#{@s[1]}>" if (lev <= 1) and h[1]
          puts "</#{@s[0]}>"         if (lev == 0)
        when 6
          puts "#{@sp*6}</#{@s[6]}>" if (lev <= 6)
          puts "#{@sp*5}</#{@s[5]}>" if (lev <= 5)
          puts "#{@sp*4}</#{@s[4]}>" if (lev <= 4)
          puts "#{@sp*3}</#{@s[3]}>" if (lev <= 3) and h[3]
          puts "#{@sp*2}</#{@s[2]}>" if (lev <= 2) and h[2]
          puts "#{@sp*1}</#{@s[1]}>" if (lev <= 1) and h[1]
          puts "</#{@s[0]}>"         if (lev == 0)
        end
      end
      def structure_build(ds)
        puts "\nXML [#@t type] structure outline --->\n\n"
        @h=[0,false,false,false]
        puts "<#{@s[0]}>"
        ds.each_with_index do |x,i|
          case x[:lev]
          when /^1/
            structure_build_tag_close(x[:lev].to_i,@h)
            puts "#{@sp*1}<#{@s[1]}>\n#{@sp*1}  #{x[:ocn]} #{x[:lev]} #{x[:hdr]}"
            @h=[1,true,false,false]
          when /^2/
            structure_build_tag_close(x[:lev].to_i,@h)
            puts "#{@sp*2}<#{@s[2]}>\n#{@sp*2}  #{x[:ocn]} #{x[:lev]} #{x[:hdr]}"
            @h=[2,true,true,false]
          when /^3/
            structure_build_tag_close(x[:lev].to_i,@h)
            puts "#{@sp*3}<#{@s[3]}>\n#{@sp*3}  #{x[:ocn]} #{x[:lev]} #{x[:hdr]}"
            @h=[3,true,true,true]
          when /^4/
            structure_build_tag_close(x[:lev].to_i,@h)
            puts "#{@sp*4}<#{@s[4]}>\n#{@sp*4}  #{x[:ocn]} #{x[:lev]} #{x[:hdr]}"
            @h[0]=4
          when /^5/
            structure_build_tag_close(x[:lev].to_i,@h)
            puts "#{@sp*5}<#{@s[5]}>\n#{@sp*5}  #{x[:ocn]} #{x[:lev]} #{x[:hdr]}"
            @h[0]=5
          when /^6/
            structure_build_tag_close(x[:lev].to_i,@h)
            puts "#{@sp*6}<#{@s[6]}>\n#{@sp*6}  #{x[:ocn]} #{x[:lev]} #{x[:hdr]}"
            @h[0]=6
          end
        end
        structure_build_tag_close(0,@h)
      end
      def structure
        data=@data
        @ds=[]
        c=0
        data.each do |para|
          if para =~/#{Mx[:id_o]}~\d+;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}/
            x=(/#{Mx[:id_o]}~(\d+);((?:\w|[0-6]:)\d+);(\w\d+)#{Mx[:id_c]}/).match(para)
            if x[3] =~/^[hu]\d+/
              @ds[c]={}
              @ds[c][:ocn]=x[1]
              @ds[c][:lev]=x[2]
              @ds[c][:hdr]=x[3]
              c+=1
              #puts "#{x[1]} #{x[2]} #{x[3]}"
            end
          end
        end
        structure_outline(@ds) if @md.cmd =~/V/
        structure_simple(@ds) if @md.cmd =~/V/
        structure_build(@ds)
        @ds
      end
    end
  end
end
__END__
