# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v4/db_load_tuple.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules shared by the different db types, dbi, postgresql,
    sqlite

=end
module SiSU_DbTuple
  require_relative 'db_columns'                         # db_columns.rb
  class LoadDocuments
    require_relative 'param'                            # param.rb
      include SiSU_Param
    def initialize(conn,col,opt,file_maint)
      @conn,@col,@opt,@file_maint=conn,col,opt,file_maint
      @col[:lev]=@col[:lev].to_i
      unless @col[:lev]=~/^[1-6]/ \
      or @col[:lev]==1 \
      or @col[:lev]==2 \
      or @col[:lev]==3 \
      or @col[:lev]==4 \
      or @col[:lev]==5 \
      or @col[:lev]==6 #changed from \d+ ??
        @col[:lev]=0
      end
      @col[:ocn]=0 unless @col[:ocn].inspect=~/\d+/
      @cX=SiSU_Screen::Ansi.new(@opt.cmd).cX
    end
    def tuple                                                                    #% import line
      sql_entry=if @col[:en_a]
        "INSERT INTO doc_objects (lid, metadata_tid, lev, lev_an, clean, body, book_idx, ocn, ocnd, ocns, seg, lev1, lev2, lev3, lev4, lev5, lev6, en_a, en_z, t_of, t_is, node, parent, digest_clean, digest_all) " +
        "VALUES (#{@col[:lid]}, #{@col[:tid]}, #{@col[:lev]}, '#{@col[:lev_an]}', '#{@col[:plaintext]}', '#{@col[:body]}', '#{@col[:book_idx]}', '#{@col[:ocn]}', '#{@col[:ocnd]}', '#{@col[:ocns]}', '#{@col[:seg]}', '#{@col[:lv1]}', '#{@col[:lv2]}', '#{@col[:lv3]}', '#{@col[:lv4]}', '#{@col[:lv5]}', '#{@col[:lv6]}', '#{@col[:en_a]}', '#{@col[:en_z]}', '#{@col[:t_of]}', '#{@col[:t_is]}', '#{@col[:node]}', '#{@col[:parent]}', '#{@col[:digest_clean]}', '#{@col[:digest_all]}');"
      else
        "INSERT INTO doc_objects (lid, metadata_tid, lev, lev_an, clean, body, book_idx, ocn, ocnd, ocns, seg, lev1, lev2, lev3, lev4, lev5, lev6, t_of, t_is, node, parent, digest_clean, digest_all) " +
        "VALUES (#{@col[:lid]}, #{@col[:tid]}, #{@col[:lev]}, '#{@col[:lev_an]}', '#{@col[:plaintext]}', '#{@col[:body]}', '#{@col[:book_idx]}', '#{@col[:ocn]}', '#{@col[:ocnd]}', '#{@col[:ocns]}', '#{@col[:seg]}', '#{@col[:lv1]}', '#{@col[:lv2]}', '#{@col[:lv3]}', '#{@col[:lv4]}', '#{@col[:lv5]}', '#{@col[:lv6]}', '#{@col[:t_of]}', '#{@col[:t_is]}', '#{@col[:node]}', '#{@col[:parent]}', '#{@col[:digest_clean]}', '#{@col[:digest_all]}');"
      end
      if @opt.cmd =~/M/
        if @opt.cmd =~/V/
          puts @file_maint.inspect
          puts sql_entry
        end
        @file_maint.puts sql_entry
      else
        if @opt.cmd =~/V/
          puts sql_entry
          @file_maint.puts sql_entry
        end
      end
      if @opt.cmd =~/v/
        if @col[:lev].inspect =~/[12356789]/
          lev=case @col[:lev].inspect
          when /1/; ':A'
          when /2/; ':B'
          when /3/; ':C'
          when /5/; ' 2'
          when /6/; ' 3'
          end
          puts %{#{lev}>\t#{@col[:lv1]}\t#{@col[:lv2]}\t#{@col[:lv3]}\t#{@col[:lv4]}\t#{@col[:lv5]}\t#{@col[:lv6]}\t#{@col[:ocn]}\t#{@col[:node]}\t#{@col[:ocns]}}
        elsif @col[:lev].inspect =~/[4]/
          puts %{ #{@cX.green}1>#{@cX.off}\t#{@col[:lv1]}\t#{@col[:lv2]}\t#{@col[:lv3]}\t#{@col[:lv4]}\t#{@col[:lv5]}\t#{@col[:lv6]}\t#{@col[:ocn]}\t#{@col[:node]}\t#{@col[:ocns]}\t#{@col[:seg]}}
        end
      end
      sql_entry
    end
  end
  class LoadMetadata #< SiSU_DbColumns::Columns
    def initialize(conn,id,md,file_maint)
      @conn,@id,@md,@file_maint=conn,id,md,file_maint
      @tp=SiSU_DbColumns::Columns.new(md)
    end
    def tuple
      sql_entry="INSERT INTO metadata_and_text (
#{@tp.column.title.tuple[0]}
#{@tp.column.title_main.tuple[0]}
#{@tp.column.title_sub.tuple[0]}
#{@tp.column.title_short.tuple[0]}
#{@tp.column.title_edition.tuple[0]}
#{@tp.column.title_note.tuple[0]}
#{@tp.column.title_language.tuple[0]}
#{@tp.column.title_language_char.tuple[0]}
#{@tp.column.creator_author.tuple[0]}
#{@tp.column.creator_author_honorific.tuple[0]}
#{@tp.column.creator_author_nationality.tuple[0]}
#{@tp.column.creator_editor.tuple[0]}
#{@tp.column.creator_contributor.tuple[0]}
#{@tp.column.creator_illustrator.tuple[0]}
#{@tp.column.creator_photographer.tuple[0]}
#{@tp.column.creator_translator.tuple[0]}
#{@tp.column.creator_prepared_by.tuple[0]}
#{@tp.column.creator_digitized_by.tuple[0]}
#{@tp.column.creator_audio.tuple[0]}
#{@tp.column.creator_video.tuple[0]}
#{@tp.column.language_document.tuple[0]}
#{@tp.column.language_document_char.tuple[0]}
#{@tp.column.language_original.tuple[0]}
#{@tp.column.language_original_char.tuple[0]}
#{@tp.column.date_added_to_site.tuple[0]}
#{@tp.column.date_available.tuple[0]}
#{@tp.column.date_created.tuple[0]}
#{@tp.column.date_issued.tuple[0]}
#{@tp.column.date_modified.tuple[0]}
#{@tp.column.date_published.tuple[0]}
#{@tp.column.date_valid.tuple[0]}
#{@tp.column.date_translated.tuple[0]}
#{@tp.column.date_original_publication.tuple[0]}
#{@tp.column.date_generated.tuple[0]}
#{@tp.column.publisher.tuple[0]}
#{@tp.column.original_publisher.tuple[0]}
#{@tp.column.original_language.tuple[0]}
#{@tp.column.original_language_char.tuple[0]}
#{@tp.column.original_source.tuple[0]}
#{@tp.column.original_institution.tuple[0]}
#{@tp.column.original_nationality.tuple[0]}
#{@tp.column.rights_all.tuple[0]}
#{@tp.column.rights_copyright_text.tuple[0]}
#{@tp.column.rights_copyright_translation.tuple[0]}
#{@tp.column.rights_copyright_illustrations.tuple[0]}
#{@tp.column.rights_copyright_photographs.tuple[0]}
#{@tp.column.rights_copyright_preparation.tuple[0]}
#{@tp.column.rights_copyright_digitization.tuple[0]}
#{@tp.column.rights_copyright_audio.tuple[0]}
#{@tp.column.rights_copyright_video.tuple[0]}
#{@tp.column.rights_license.tuple[0]}
#{@tp.column.classify_topic_register.tuple[0]}
#{@tp.column.classify_subject.tuple[0]}
#{@tp.column.classify_loc.tuple[0]}
#{@tp.column.classify_dewey.tuple[0]}
#{@tp.column.classify_keywords.tuple[0]}
#{@tp.column.identifier_oclc.tuple[0]}
#{@tp.column.identifier_isbn.tuple[0]}
#{@tp.column.notes_abstract.tuple[0]}
#{@tp.column.notes_description.tuple[0]}
#{@tp.column.notes_comment.tuple[0]}
#{@tp.column.notes_history.tuple[0]}
#{@tp.column.notes_format.tuple[0]}
#{@tp.column.notes_relation.tuple[0]}
#{@tp.column.notes_coverage.tuple[0]}
#{@tp.column.notes_type.tuple[0]}
#{@tp.column.notes_prefix.tuple[0]}
#{@tp.column.notes_prefix_a.tuple[0]}
#{@tp.column.notes_prefix_b.tuple[0]}
#{@tp.column.notes_suffix.tuple[0]}
#{@tp.column.src_filename.tuple[0]}
#{@tp.column.src_fingerprint.tuple[0]}
#{@tp.column.src_filesize.tuple[0]}
#{@tp.column.src_word_count.tuple[0]}
#{@tp.column.src_txt.tuple[0]}
#{@tp.column.fulltext.tuple[0]}
#{@tp.column.links.tuple[0]}
tid)
" +
       "VALUES (
#{@tp.column.title.tuple[1]}
#{@tp.column.title_main.tuple[1]}
#{@tp.column.title_sub.tuple[1]}
#{@tp.column.title_short.tuple[1]}
#{@tp.column.title_edition.tuple[1]}
#{@tp.column.title_note.tuple[1]}
#{@tp.column.title_language.tuple[1]}
#{@tp.column.title_language_char.tuple[1]}
#{@tp.column.creator_author.tuple[1]}
#{@tp.column.creator_author_honorific.tuple[1]}
#{@tp.column.creator_author_nationality.tuple[1]}
#{@tp.column.creator_editor.tuple[1]}
#{@tp.column.creator_contributor.tuple[1]}
#{@tp.column.creator_illustrator.tuple[1]}
#{@tp.column.creator_photographer.tuple[1]}
#{@tp.column.creator_translator.tuple[1]}
#{@tp.column.creator_prepared_by.tuple[1]}
#{@tp.column.creator_digitized_by.tuple[1]}
#{@tp.column.creator_audio.tuple[1]}
#{@tp.column.creator_video.tuple[1]}
#{@tp.column.language_document.tuple[1]}
#{@tp.column.language_document_char.tuple[1]}
#{@tp.column.language_original.tuple[1]}
#{@tp.column.language_original_char.tuple[1]}
#{@tp.column.date_added_to_site.tuple[1]}
#{@tp.column.date_available.tuple[1]}
#{@tp.column.date_created.tuple[1]}
#{@tp.column.date_issued.tuple[1]}
#{@tp.column.date_modified.tuple[1]}
#{@tp.column.date_published.tuple[1]}
#{@tp.column.date_valid.tuple[1]}
#{@tp.column.date_translated.tuple[1]}
#{@tp.column.date_original_publication.tuple[1]}
#{@tp.column.date_generated.tuple[1]}
#{@tp.column.publisher.tuple[1]}
#{@tp.column.original_publisher.tuple[1]}
#{@tp.column.original_language.tuple[1]}
#{@tp.column.original_language_char.tuple[1]}
#{@tp.column.original_source.tuple[1]}
#{@tp.column.original_institution.tuple[1]}
#{@tp.column.original_nationality.tuple[1]}
#{@tp.column.rights_all.tuple[1]}
#{@tp.column.rights_copyright_text.tuple[1]}
#{@tp.column.rights_copyright_translation.tuple[1]}
#{@tp.column.rights_copyright_illustrations.tuple[1]}
#{@tp.column.rights_copyright_photographs.tuple[1]}
#{@tp.column.rights_copyright_preparation.tuple[1]}
#{@tp.column.rights_copyright_digitization.tuple[1]}
#{@tp.column.rights_copyright_audio.tuple[1]}
#{@tp.column.rights_copyright_video.tuple[1]}
#{@tp.column.rights_license.tuple[1]}
#{@tp.column.classify_topic_register.tuple[1]}
#{@tp.column.classify_subject.tuple[1]}
#{@tp.column.classify_loc.tuple[1]}
#{@tp.column.classify_dewey.tuple[1]}
#{@tp.column.classify_keywords.tuple[1]}
#{@tp.column.identifier_oclc.tuple[1]}
#{@tp.column.identifier_isbn.tuple[1]}
#{@tp.column.notes_abstract.tuple[1]}
#{@tp.column.notes_comment.tuple[1]}
#{@tp.column.notes_description.tuple[1]}
#{@tp.column.notes_history.tuple[1]}
#{@tp.column.notes_format.tuple[1]}
#{@tp.column.notes_relation.tuple[1]}
#{@tp.column.notes_coverage.tuple[1]}
#{@tp.column.notes_type.tuple[1]}
#{@tp.column.notes_prefix.tuple[1]}
#{@tp.column.notes_prefix_a.tuple[1]}
#{@tp.column.notes_prefix_b.tuple[1]}
#{@tp.column.notes_suffix.tuple[1]}
#{@tp.column.src_filename.tuple[1]}
#{@tp.column.src_fingerprint.tuple[1]}
#{@tp.column.src_filesize.tuple[1]}
#{@tp.column.src_word_count.tuple[1]}
#{@tp.column.src_txt.tuple[1]}
#{@tp.column.fulltext.tuple[1]}
#{@tp.column.links.tuple[1]}
#{@id}
);"
      if @md.opt.cmd =~/M/
        puts "maintenance mode on: creating sql transaction file (for last transaction set (document) only):\n\t#{@file_maint.inspect}"
        @file_maint.puts sql_entry
      else
        @file_maint.puts sql_entry if @md.opt.cmd =~/V/
      end
      sql_entry
    end
  end
  class LoadUrls
    def initialize(conn,f,u,id,opt,file_maint)
      @conn,@f,@u,@id,@opt,@file_maint=conn,f,u,id,opt,file_maint
    end
    def tuple
      sql_entry="INSERT INTO urls (#{@f[:txt]} #{@f[:html_toc]} #{@f[:html_doc]} #{@f[:xhtml]} #{@f[:xml_sax]} #{@f[:xml_dom]} #{@f[:odf]} #{@f[:pdf_p]} #{@f[:pdf_l]} #{@f[:concordance]} #{@f[:latex_p]} #{@f[:latex_l]} #{@f[:manifest]} #{@f[:digest]} #{@f[:markup]} #{@f[:sisupod]} metadata_tid) " +
      "VALUES (#{@u[:txt]} #{@u[:html_toc]} #{@u[:html_doc]} #{@u[:xhtml]} #{@u[:xml_sax]} #{@u[:xml_dom]} #{@u[:odf]} #{@u[:pdf_p]} #{@u[:pdf_l]} #{@u[:concordance]} #{@u[:latex_p]} #{@u[:latex_l]} #{@u[:manifest]} #{@u[:digest]} #{@u[:markup]} #{@u[:sisupod]} #{@id});"
      if @opt.cmd =~/M/
        @file_maint.puts sql_entry
      else
        @file_maint.puts sql_entry if @opt.cmd =~/V/
      end
      sql_entry
    end
  end
  class LoadEndnotes
    def initialize(conn,en,opt,file_maint)
      @conn,@en,@opt,@file_maint=conn,en,opt,file_maint
    end
    def tuple
      sql_entry="INSERT INTO #{@en[:type]} (nid, document_lid, nr, clean, body, ocn, ocnd, ocns, metadata_tid, digest_clean) " +
      "VALUES ('#{@en[:id]}', '#{@en[:lid]}', '#{@en[:nr]}', '#{@en[:txt]}', '#{@en[:body]}', '#{@en[:ocn]}', '#{@en[:ocnd]}', '#{@en[:ocns]}', '#{@en[:id_t]}', '#{@en[:hash]}');"
      if @opt.cmd =~/M/
        @file_maint.puts sql_entry
      else
        @file_maint.puts sql_entry if @opt.cmd =~/V/
      end
      sql_entry
    end
  end
end
__END__
