# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/wikispeak.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: wiki text generation, stripped wiki output (unix, linefeed)

=end
module SiSU_Wikispeak
  require_relative 'ao'                                 # ao.rb
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env
  include SiSU_Param
  include SiSU_Viz
  require_relative 'plaintext_format'                   # plaintext_format.rb
    include Format
  require_relative 'txt_shared'
  @@alt_id_count,@@alt_id_count,@@tablehead,@@number_of_cols=0,0,0,0
  @@tablefoot=''
  class Source
    def initialize(opt)
      @opt=opt
      @@dostype='msdos footnotes'
    end
    def read
      begin
        @md=SiSU_Param::Parameters.new(@opt).get
        @env=SiSU_Env::InfoEnv.new(@opt.fns)
        path=@env.path.output_tell
        tool=(@opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on) \
        ? "#{@env.program.text_editor} #{path}/#{@md.fnb}/#{@md.fn[:wiki]}"
        : ''
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          'Wikispeak',
          tool
        ).green_hi_blue unless @opt.act[:quiet][:set]==:on
        if (@opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            @opt.fns,
            "#{@env.path.output_tell}/#{@md.fnb}/#{@md.fn[:wiki]}"
          ).flow
        end
        @ao_array=SiSU_AO::Source.new(@opt).get # ao file drawn here
        SiSU_Wikispeak::Source::Scroll.new(@ao_array,@md).songsheet
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.cmd,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    private
    class SplitTextObject <Source
      require_relative 'plaintext_format'               # plaintext_format.rb
        include Format
      include SiSU_Viz
      @@alt_id_count=0
      @@dp=nil
      attr_reader :format,:lev,:text,:ocn,:lev_para_ocn
      def initialize(para)
        @para=para
        @format,@ocn='ordinary','ordinary'
        @dp=@@dp ||=SiSU_Env::InfoEnv.new.digest.pattern
      end
      def lev_segname_para_ocn
        @text=nil
        if @para =~/^(\d~|<:.+?>).+?#{Mx[:id_o]}~(\d+);(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/
          if /^(([1-6])~(\S+))\s+(\S.+?)#{Mx[:id_o]}~(\d+);(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/m.match(@para)
            @format,@lev,segname,@text,@ocn=$1,$2,$3,$4,$5
          elsif  /^(([1-6])~)\s+(\S.+?)#{Mx[:id_o]}~(\d+);(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/m.match(@para)
            @format,@lev,@text,@ocn=$1,$2,$3,$4
          elsif /<:(.+?)>\s*(\S.+?)#{Mx[:id_o]}~(\d+);(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/m.match(@para)
            @format,@text,@ocn=$1,$2,$3
          elsif /^(([1-6])~(\S+))\s+(\S.+?)#{Mx[:id_o]}~(\d+);(?:\w|[0-6]:)\d+;[um]\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/m.match(@para)
            @@alt_id_count+=1
            @format,@lev,segname,@text,@ocn=$1,$2,$3,$4,"x#{@@alt_id_count}"
          elsif  /^(([1-6])~)\s+(\S.+?)#{Mx[:id_o]}~(\d+);[um]\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/m.match(@para)
            @@alt_id_count+=1
            @format,@lev,@text,@ocn=$1,$2,$3,"x#{@@alt_id_count}"
          end
        else
          if /(.+?)#{Mx[:id_o]}~(\d+);(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/m.match(@para)
            @text,@ocn=$1,$2
          end
          if @para !~/#{Mx[:id_o]}~(\d+);(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$|^$/ #added 2002w06
            @text=/(.+?)/m.match(@para)[1]
          end
          if /^((\d)~(?:~\S+)?)\s+(.+)/m.match(@para)
            @format,@lev,@text=$1,$2,$3
          end
        end
        format=@format.dup
        @lev_para_ocn=if @para =~/.+#{Mx[:id_o]}~\d+;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/
          Format::FormatTextObject.new(format,@text,@ocn)
        else
          Format::FormatTextObject.new(format,@text,"#{Mx[:id_o]}~(\d+);[um]\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}")
        end
        self
      end
    end
    class Scroll <Source
      require_relative 'txt_shared'                     # txt_shared.rb
        include SiSU_TextUtils
      @@endnotes_para=[]
      @@wiki={ body: [], open: [], close: [], head: [], metadata: [], tail: [], endnotes: [] }
      @@dp=nil
      def initialize(data,md)
        @data,@md=data,md
        @vz=SiSU_Viz::Defaults.new
        @dp=@@dp ||=SiSU_Env::InfoEnv.new.digest.pattern
        @regx=/^(?:(?:#{Mx[:br_line]}\s*|#{Mx[:br_nl]}\s*)?#{Mx[:lv_o]}\d:(\S*?)#{Mx[:lv_c]}\s*)?(.+)/ #fix Mx[:lv_o] #m # 2004w18 pb pn removal added
        @tab="\t"
        @@dostype='unix footnotes'
        @br="\n"
      end
      def songsheet
        markup
        publish
      end
      # Used for extraction of endnotes from paragraphs
      def extract_endnotes(para='') #check
        para.scan(/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})([\d*+]+\s+.+?)\s*#{Mx[:id_o]}#{@dp}#{Mx[:id_c]}(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/)
      end
      def wiki_metadata(meta)
        util=SiSU_TextUtils::Wrap.new(meta.text,70,15,1)
        txt=util.line_wrap
        @@wiki[:metadata] <<= if meta.type=='meta'
          <<WOK

#{@tab}#{meta.el}: #{txt}
WOK
        else ''
        end
      end
      def wiki_tail
        vz=SiSU_Viz::Defaults.new
        generator="Generated by: #{@md.sisu_version[:project]} #{@md.sisu_version[:version]} of #{@md.sisu_version[:date_stamp]} (#{@md.sisu_version[:date]})"  if @md.sisu_version[:version]
        lastdone="Last Generated on: #{Time.now}"
        rubyv="Ruby version: #{@md.ruby_version}"
        sc=if @md.sc_info
          "Source file:    #{@md.sc_filename}#{@br}Version number: #{@md.sc_number}#{@br}Version date:   #{@md.sc_date}#{@br}"
        else ''
        end
        @@wiki[:tail] <<<<WOK
#{@br}
Other versions of this document: #{@br}
manifest:
   #{vz.url_root_http}/#{@md.fnb}/#{@md.fn[:manifest]}#{@br}
html:
   #{vz.url_root_http}/#{@md.fnb}/#{@md.fn[:toc]}#{@br}
pdf:
   #{vz.url_root_http}/#{@md.fnb}/#{@md.fn[:pdf_p]}
   #{vz.url_root_http}/#{@md.fnb}/#{@md.fn[:pdf_l]}#{@br}
plaintext (plain text):
   #{vz.url_root_http}/#{@md.fnb}/#{@md.fn[:plain]}#{@br}
at:
   #{vz.url_site}#{@br}

#{sc}
* #{generator}
* #{rubyv}
* #{lastdone}
* SiSU #{vz.url_sisu}
WOK
      end
      def wiki_structure(para='',lv='',ocn='',hname='') #% Used to extract the structure of a document
        lv=lv.to_i
        lv=nil if lv==0
        extract_endnotes(para)
        para.gsub!(/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})(?:[\d*+]+)\s+(.+?)#{Mx[:id_o]}#{@dp}#{Mx[:id_c]}(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/,'<ref>\1</ref>') # endnote marker marked up
        para.gsub!(/^#{Rx[:lv]}\S*\s+/,'') # endnote marker marked up
        para.gsub!(/<\S+?>#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}/,'') # endnote marker marked up
        if lv
          @@wiki[:body] << case lv
          when 1    then '='*2 << para.strip << @br*2
          when 2..3 then '='*2 << para.strip << @br*2
          when 4    then '='*4 << para.strip << @br*2
          when 5..6 then '='*4 << para.strip << @br*2
          end
        else @@wiki[:body] << para << @br*2 # main text, contents, body KEEP
        end
      end
      def markup                                                               # Used for major markup instructions
        data=@data
        SiSU_Env::InfoEnv.new(@md.fns)
        @data_mod,@endnotes,@level,@cont,@copen,@wiki_contents_close=Array.new(6){[]}
        (0..6).each { |x| @cont[x]=@level[x]=false }
        (4..6).each { |x| @wiki_contents_close[x]='' }
        wiki_tail
        table_message='[table omitted, see other document formats]'
        data.each do |para|
          para.gsub!(/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}.+/um,"#{@br}#{table_message}") #fix
          para.gsub!(/.+?<-#>/,'')                                           # remove dummy headings (used by html) #check
          para.gsub!(/_\*\s+/,'* ')                                           # bullet markup, marked down
          para.gsub!(/&#169;/,'©')                                           # bullet markup, marked down
          para.gsub!(/&amp;/,'&')                                           # bullet markup, marked down
          para.gsub!(/<sup>(.+?)<\/sup>/,'^\1^')
          para.gsub!(/<sub>(.+?)<\/sub>/,'[\1]')
          para.gsub!(/<i>(.+?)<\/i>/,"''\\1''")
          para.gsub!(/<b>(.+?)<\/b>/,"'''\\1'''")
          para.gsub!(/<u>(.+?)<\/u>/,'_\1_')
          para.gsub!(/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/,'[\2 \1]')
          para.gsub!(/#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/,'[\1]')
          para.gsub!(/<:(?:block|group|verse|alt|code)(?:-end)?>(?:\s+#{Mx[:id_o]}~(\d+);(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]})?/,'')
          para.gsub!(/<:p[bn]>/,'')                                         # remove page breaks
          para.gsub!(/^\s*#{Mx[:id_o]}~\d+;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/,'') # remove empty lines - check
          para.gsub!(/<a href=".+?">(.+?)<\/a>/m,'\1')
          para.gsub!(/<:name#\S+?>/,'')                                       # remove name links
          para.gsub!(/&nbsp;|#{Mx[:nbsp]}/,' ')                               # decide on
          para.gsub!(/(?:^|[^_\\])#{Mx[:lnk_o]}(\S+?\.(?:png|jpg|gif)) .+?#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|image)/,'    [ \1 ]') #"[ #{dir.url.images_local}\/\\1 ]")
          para.gsub!(/(?:^|[^_\\])#{Mx[:lnk_o]}\s*\S+?\.(?:png|jpg|gif)\s+.+?"(.*?)"\s*#{Mx[:lnk_c]}\S+/,'[image: "\1"]')
          if para =~/^@(\S+?):\s+(.+?)\Z/m # for headers
            d_meta=SiSU_TextUtils::HeaderScan.new(@md,para).meta
            if d_meta; wiki_metadata(d_meta)
            end
          end
          if para !~/(^@\S+?:|#{Mx[:br_endnotes]}|#{Mx[:br_eof]})/
            if para =~@regx #/.+?<~\d+;\w\d+;\w\d+>.*/ #watch change
              paranum=para[@regx,3]
              @p_num=Format::ParagraphNumber.new(paranum)
            end
            @sto=SplitTextObject.new(para).lev_segname_para_ocn
            ### problem in scroll, it appears tables are getting paragraph numbers
            m=/#{Mx[:id_o]}~(\d+);(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/
            if para =~m \
            and para=~/\S+/
              para=case @sto.format
              when /^(1)~(?:(\S+))?/
                wiki_structure(para,$1,@sto.ocn,$2)
                @sto.lev_para_ocn.heading_body1
              when /^(2)~(?:(\S+))?/
                wiki_structure(para,$1,@sto.ocn,$2)
                @sto.lev_para_ocn.heading_body2
              when /^(3)~(?:(\S+))?/
                wiki_structure(para,$1,@sto.ocn,$2)
                @sto.lev_para_ocn.heading_body3
              when /^(4)~(\S+)/ # work on see SiSU_text_parts::SplitTextObject
                wiki_structure(para,$1,@sto.ocn,$2)
                @sto.lev_para_ocn.heading_body4
              when /^(5)~(?:(\S+))?/
                wiki_structure(para,$1,@sto.ocn,$2)
                @sto.lev_para_ocn.heading_body5
              when /^(6)~(?:(\S+))?/
                wiki_structure(para,$1,@sto.ocn,$2)
                @sto.lev_para_ocn.heading_body6
              else
                wiki_structure(para,nil,nil,nil) #watch may be problematic
                para
              end
            elsif para =~/#{table_message}/
              @@wiki[:body] << para << @br
            elsif para =~/(Note|Endnotes?)/ \
            and para !~/#{Mx[:id_o]}~\d+;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/
            elsif para =~/(MetaData)/ \
            and para =~/#{Mx[:id_o]}~(\d+);[um]\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/ #debug 2003w46 add rc info ####suspect visit
            elsif para.include? 'Owner Details' \
            and para !~/#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/
            elsif para =~/(#{Mx[:tc_p]}|#{Mx[:gr_o]}Th?)/u #tables ! #fix
            elsif para =~/(.*)<!#!>(.*)/
              one,two=$1,$2
              format_text=FormatTextObject.new(one,two)
              para=format_text.seg_no_paranum
            end
            if (para =~/<a name="n\d+">/ \
            and para =~/^(-\{{2}~\d+|<!e[:_]\d+!>)/) # -endnote
              para=''
            end
            case para
            when /<:i1>/
              if para =~/.*<:#>.*$/
                format_text=FormatTextObject.new(para,'')
                para=format_text.scr_indent_one_no_paranum
              end
            when /<:i2>/
              if para =~/.*<:#>.*$/
                format_text=FormatTextObject.new(para,'')
                para=format_text.scr_indent_one_no_paranum
              end
            end
            if para !~/#{@vz.margin_txt_0}|#{@vz.margin_txt_1}|#{@vz.margin_txt_2}/
              # i don't get the condition for no paranum
            end
            if para =~/<:center>/
              one,two=/(.*)<:center>(.*)/.match(para)[1,2]
              format_text=FormatTextObject.new(one,two)
              para=format_text.center
            end
            para.gsub!(/<!.+!>/,' ') if para ## Clean Prepared Text
            para.gsub!(/<:\S+>/,' ') if para ## Clean Prepared Text
          end
        end
      end
      def publish
        content=[]
        content << @@wiki[:open]
        content << @@wiki[:head]
        content << @@wiki[:body]
        Output.new(content.join,@md).wiki
        @@wiki[:head],@@wiki[:body],@@wiki[:tail],@@wiki[:metadata]=[],[],[],[]
      end
    end
    class Output <Source
      include SiSU_Param
      include SiSU_Env
      def initialize(content,md)
        @content,@md=content,md
      end
      def wiki                                                            #%wiki output
        SiSU_Env::FileOp.new(@md).mkdir
        filename_wiki=SiSU_Env::FileOp.new(@md,@md.fn[:wiki]).mkfile
        @sisu=[]
        @content.each do |para|                                                # this is a hack
          if para =~/^\S/
            if para !~/^([*=-]|\.){5}/; filename_wiki.puts para           #unix wiki
            else                        filename_wiki.puts para           #unix wiki
            end
          else filename_wiki.puts para # if para =~/^\s/
          end
        end
      end
    end
  end
end
__END__
