# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v6/xhtml.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: xhtml output logic, flow
   ** Notes: tidy -xml scroll.xhtml >> index.tidy
=end
module SiSU_XHTML
  require_relative 'defaults'                           # defaults.rb
    include SiSU_Viz
  require_relative 'particulars'                        # particulars.rb
    include SiSU_Particulars
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env
  require_relative 'xml_shared'                         # xml_shared.rb
    include SiSU_XML_Munge
  require_relative 'xml_format'                         # xml_format.rb
    include SiSU_XML_Format
  require_relative 'rexml'                              # rexml.rb
    include SiSU_Rexml
  require_relative 'shared_metadata'                    # shared_metadata.rb
  @@alt_id_count,@@tablehead,@@number_of_cols=0,0,0
  @@tablefoot=''
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(opt)
    end
    def read
      begin
        @env,@md,@ao_array=@particulars.env,@particulars.md,@particulars.ao_array
        unless @opt.act[:quiet][:set]==:on
          tool=if (@opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on)
            "#{@env.program.web_browser} file://#{@md.file.output_path.xhtml.dir}/#{@md.file.base_filename.xhtml}"
          elsif @opt.act[:verbose][:set]==:on
            "#{@env.program.web_browser} file://#{@md.file.output_path.xhtml.dir}/#{@md.file.base_filename.xhtml}"
          else "[#{@opt.f_pth[:lng_is]}] #{@opt.fno}"
          end
          (@opt.act[:verbose][:set]==:on \
          || @opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on) \
          ? SiSU_Screen::Ansi.new(
              @opt.act[:color_state][:set],
              'XHTML',
              tool
            ).green_hi_blue
          : SiSU_Screen::Ansi.new(
              @opt.act[:color_state][:set],
              'XHTML',
              tool
            ).green_title_hi
          if (@opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on)
            SiSU_Screen::Ansi.new(
              @opt.act[:color_state][:set],
              @opt.fns,
              "/#{@md.file.output_path.xhtml.dir}/#{@md.file.base_filename.xhtml}"
            ).flow
          end
        end
        SiSU_XHTML::Source::Songsheet.new(@particulars).song
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.cmd,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
        SiSU_Env::CreateSite.new(@opt).cp_css
        Dir.chdir(@opt.f_pth[:pth])
      end
    end
    private
    class Songsheet
      def initialize(particulars)
        @env,@md,@ao_array,@particulars=particulars.env,particulars.md,particulars.ao_array,particulars
        @file=SiSU_Env::FileOp.new(@md)
      end
      def song
        begin
          SiSU_XHTML::Source::Scroll.new(@particulars).songsheet
          if (@md.opt.act[:verbose][:set]==:on \
          || @md.opt.act[:verbose_plus][:set]==:on \
          || @md.opt.act[:maintenance][:set]==:on)
            SiSU_XHTML::Source::Tidy.new(@md,@file.place_file.xhtml.dir).xml # test wellformedness, comment out when not in use
          end
          SiSU_Rexml::Rexml.new(@md,@file.place_file.xhtml.dir).xml if @md.opt.act[:maintenance][:set]==:on # test rexml parsing, comment out when not in use #debug
        rescue
          SiSU_Errors::Rescued.new($!,$@,@md.opt.cmd,@md.fns).location do
            __LINE__.to_s + ':' + __FILE__
          end
        ensure
        end
      end
    end
    class Scroll
      require_relative 'xhtml_shared'                   # xhtml_shared.rb #check already called
      require_relative 'txt_shared'                     # txt_shared.rb
        include SiSU_TextUtils
      require_relative 'css'                            # css.rb
      @@xml={ body: [], sisu: [], open: [], close: [], head: [] }
      def initialize(particulars)
        @env,@md,@ao_array=particulars.env,particulars.md,particulars.ao_array
        @vz=SiSU_Viz::Defaults.new
        @tab="\t"
        @trans=SiSU_XML_Munge::Trans.new(@md)
        @sys=SiSU_Env::SystemCall.new
      end
      def songsheet
        pre
        @data=markup(@ao_array)
        post
        publish
      end
    protected
      def embedded_endnotes(dob='')
        dob.obj=dob.obj.gsub(/#{Mx[:en_a_o]}(\d+)\s+(.+?)#{Mx[:en_a_c]}/,
            '<endnote><number>\1</number><note>\2</note></endnote> ').
          gsub(/#{Mx[:en_b_o]}([*+]\d+)\s+(.+?)#{Mx[:en_b_c]}/,
            '<endnote><symbol>\1</symbol><note>\2</note></endnote> ').
          gsub(/#{Mx[:en_a_o]}([*+]+)\s+(.+?)#{Mx[:en_a_c]}/,
            '<endnote><symbol>\1</symbol><note>\2</note></endnote> ')
      end
      def extract_endnotes(dob='')
        notes=dob.obj.scan(/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})([\d*+]+\s+.+?)(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/)
        notes.flatten.each do |e|
          s=e.to_s
          util=SiSU_TextUtils::Wrap.new(s,70)
          wrap=util.line_wrap
          wrap=wrap.gsub(/^(\d+)\s+(.+?)\s*\Z/m, <<WOK
#{Ax[:tab]*1}<endnote notenumber="\\1">
#{Ax[:tab]*2}\\1. \\2
#{Ax[:tab]*1}</endnote>
WOK
).
            gsub(/^([*+]\d+)\s+(.+?)\s*\Z/m, <<WOK
#{Ax[:tab]*1}<endnote symbol="\\1">
#{Ax[:tab]*2}\\1 \\2
#{Ax[:tab]*1}</endnote>
WOK
).
            gsub(/^([*+]+)\s+(.+?)\s*\Z/m, <<WOK
#{Ax[:tab]*1}<endnote symbol="\\1.length">
#{Ax[:tab]*2}\\1 \\2
#{Ax[:tab]*1}</endnote>
WOK
)
#KEEP alternative presentation of endnotes
#        wrap=wrap.gsub(/^(\d+)\s+(.+?)\s*\Z/m, <<WOK
##{Ax[:tab]*1}<p class="endnote" notenumber="\\1">
##{Ax[:tab]*2}\\1. \\2
##{Ax[:tab]*1}</p>
#WOK
#)
          @endnotes << wrap
        end
      end
      def xml_head
        metadata=SiSU_Metadata::Summary.new(@md).xhtml_scroll.metadata
        @@xml[:head] << metadata
      end
      def name_tags(dob)
        tags=''
        if defined? dob.tags \
        and dob.tags.length > 0 # insert tags "hypertargets"
          dob.tags.each do |t|
            tags=tags << %{<named id="#{t}" />}
          end
        end
        tags
      end
      def xml_structure(dob,type='norm')
        if dob.is ==:para \
        || dob.is ==:heading
          named=name_tags(dob)
          if dob.is==:heading
            lv=dob.ln
            dob.ln + 2
          else lv=nil
          end
          extract_endnotes(dob)
          dob.obj=dob.obj.gsub(/#{Mx[:en_a_o]}([\d*+]+)\s+(?:.+?)#{Mx[:en_a_c]}/,'<en>\1</en>'). #footnote/endnote clean
            gsub(/#{Mx[:en_b_o]}([\d*+]+)\s+(?:.+?)#{Mx[:en_b_c]}/,'<en>\1</en>') #footnote/endnote clean
          util=SiSU_TextUtils::Wrap.new(dob.obj,70)
          wrapped=util.line_wrap
          @@xml[:body] << if defined? dob.ocn
            %{#{Ax[:tab]*0}<object id="#{dob.ocn}">}
          else                        "#{Ax[:tab]*0}<object>"
          end
          @@xml[:body] << %{#{Ax[:tab]*1}<text class="#{type}">#{named}\n#{Ax[:tab]*2}#{wrapped}\n#{Ax[:tab]*1}</text>} unless lv  # main text, contents, body KEEP
          @@xml[:body] << %{#{Ax[:tab]*1}<text class="h#{lv}">#{named}\n#{Ax[:tab]*2}#{wrapped}\n#{Ax[:tab]*1}</text>} if lv # main text, contents, body KEEP
          @@xml[:body] << @endnotes.compact.join if @endnotes.length > 0 # main text, endnotes KEEP
          @@xml[:body] << "#{Ax[:tab]*1}<ocn>#{dob.ocn}</ocn>" if defined? dob.ocn
          @@xml[:body] << "#{Ax[:tab]*0}</object>"
          @endnotes=[]
        end
      end
      def block_structure(dob)
        named=name_tags(dob)
        dob=@trans.markup_block(dob)
        dob.obj=dob.obj.strip.
          gsub(/#{Mx[:en_a_o]}([\d*+]+)\s+(?:.+?)#{Mx[:en_a_c]}/,'<en>\1</en>'). #footnote/endnote clean
          gsub(/#{Mx[:en_b_o]}([\d*+]+)\s+(?:.+?)#{Mx[:en_b_c]}/,'<en>\1</en>') #footnote/endnote clean
        @@xml[:body] << %{#{Ax[:tab]*0}<object id="#{dob.ocn}">}
        @@xml[:body] << %{#{Ax[:tab]*1}<ocn>#{dob.ocn}</ocn>}
        @@xml[:body] << %{#{Ax[:tab]*1}<text class="block">#{named}#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*2}#{dob.obj}#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*1}</text>}
        @@xml[:body] << "#{Ax[:tab]*0}</object>"
      end
      def group_structure(dob)
        named=name_tags(dob)
        dob=@trans.markup_group(dob)
        dob.obj=dob.obj.strip.
          gsub(/#{Mx[:en_a_o]}([\d*+]+)\s+(?:.+?)#{Mx[:en_a_c]}/,'<en>\1</en>'). #footnote/endnote clean
          gsub(/#{Mx[:en_b_o]}([\d*+]+)\s+(?:.+?)#{Mx[:en_b_c]}/,'<en>\1</en>') #footnote/endnote clean
        @@xml[:body] << %{#{Ax[:tab]*0}<object id="#{dob.ocn}">}
        @@xml[:body] << %{#{Ax[:tab]*1}<ocn>#{dob.ocn}</ocn>}
        @@xml[:body] << %{#{Ax[:tab]*1}<text class="group">#{named}#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*2}#{dob.obj}#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*1}</text>}
        @@xml[:body] << "#{Ax[:tab]*0}</object>"
      end
      def poem_structure(dob)
        named=name_tags(dob)
        dob=@trans.markup_group(dob)
        dob.obj=dob.obj.strip
        @@xml[:body] << %{#{Ax[:tab]*0}<object id="#{dob.ocn}">}
        @@xml[:body] << %{#{Ax[:tab]*1}<ocn>#{dob.ocn}</ocn>}
        @@xml[:body] << %{#{Ax[:tab]*1}<text class="verse">#{named}#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*2}#{dob.obj}#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*1}</text>}
        @@xml[:body] << "#{Ax[:tab]*0}</object>"
      end
      def code_structure(dob)
        named=name_tags(dob)
        dob=@trans.markup_group(dob)
        dob.obj=dob.obj.gsub(/\s\s/,'&#160;&#160;').strip
        @@xml[:body] << %{#{Ax[:tab]*0}<object id="#{dob.ocn}">}
        @@xml[:body] << %{#{Ax[:tab]*1}<ocn>#{dob.ocn}</ocn>}
        @@xml[:body] << %{#{Ax[:tab]*1}<text class="code">#{named}#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*2}#{dob.obj}#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*1}</text>}
        @@xml[:body] << "#{Ax[:tab]*0}</object>"
      end
      def table_structure(dob)
        named=name_tags(dob)
        table=SiSU_XHTML_Shared::TableXHTML.new(dob)
        @@xml[:body] << %{#{Ax[:tab]*0}<object id="#{dob.ocn}">}
        @@xml[:body] << %{#{Ax[:tab]*1}<ocn>#{dob.ocn}</ocn>}
        @@xml[:body] << %{#{Ax[:tab]*2}#{named}#{table.table.obj}}
        @@xml[:body] << "#{Ax[:tab]*0}</object>"
      end
      def markup(data)
        @endnotes=[]
        @rcdc=false
        @level,@cont,@copen,@xml_contents_close=[],[],[],[]
        xml_head
        (0..6).each { |x| @cont[x]=@level[x]=false }
        (4..6).each { |x| @xml_contents_close[x]='' }
        data.each do |dob|
          dob=@trans.char_enc.utf8(dob) if @sys.locale =~/utf-?8/i #% utf8
          dob=@trans.markup(dob)
          if @rcdc==false \
          and (dob.obj =~/~meta/ \
          and dob.obj =~/Document Information/)
            @rcdc=true
          end
          if dob.obj !~/(^#{Rx[:meta]}|#{Mx[:br_eof]}|#{Mx[:br_endnotes]})/
            if defined? dob.ocn #look to move to format section
              ocn=(dob.ocn.to_s =~/\d+/) ? dob.ocn : nil
              @p_num=SiSU_XML_Format::ParagraphNumber.new(@md,ocn)
            end
            if not @rcdc
              x=SiSU_XML_Format::FormatSeg.new(@md,dob)
              if dob.is==:heading
                xml_structure(dob)
                dob.obj=case dob.ln
                when 0 then x.heading_body0
                when 1 then x.heading_body1
                when 2 then x.heading_body2
                when 3 then x.heading_body3
                when 4 then x.heading_body4
                when 5 then x.heading_body5
                when 6 then x.heading_body6
                end
              else
                if dob.is ==:verse
                  poem_structure(dob)
                elsif dob.is ==:group
                  group_structure(dob)
                elsif dob.is ==:block
                  block_structure(dob)
                elsif dob.is ==:code
                  code_structure(dob)
                elsif dob.is ==:table
                  table_structure(dob)
                elsif dob.is ==:para \
                and dob.indent.to_s =~/[1-9]/ \
                and dob.bullet_==true
                  xml_structure(dob,"indent_bullet#{dob.indent}")
                elsif dob.is ==:para \
                and dob.indent.to_s =~/[1-9]/ \
                and dob.indent == dob.hang
                  xml_structure(dob,"indent#{dob.indent}")
                elsif dob.is==:para \
                and dob.hang.to_s =~/[0-9]/ \
                and dob.indent != dob.hang
                  xml_structure(dob,"hang#{dob.hang.to_s}_indent#{dob.indent.to_s}")
                else xml_structure(dob)
                end
              end
              if dob.obj =~/.*<:#>.*$/ #investigate removal
                dob.obj=if dob.obj =~ /#{Mx[:pa_o]}:i[1-9]#{Mx[:pa_c]}/
                  txt_obj={ txt: dob }
                  format_text=FormatTextObject.new(@md,txt_obj)
                  format_text.scr_inden_ocn_e_no_paranum
                end
              end
              if dob.obj !~/#{@vz.margin_txt_0}|#{@vz.margin_txt_1}|#{@vz.margin_txt_2}/
              end
            else #
            end
            dob.obj=dob.obj.gsub(/#{Mx[:pa_o]}:\S+#{Mx[:pa_c]}/,'') if dob.obj
          end
        end
        6.downto(4) do |x|
          y=x - 1; v=x - 3
          @@xml[:body] << "#{Ax[:tab]*5}</content>\n#{Ax[:tab]*y}</contents#{v}>" if @level[x]==true
        end
        3.downto(1) do |x|
          y=x - 1
          @@xml[:body] << "#{Ax[:tab]*y}</heading#{x}>" if @level[x]==true
        end
      end
      def pre
        rdf=SiSU_XML_Tags::RDF.new(@md)
        @@xml[:head],@@xml[:body]=[],[]
        stylesheet=SiSU_Style::CSS_HeadInfo.new(@md,'xhtml').stylesheet
        encoding=(@sys.locale =~/utf-?8/i) ? '<?xml version="1.0" encoding="UTF-8" standalone="no"?>' : '<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>'
        @@xml[:open] =<<WOK
#{encoding}
#{stylesheet.css_head_xml}
#{rdf.comment_xml}
<document>
WOK
        @@xml[:head] << %{<head>\n\t<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />}
        @@xml[:body] << '<body>'
      end
      def post
        @@xml[:head] << '</head>'
        @@xml[:body] << '</body>'
        @@xml[:close] = '</document>'
      end
      def publish
        content=[]
        content << @@xml[:open] << @@xml[:head] << @@xml[:body] << @@xml[:metadata]
        content << @@xml[:owner_details] if @md.stmp =~/\w\w/
        content << @@xml[:tail] << @@xml[:close]
        content=content.flatten.compact
        Output.new(content,@md).xhtml
        @@xml={}
      end
    end
    class Output
      def initialize(data,md)
        @data,@md=data,md
        @file=SiSU_Env::FileOp.new(@md)
      end
      def xhtml
        SiSU_Env::FileOp.new(@md).mkdir
        filename_xml=@file.write_file.xhtml
        @data.each do |str|
          str=str.gsub(/\A\s+\Z/m,'') #str.gsub(/^\s+$/,'')
          filename_xml.puts str unless str.empty?
        end
        filename_xml.close
      end
    end
    class Tidy
      def initialize(md,file)
        @md,@file=md,file
        @prog=SiSU_Env::InfoProgram.new
      end
      def xml
        if @prog.tidy !=false
          if (@md.opt.act[:verbose_plus][:set]==:on \
          || @md.opt.act[:maintenance][:set]==:on)
            unless @md.opt.act[:quiet][:set]==:on
              SiSU_Screen::Ansi.new(
                @md.opt.act[:color_state][:set],
                'invert',
                'Using XML Tidy',
                'check document structure'
              ).colorize
              tell=SiSU_Screen::Ansi.new(
                     @md.opt.act[:color_state][:set],
                     'invert',
                     '',
                     ''
                   )
              tell.grey_open
            end
            tidyfile='/dev/null' #don't want one or screen output, check for alternative flags
            tidy=SiSU_Env::SystemCall.new(@file,tidyfile)
            tidy.well_formed?
            tell.p_off unless @md.opt.act[:quiet][:set]==:on
          end
        end
      end
    end
  end
end
__END__
<?xml version="1.0"?>
<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>
<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<?xml version="1.0" encoding="UTF-16" standalone="no"?>
