/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (XIMProtocol_h)
#define	XIMProtocol_h

#include <X11/Xproto.h>

/*
 *	X Input Method Server Definitions
 */

#define XIM_SERVER_NAME				"skkinput"

#define	XIM_PROTOCOL_MAJOR_VERSION		(1)
#define	XIM_PROTOCOL_MINOR_VERSION		(0)

#define XIM_SERVERMAJOR_TRANSPORT_VERSION	(0)
#define XIM_SERVERMINOR_TRANSPORT_VERSION	(2)
#define XTRANSPORT_UNIT_SIZE				(20)
#define XTRANSPORT_DIVIDING_SIZE			(XTRANSPORT_UNIT_SIZE * 5)

/*
 *	X Input Method Protocol Packet Header Size
 */
#define	XIM_HEADER_SIZE	((sizeof (CARD8) + sizeof (CARD8) + sizeof (CARD16)) / sizeof (CARD8))

/*
 *	X Input Method Protocol Major Message Type
 */
#define	XIM_CONNECT					(1)
#define	XIM_CONNECT_REPLY			(2)
#define	XIM_DISCONNECT				(3)
#define	XIM_DISCONNECT_REPLY		(4)

#define	XIM_AUTH_REQUIRED			(10)
#define	XIM_AUTH_REPLY				(11)
#define	XIM_AUTH_NEXT				(12)
#define	XIM_AUTH_SETUP				(13)
#define	XIM_AUTH_NG					(14)

#define	XIM_ERROR					(20)

#define	XIM_OPEN					(30)
#define	XIM_OPEN_REPLY				(31)
#define	XIM_CLOSE					(32)
#define	XIM_CLOSE_REPLY				(33)
#define	XIM_REGISTER_TRIGGERKEYS	(34)
#define	XIM_TRIGGER_NOTIFY			(35)
#define	XIM_TRIGGER_NOTIFY_REPLY	(36)
#define	XIM_SET_EVENT_MASK			(37)
#define	XIM_ENCODING_NEGOTIATION	(38)
#define	XIM_ENCODING_NEGOTIATION_REPLY		(39)
#define	XIM_QUERY_EXTENSION			(40)
#define	XIM_QUERY_EXTENSION_REPLY	(41)
#define	XIM_SET_IM_VALUES			(42)
#define	XIM_SET_IM_VALUES_REPLY		(43)
#define	XIM_GET_IM_VALUES			(44)
#define	XIM_GET_IM_VALUES_REPLY		(45)

#define	XIM_CREATE_IC				(50)
#define	XIM_CREATE_IC_REPLY			(51)
#define	XIM_DESTROY_IC				(52)
#define	XIM_DESTROY_IC_REPLY		(53)
#define	XIM_SET_IC_VALUES			(54)
#define	XIM_SET_IC_VALUES_REPLY		(55)
#define	XIM_GET_IC_VALUES			(56)
#define	XIM_GET_IC_VALUES_REPLY		(57)
#define	XIM_SET_IC_FOCUS			(58)
#define	XIM_UNSET_IC_FOCUS			(59)
#define	XIM_FORWARD_EVENT			(60)
#define	XIM_SYNC					(61)
#define	XIM_SYNC_REPLY				(62)
#define	XIM_COMMIT					(63)
#define	XIM_RESET_IC				(64)
#define	XIM_RESET_IC_REPLY			(65)

#define	XIM_GEOMETRY				(70)
#define	XIM_STR_CONVERSION			(71)
#define	XIM_STR_CONVERSION_REPLY	(72)
#define	XIM_PREEDIT_START			(73)
#define	XIM_PREEDIT_START_REPLY		(74)
#define	XIM_PREEDIT_DRAW			(75)
#define	XIM_PREEDIT_CARET			(76)
#define	XIM_PREEDIT_CARET_REPLY		(77)
#define	XIM_PREEDIT_DONE			(78)
#define	XIM_STATUS_START			(79)
#define	XIM_STATUS_DRAW				(80)
#define	XIM_STATUS_DONE				(81)
#define	XIM_PREEDITSTATE			(82)

#define XIM_EXT_SET_EVENT_MASK		(129)
#define XIM_EXT_FORWARD_KEYEVENT	(130)
#define XIM_EXT_MOVE				(131)

#define XIM_EXT_SET_EVENT_MASK_MASK	(1)
#define XIM_EXT_FORWARD_KEYEVENT_MASK		(2)
#define XIM_EXT_MOVE_MASK			(4)

/*
 *	X Input Method Protocol ХȽ
 */
#define XIM_BIGENDIAN				((CARD8)0x42)
#define XIM_LITTLEENDIAN			((CARD8)0x6c)

/*
 *	X Input Method Protocol Error 
 */
#define XIM_ERROR_BadAlloc			(1)
#define XIM_ERROR_BadStyle			(2)
#define XIM_ERROR_BadClientWindow		(3)
#define XIM_ERROR_BadFocusWindow		(4)
#define XIM_ERROR_BadArea			(5)
#define XIM_ERROR_BadSpotLocation		(6)
#define XIM_ERROR_BadColormap			(7)
#define XIM_ERROR_BadAtom			(8)
#define XIM_ERROR_BadPixel			(9)
#define XIM_ERROR_BadPixmap			(10)
#define XIM_ERROR_BadName			(11)
#define XIM_ERROR_BadCursor			(12)
#define XIM_ERROR_BadProtocol			(13)
#define XIM_ERROR_BadForeground			(14)
#define XIM_ERROR_BadBackground			(15)
#define XIM_ERROR_LocaleNotSupported		(16)
#define XIM_ERROR_BadSomething			(999)

/*
 *	type of the value 
 */
#define	XIM_VALUE_TYPE_SEPARATOR		(0)
#define	XIM_VALUE_TYPE_BYTE			(1)
#define	XIM_VALUE_TYPE_WORD			(2)
#define	XIM_VALUE_TYPE_LONG			(3)
#define	XIM_VALUE_TYPE_CHAR			(4)
#define	XIM_VALUE_TYPE_WINDOW			(5)
#define	XIM_VALUE_TYPE_XIMSTYLES		(10)
#define	XIM_VALUE_TYPE_XRECTANGLE		(11)
#define	XIM_VALUE_TYPE_XPOINT			(12)
#define	XIM_VALUE_TYPE_XFONTSET			(13)
#define	XIM_VALUE_TYPE_XIMHOTKEYTRIGGERS	(15)
#define	XIM_VALUE_TYPE_XIMHOTKEYSTATE		(16)
#define	XIM_VALUE_TYPE_XIMSTRINGCONVERSION	(17)
#define	XIM_VALUE_TYPE_XIMPREEDITSTATE		(18)
#define	XIM_VALUE_TYPE_XIMRESETSTATE		(19)
#define	XIM_VALUE_TYPE_NESTEDLIST		(0x7FFF)

/*
 * ¾­ʤɡ
 */
#define	XIMPreeditMask	(XIMPreeditArea | XIMPreeditCallbacks | XIMPreeditPosition | XIMPreeditNothing | XIMPreeditNone)
#define	XIMStatusMask	(XIMStatusArea | XIMStatusCallbacks | XIMStatusNothing | XIMStatusNone)

/*
 *	ޥ
 */
#define	IMPAD(length)	((4 - ((length) % 4)) % 4)

/*
 *	X Input Method ѿ()
 */
/*typedef unsigned char	CARD8 ;*/
/*typedef unsigned short	CARD16 ;*/
/*typedef short		INT16 ;*/
/*typedef unsigned long	CARD32 ;*/
typedef CARD16		BITMASK16 ;
typedef CARD32		BITMASK32 ;
/*typedef unsigned long	XIMStyle ;*/
typedef char*		STRING8 ;

#define	GET_VALUE_LENGTH(value_type)	((int)(sizeof (value_type) / sizeof (CARD8)))

#endif

