/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A date edit for skrooge.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgdateedit.h"

#include <QKeyEvent>
#include <QApplication>

SKGDateEdit::SKGDateEdit(QWidget *parent)
                : QDateEdit(parent)
{
        setDate(QDate::currentDate());
}

SKGDateEdit::~SKGDateEdit()
{
}

void SKGDateEdit::keyPressEvent( QKeyEvent * event )
{
        if (event->count()==1 && event->key()==Qt::Key_Plus) {
                setDate(QApplication::keyboardModifiers()&Qt::ControlModifier ? this->date().addMonths(1) :this->date().addDays(1));
                event->accept();
        } else
                if (event->count()==1 && event->key()==Qt::Key_Minus) {
                        setDate(QApplication::keyboardModifiers()&Qt::ControlModifier ? this->date().addMonths(-1) :this->date().addDays(-1));
                        event->accept();
                } else
                        if (event->count()==1 && event->key()==Qt::Key_Equal) {
                                this->setDate(QDate::currentDate());
                                event->accept();
                        } else QDateEdit::keyPressEvent(event);
}

#include "skgdateedit.moc"

