/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGOBJECTMODEL_H
#define SKGOBJECTMODEL_H
/** @file
 * This file is part of Skrooge and defines classes SKGObjectModel.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgobjectmodelbase.h"
#include "skgobjectbase.h"

#include <kglobal.h>

#include <QColor>
#include <QFont>

class SKGDocumentBank;

/**
 * The Table model managing SKGObjectBase
 */
class KDE_EXPORT SKGObjectModel : public SKGObjectModelBase
{
        Q_OBJECT
public:
        /**
         * Default constructor
         * @param iDocument the document where to search
         * @param iTable the table where to search
         * @param iWhereClause the where clause
         * @param parent parent QT object
         * @param iParentAttribute the attribute to find the parent of an object clause to find children
         * @param iResetOnCreation to reset data during creation
         */
        SKGObjectModel(SKGDocumentBank* iDocument,
                       const QString& iTable,
                       const QString& iWhereClause,
                       QObject *parent=NULL,
                       const QString& iParentAttribute="",
                       bool iResetOnCreation=true);

        /**
         * Destructor
         */
        virtual ~SKGObjectModel();

        /**
         * Returns the data stored under the given role for the item referred to by the index.
         * @param index the index
         * @param role the role
         * @return the returned value
         */
        virtual QVariant data ( const QModelIndex & index, int role = Qt::DisplayRole ) const;

        /**
         * Sets the role data for the item at index to value. Returns true if successful; otherwise returns false.
         * @param index index of the object
         * @param value value
         * @param role role
         * @return
         */
        virtual bool setData(const QModelIndex & index, const QVariant & value, int role = Qt::EditRole);

        /**
         * Returns the data for the given role and section in the header with the specified orientation.
         * @param section the section
         * @param orientation the orientation
         * @param role the role
         * @return the header data
         */
        virtual QVariant headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;

        /**
         * Returns the item flags for the given index.
         * @param index index of the object
         * @return flags of the given index
         */
        virtual Qt::ItemFlags flags(const QModelIndex &index) const;

        /**
         * Returns the actions supported by the data in this model.
         * @return Qt::DropActions
         */
        virtual Qt::DropActions supportedDragActions() const;

        /**
         * Returns the actions supported by the data in this model.
         * @return Qt::DropActions
         */
        virtual Qt::DropActions supportedDropActions() const;

        /**
         * Handles the data supplied by a drag and drop operation that ended with the given action.
         * Returns true if the data and action can be handled by the model; otherwise returns false.
         * Although the specified row, column and parent indicate the location of an item in the model where the operation ended,
         *it is the responsibility of the view to provide a suitable location for where the data should be inserted.
         * @param data mime data
         * @param action action
         * @param row row
         * @param column column
         * @param parent parent
         * @return true if the dropping was successful otherwise false.
         */
        virtual bool dropMimeData(const QMimeData *data,
                                  Qt::DropAction action,
                                  int row, int column,
                                  const QModelIndex &parent);

protected slots:
        /**
         * This method is called by refresh to build the cache (to improve performance)
         */
        virtual void buidCache();

        /**
         * data are modified
         * @param iTableName table name
         * @param iIdTransaction the id of the transaction for direct modifications of the table (update of modify objects is enough)
         *or 0 in case of modifications by impact (full table must be refreshed)
         */
        virtual void dataModified(const QString& iTableName, int iIdTransaction);

private:
        Q_DISABLE_COPY(SKGObjectModel);

        QString cacheUnit;
        bool operationTable;
        bool recurrentoperationTable;
        bool refundTable;
        bool accountTable;
        bool unitTable;
        bool unitvalueTable;

        QFont fontFutureOperations;
        QColor fontFutureOperationsColor;
};

#endif
