/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is part of Skrooge and implements classes SKGRefundTrackerObject.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgrefundtrackerobject.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"

SKGRefundTrackerObject::SKGRefundTrackerObject(const SKGDocument* iDocument, int iID): SKGNamedObject(iDocument, "v_refund", iID)
{
}

SKGRefundTrackerObject::~SKGRefundTrackerObject()
{
}

SKGRefundTrackerObject::SKGRefundTrackerObject(const SKGRefundTrackerObject& iObject)
                :SKGNamedObject(iObject)
{
}

SKGRefundTrackerObject::SKGRefundTrackerObject ( const SKGObjectBase& iObject )

{
        if ( iObject.getRealTable() =="refund" ) {
                copyFrom ( iObject );
        } else {
                *this=SKGNamedObject::SKGNamedObject ( iObject.getDocument(), "v_refund", iObject.getID() );
        }
}

const SKGRefundTrackerObject& SKGRefundTrackerObject::operator= (const SKGObjectBase& iObject)
{
        copyFrom(iObject);
        return *this;
}

SKGError SKGRefundTrackerObject::createRefund ( const SKGDocumentBank* iDocument,
                const QString& iName,
                SKGRefundTrackerObject& oRefund,
                bool iSendPopupMessageOnCreation )
{
        SKGError err;
        SKGTRACEINRC ( 10, "SKGRefundTrackerObject::createRefund", err );

        //Check if refund is already existing
        SKGObjectBase::getObject ( iDocument, "v_refund", "t_name='"+SKGServices::stringToSqlString ( iName ) +'\'', oRefund );
        if ( oRefund.getID() ==0 ) {
                //No, we have to create it
                oRefund = SKGRefundTrackerObject ( ( SKGDocumentBank* ) iDocument );
                err=oRefund.setName ( iName );
                if ( err.isSucceeded() ) err=oRefund.save();

                if ( err.isSucceeded() && iSendPopupMessageOnCreation && iDocument ) {
                        ( ( SKGDocumentBank* ) iDocument )->sendMessage ( tr ( "Refund [%1] has been created" ).arg ( iName ), true );
                }
        }

        return err;
}

SKGError SKGRefundTrackerObject::getSubOperations(SKGListSKGObjectBase& oSubOperations) const
{
        SKGError err = getObjects(getDocument(), "v_suboperation",
                                  "r_refund_id="+ SKGServices::intToString(getID()) ,
                                  oSubOperations);
        return err;
}

SKGError SKGRefundTrackerObject::setClosed(bool iClosed)
{
        return setAttribute("t_close", iClosed ? "Y" :"N");
}

bool SKGRefundTrackerObject::isClosed() const
{
        return (getAttribute("t_close")=="Y" ? true : false);
}

SKGError SKGRefundTrackerObject::setComment(const QString& iComment)
{
        return setAttribute("t_comment", iComment);
}

QString SKGRefundTrackerObject::getComment() const
{
        return getAttribute("t_comment");
}

double SKGRefundTrackerObject::getCurrentAmount() const
{
        return SKGServices::stringToDouble(getAttribute("f_CURRENTAMOUNT"));
}

#include "skgrefundtrackerobject.moc"
