/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgimportexportmanager.h"
#include "skgbankincludes.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
        Q_UNUSED(argc);
        Q_UNUSED(argv);

        //Init test
        SKGINITTEST(true);

        QDate now=QDate::currentDate();

        {
                //Test import OFX skrooge
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);

                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::OFX, getTestPath("IN")+"/skgtestimportofx/ofx_spec160_stmtrs_example.ofx");
                        SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
                        document1.dump(DUMPOPERATION|DUMPACCOUNT);
                }

                {
                        //To check double import
                        SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::OFX, getTestPath("IN")+"/skgtestimportofx/ofx_spec160_stmtrs_example.ofx");
                        SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
                }
                SKGAccountObject account;
                SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "Bank account 999988", account), true);
                SKGTESTERROR("ACCOUNT.load", account.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "-500");
        }

        {
                //Test import OFX skrooge
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);

                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::OFX, getTestPath("IN")+"/skgtestimportofx/ofx_spec201_stmtrs_example.ofx");
                        SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
                        document1.dump(DUMPOPERATION|DUMPACCOUNT);
                }

                SKGAccountObject account;
                SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "Bank account 999988", account), true);
                SKGTESTERROR("ACCOUNT.load", account.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "-500");
        }

        {
                //Test import OFX skrooge
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);

                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::OFX, getTestPath("IN")+"/skgtestimportofx/t1.ofx");
                        SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
                        document1.dump(DUMPOPERATION|DUMPACCOUNT);
                }

                SKGAccountObject account;
                SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "Investment account 12345 at broker ameritrade.com", account), true);
                SKGTESTERROR("ACCOUNT.load", account.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "1672.84");
        }

        {
                //Test import OFX skrooge
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);

                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::OFX, getTestPath("IN")+"/skgtestimportofx/385366.ofx");
                        SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
                        document1.dump(DUMPOPERATION|DUMPACCOUNT);
                }

                SKGAccountObject account;
                SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "Investment account 209830947 at broker fidelity.com", account), true);
                SKGTESTERROR("ACCOUNT.load", account.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "-1.818989404e-12");
        }

        {
                //Test import OFX skrooge
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);

                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::OFX, getTestPath("IN")+"/skgtestimportofx/430130.ofx");
                        SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
                        document1.dump(DUMPOPERATION|DUMPACCOUNT);
                }

                SKGAccountObject account;
                SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "Bank account 1234567L123", account), true);
                SKGTESTERROR("ACCOUNT.load", account.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "3366.86");
        }

        {
                //Test import OFX skrooge
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);

                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_OFX", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::OFX, getTestPath("IN")+"/skgtestimportofx/ca_remi.ofx");
                        SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
                        document1.dump(DUMPOPERATION|DUMPACCOUNT);
                }
                QStringList oResult;
                SKGTESTERROR("ACCOUNT:getDistinctValues", SKGServices::getDistinctValues(&document1, "account", "t_name", oResult), true);
                SKGTEST("ACCOUNT:oResult.size", oResult.size(), 5);


                /*SKGAccountObject account;
                SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "Bank account 1234567L123", account), true);
                SKGTESTERROR("ACCOUNT.load", account.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "3366.86");*/
        }
        //End test
        SKGENDTEST();
}
