/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include <QFile>

#include "skgdocumentbank.h"

/**
 * The full test
 * @param  iMode the database mode
 * @param  nberror the variable containing number of errors
 * @param  nbcheck the variable containing number of checks
 * @param  showonlyfailures the variable containing number of showonlyfailures
 */
void fileTest(SKGDocument::DatabaseMode iMode, int& nberror, int& nbcheck, bool showonlyfailures)
{
        //Test load old version of files
        {
                SKGDocumentBank document1(iMode);
                SKGTESTERROR("DOC:load", document1.load(getTestPath("IN")+"/skgtestmigration/version_0.1.skg"), true);
        }
        {
                SKGDocumentBank document1(iMode);
                SKGTESTERROR("DOC:load", document1.load(getTestPath("IN")+"/skgtestmigration/version_0.3.skg"), true);
        }
}
/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
        Q_UNUSED(argc);
        Q_UNUSED(argv);

        //Init test
        SKGINITTEST(true);
        fileTest(SKGDocument::CopiedInMemory, nberror, nbcheck, showonlyfailures);
        fileTest(SKGDocument::CopiedInFile, nberror, nbcheck, showonlyfailures);
        //MUST BE DONE: fileTest(SKGDocument::DirectAccess, nberror, nbcheck, showonlyfailures);

        //End test
        SKGENDTEST();
}
