/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGWIDGET_H
#define SKGWIDGET_H
/** @file
 * This file is a class managing widget.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include <kglobal.h>
#include <QWidget>

class SKGDocument;

/**
 * This file is Skrooge tab widget used by plugins
 */
class KDE_EXPORT SKGWidget : public QWidget
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         */
        SKGWidget(SKGDocument* iDocument);

        /**
         * Default Destructor
         */
        virtual ~SKGWidget();

        /**
         * Get main document
         * @return pointer on main document
         */
        virtual SKGDocument* getDocument();

        /**
         * Get the current state
         * MUST BE OVERWRITTEN
         * @return a string containing all information needed to set the same state.
         * Could be an XML stream
         */
        virtual QString getState();

        /**
         * Set the current state
         * MUST BE OVERWRITTEN
         * @param iState must be interpreted to set the state of the widget
         */
        virtual void setState(const QString& iState);

        /**
         * Get attribute name to save the default state
         * MUST BE OVERWRITTEN
         * @return attribute name to save the default state.
         */
        virtual QString getDefaultStateAttibute();

private:
        Q_DISABLE_COPY(SKGWidget);

        SKGDocument*  document;
};

#endif // SKGWIDGET_H
