/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
        Q_UNUSED(argc);
        Q_UNUSED(argv);

        //Init test
        SKGINITTEST(true);

        //test class SKGDocument / PARAMETERS
        {
                SKGDocument document1;
                SKGTESTERROR("PARAM:initialize", document1.initialize(), true);
                SKGTESTERROR("PARAM:beginTransaction", document1.beginTransaction("t1"), true);
                SKGTESTERROR("PARAM:setParameter", document1.setParameter("ATT1", "VAL1"), true);
                SKGTEST("PARAM:getParameter", document1.getParameter("ATT1"), "VAL1");
                SKGTESTERROR("PARAM:setParameter", document1.setParameter("ATT1", "VAL1UPDATED"), true);
                SKGTEST("PARAM:getParameter", document1.getParameter("ATT1"), "VAL1UPDATED");
                SKGTESTERROR("PARAM:setParameter", document1.setParameter("ATT2", "VAL2"), true);
                SKGTEST("PARAM:getParameter", document1.getParameter("ATT1"), "VAL1UPDATED");
                SKGTEST("PARAM:getParameter", document1.getParameter("ATT2"), "VAL2");
                SKGTEST("PARAM:getParameter", document1.getParameter("NOTFOUND"), "");
                SKGTESTERROR("PARAM:setParameter+sql injection", document1.setParameter("'", "VAL3"), true);
                SKGTEST("PARAM:getParameter+sql injection", document1.getParameter("'"), "VAL3");
                SKGTESTERROR("PARAM:endTransaction", document1.endTransaction(true), true);
        }

        //Test parameters on object
        {
                SKGDocumentBank document1;
                SKGTESTERROR("PROP:initialize", document1.initialize(), true);
                SKGTESTERROR("PROP:beginTransaction", document1.beginTransaction("t1"), true);
                SKGTESTERROR("PROP:setParameter", document1.setParameter("ATT1", "VAL1"), true);

                SKGObjectBase obj1(&document1, "bank");
                SKGTESTERROR("PROP:setAttribute", obj1.setAttribute("t_name", "CL"), true);
                SKGTESTERROR("PROP:Replace", obj1.save(), true);

                SKGTESTERROR("PROP:setProperty", obj1.setProperty("ATT1", "VAL2", QVariant(145)), true);

                //Check
                SKGTEST("PROP:getParameter", document1.getParameter("ATT1"), "VAL1");
                SKGTEST("PROP:getProperty", obj1.getProperty("ATT1"), "VAL2");
                SKGTEST("PROP:getProperty", obj1.getPropertyBlob("ATT1").toInt(), 145);

                QStringList oResult;
                SKGTESTERROR("PROP:getDistinctValues", SKGServices::getDistinctValues(&document1, "parameters", "t_value", "t_value like 'VAL%'", oResult), true);
                SKGTEST("PROP:oResult.size", oResult.size(), 2);

                //delete cascade
                SKGTESTERROR("PROP:Replace", obj1.remove(), true);
                SKGTESTERROR("PROP:getDistinctValues", SKGServices::getDistinctValues(&document1, "parameters", "t_value", "t_value like 'VAL%'", oResult), true);
                SKGTEST("PROP:oResult.size", oResult.size(), 1);
        }


	{
	        SKGDocumentBank document1;
                SKGTESTERROR("DOC:initialize", document1.initialize(), true);
		QStringList listTables;
		SKGTESTERROR("SKGServices::getTablesList", SKGServices::getTablesList(&document1, listTables), true);
		foreach(const QString& table, listTables)
		{
		  document1.getDisplaySchemas(table);
		}
	}

        //End test
        SKGENDTEST();
}
