/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a class managing widget.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtabpage.h"
#include "skgnodeobject.h"
#include "skgservices.h"
#include "skgdocument.h"
#include "skgtransactionmng.h"
#include "skgtraces.h"
#include "skgmainpanel.h"

#include "kmessagebox.h"

#include <QtGui/QWidget>

SKGTabPage::SKGTabPage(SKGDocument* iDocument)
                : SKGWidget(iDocument)
{
        SKGTRACEIN(5, "SKGTabPage::SKGTabPage");
}

SKGTabPage::~SKGTabPage()
{
        SKGTRACEIN(5, "SKGTabPage::~SKGTabPage");
}

bool SKGTabPage::close()
{
        SKGTRACEIN(5, "SKGTabPage::close");
        overwrite();
        return QWidget::close();
}

SKGObjectBase::SKGListSKGObjectBase SKGTabPage::getSelectedObjects()
{
        SKGObjectBase::SKGListSKGObjectBase selection;
        return selection;
}

int SKGTabPage::getNbSelectedObjects()
{
        return getSelectedObjects().count();
}

QWidget* SKGTabPage::getWidgetForPrint()
{
        return this;
}

void SKGTabPage::setBookmarkID(const QString& iId)
{
        bookmarkID=iId;
}

QString SKGTabPage::getBookmarkID()
{
        return bookmarkID;
}
QList<SKGTabPage::SKGPageHistoryItem> SKGTabPage::getPreviousPages()
{
        return previousPages;
}

void SKGTabPage::setPreviousPages(const QList<SKGTabPage::SKGPageHistoryItem>& iPages)
{
        previousPages=iPages;
}

QList<SKGTabPage::SKGPageHistoryItem> SKGTabPage::getNextPages()
{
        return nextPages;
}

void SKGTabPage::setNextPages(const QList<SKGTabPage::SKGPageHistoryItem>& iPages)
{
        nextPages=iPages;
}

bool SKGTabPage::isOverwriteNeeded()
{
        //Is this widget linked to a bookmark ?
        if (bookmarkID.length()) {
                //Yes. Is state modified ?
                SKGNodeObject node(getDocument(), SKGServices::stringToInt(bookmarkID));
                if (node.exist()) {
                        QStringList data=SKGServices::splitCSVLine(node.getData());
                        QString fullname=node.getFullName();
                        if (data.count()>3) {
                                QString currentState=getState().trimmed();
                                QString oldState=data[3].trimmed();
                                currentState.remove('\n');
                                oldState.remove('\n');
                                SKGTRACEL(5) << "oldState      =[" << oldState << ']' << endl;
                                SKGTRACEL(5) << "currentState  =[" << currentState << ']' << endl;
                                SKGTRACEL(5) << "Bookmark diff =" << (currentState!=oldState ? "TRUE" : "FALSE") << endl;
                                return (currentState!=oldState);
                        }
                }
        } else {
                //No. It is a page opened from context or from an other page
                QString name=getDefaultStateAttribute();
                if (!name.isEmpty()) {
                        QString currentState=getState().trimmed();
                        QString oldState=getDocument()->getParameter(name);
                        currentState.remove('\n');
                        oldState.remove('\n');
                        SKGTRACEL(5) << "oldState      =[" << oldState << ']' << endl;
                        SKGTRACEL(5) << "currentState  =[" << currentState << ']' << endl;
                        SKGTRACEL(5) << "Context diff =" << (currentState!=oldState ? "TRUE" : "FALSE") << endl;
                        return (currentState!=oldState);
                }
        }
        return false;
}

void SKGTabPage::overwrite(bool iUserConfirmation)
{
        //Is this widget linked to a bookmark ?
        if (bookmarkID.length()) {
                //Yes. Is state modified ?
                SKGNodeObject node(getDocument(), SKGServices::stringToInt(bookmarkID));
                if (node.exist()) {
                        QStringList data=SKGServices::splitCSVLine(node.getData());
                        QString fullname=node.getFullName();
                        if (data.count()>3) {
                                QString currentState=getState().trimmed();
                                QString oldState=data[3].trimmed();
                                currentState.remove('\n');
                                oldState.remove('\n');
                                SKGTRACEL(5) << "oldState      =[" << oldState << ']' << endl;
                                SKGTRACEL(5) << "currentState  =[" << currentState << ']' << endl;
                                if (currentState!=oldState) {
                                        QApplication::setOverrideCursor(QCursor(Qt::ArrowCursor));
                                        int conf=KMessageBox::Yes;
                                        if (iUserConfirmation) conf=KMessageBox::questionYesNo(this,
                                                                            i18nc("Question", "Bookmark [%1] has been modified. Do you want to update it with the current state?",fullname),
                                                                            i18nc("Question", "Bookmark has been modified"),
                                                                            KStandardGuiItem::yes(),
                                                                            KStandardGuiItem::no(),
                                                                            QString("updateBookmarkOnClose"));
                                        QApplication::restoreOverrideCursor();
                                        if (conf==KMessageBox::Yes) {
                                                SKGError err;
                                                {
                                                        SKGBEGINTRANSACTION(*getDocument(), i18nc("Noun, name of the user action", "Bookmark update [%1]",fullname), err);
                                                        data[3]=currentState;
                                                        if (err.isSucceeded()) err=node.setData(SKGServices::stringsToCsv(data));
                                                        if (err.isSucceeded()) err=node.save();
                                                }
                                                if (err.isSucceeded()) err=SKGError(0, i18nc("Successful message after an user action", "Bookmark updated"));
                                                SKGMainPanel::displayErrorMessage(err);
                                        }
                                }
                        }
                }
        } else {
                //No. It is a page opened from context or from an other page
                QString name=getDefaultStateAttribute();
                if (!name.isEmpty()) {
                        QString currentState=getState().trimmed();
                        QString oldState=getDocument()->getParameter(name);
                        SKGTRACEL(5) << "oldState      =[" << oldState << ']' << endl;
                        SKGTRACEL(5) << "currentState  =[" << currentState << ']' << endl;
                        currentState.remove('\n');
                        oldState.remove('\n');
                        if (currentState!=oldState) {
                                QApplication::setOverrideCursor(QCursor(Qt::ArrowCursor));
                                int conf=KMessageBox::Yes;
                                if (iUserConfirmation) conf=KMessageBox::questionYesNo(this,
                                                                    i18nc("Question", "Page has been modified. Do you want to update it with the current state?"),
                                                                    i18nc("Question", "Page has been modified"),
                                                                    KStandardGuiItem::yes(),
                                                                    KStandardGuiItem::no(),
                                                                    QString("updateContextOnClose"));
                                QApplication::restoreOverrideCursor();
                                if (conf==KMessageBox::Yes) {
                                        SKGError err;
                                        {
                                                SKGBEGINTRANSACTION ( *getDocument(), i18nc("Noun, name of the user action", "Save default state" ), err );
                                                err=getDocument()->setParameter(name, currentState);
                                        }
                                        if (err.isSucceeded()) err=SKGError(0, i18nc("Successful message after an user action", "Default state saved"));
                                        SKGMainPanel::displayErrorMessage(err);
                                }
                        }
                }
        }
}
#include "skgtabpage.moc"
