/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#include "skgdataengine.h"


#include <Plasma/DataContainer>

#include "skgtraces.h"
#include "skgservices.h"


SKGDataEngine::SKGDataEngine(SKGDocument* iDocument, QObject* parent, KService::Ptr service): DataEngine(parent, service)
{
    document = iDocument;
    init();
}

SKGDataEngine::~SKGDataEngine()
{

}

QStringList SKGDataEngine::sources() const
{
    QStringList sources;

    static const QString accounts = "Accounts";
    static const QString incomes_expenditures = "Incomes & Expenditures";

    sources << accounts << incomes_expenditures;
    return sources;
}


bool SKGDataEngine::updateSourceEvent(const QString& source)
{
    if (source == "Accounts") {
        return getAccountData();
    }
    else if (source == "Incomes & Expenditures") {
        return getIncomeExpenditureData();
    }
    return false;
}

bool SKGDataEngine::sourceRequestEvent(const QString& source)
{
    return updateSourceEvent(source);
}


bool SKGDataEngine::getAccountData() {

    SKGStringListList data;

    // Fetch results in the database
    SKGError err = SKGServices::executeSelectSqliteOrder ( document, "SELECT t_name, f_CURRENTAMOUNT FROM v_bank ORDER BY t_name", data );

    // We may receive an error from querying the SQLite database
    if (err.isFailed()) {
        return false;
    }

    // Put the data in the dataengine
    for ( int i=0 ; i < data.count() ; i++) {
        setData( "Accounts", data.at(i).at(0), data.at(i).at(1));
    }
    return true;

}


bool SKGDataEngine::getIncomeExpenditureData()
{

    QDate date=QDate::currentDate();

    QString month=date.toString ( "yyyy-MM" );
    QString previousmonth=date.addMonths(-1).toString ( "yyyy-MM" );

    SKGStringListList data;
    SKGError err = SKGServices::executeSelectSqliteOrder(document, "SELECT TOTAL(f_CURRENTAMOUNT), d_DATEMONTH FROM v_operation_display WHERE d_DATEMONTH IN ('"+month+"', '"+previousmonth+"') AND i_group_id=0 group by d_DATEMONTH, t_TYPEEXPENSE", data);


    // We may receive an error from querying the SQLite database
    if (err.isFailed()) {
        return false;
    }

    // Put the data in the dataengine
    for ( int i=0 ; i < data.count() ; i++) {
        setData( "Incomes & Expenses", data.at(i).at(0), data.at(i).at(1));
    }
    return true;
}


void SKGDataEngine::outputData()
{
    for (int i = 0 ; i < sources().count() ; i++) {
        SKGTRACEIN(10,"source"+sources().at(i));
    }
}


// this is needed since TestTimeEngine is a QObject
#include "skgdataengine.moc"
