/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/

#ifndef OPERATIONSKROOGOID_H
#define OPERATIONSKROOGOID_H
/** @file
* This file is Plasma Applet for Income & Expenditure Skroogoid
*
* @author Siddharth SHARMA
*/
#include <Plasma/PopupApplet>
#include <Plasma/Label>
#include <QProgressBar>
class KAction;

class QGraphicsGridLayout;
/**
 * Class OperationSkroogoid
 */
class OperationSkroogoid : public Plasma::PopupApplet
{
    Q_OBJECT

public:
    /**
    * Default Constructor
    */
    OperationSkroogoid( QObject *parent, const QVariantList &args );
    /**
    * Default Destructor
    */
    ~OperationSkroogoid();
private:

    /**
      *  QGraphicsWidget widget on which we add layout for adding items
      */
    QGraphicsWidget *m_widget;

    /**
    *  QGraphicsGridLayout layout for adding items in grid
    */
    QGraphicsGridLayout *m_layout;

    /**
    *  QGraphicsProxyWidget for adding Qt widgets on Plasma Applet
    */
    QGraphicsProxyWidget*  cincome_pw;
    QGraphicsProxyWidget*  cexpenditure_pw;
    QGraphicsProxyWidget*  pincome_pw;
    QGraphicsProxyWidget*  pexpenditure_pw;

    
    /**
      * Plasma Labels 
      */
    Plasma::Label* cmonth;
    Plasma::Label* pmonth;
    Plasma::Label* cincome;
    Plasma::Label* cexpenditure;
    Plasma::Label* pincome;
    Plasma::Label* pexpenditure;
    Plasma::Label* spacer;

    /**
    *  QProgressBars for visualising fetched data on to skroogoid
    */
    QProgressBar*  cincome_progress;
    QProgressBar*  cexpenditure_progress;
    QProgressBar*  pincome_progress;
    QProgressBar*  pexpenditure_progress;

};

/**
  * For exporting skroogoid as a registered Plasma Applet
  */
K_EXPORT_PLASMA_APPLET(operationskroogoid, OperationSkroogoid)

#endif
