/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGUNITVALUEOBJECT_H
#define SKGUNITVALUEOBJECT_H
/** @file
 * This file defines classes SKGUnitValueObject.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */

#include "skgobjectbase.h"
#include "skgerror.h"
#include "skgbankmodeler_export.h"

class SKGUnitObject;

/**
 * This class is a value at a time for a unit
 */
class SKGBANKMODELER_EXPORT SKGUnitValueObject : public SKGObjectBase
{
    Q_OBJECT;

public:
    /**
     * Constructor
     * @param iDocument the document containing the object
     * @param iID the identifier in @p iTable of the object
     */
    explicit SKGUnitValueObject(SKGDocument* iDocument=NULL, int iID=0);

    /**
     * Copy constructor
     * @param iObject the object to copy
     */
    SKGUnitValueObject(const SKGUnitValueObject& iObject);

    /**
     * Copy constructor
     * @param iObject the object to copy
     */
    SKGUnitValueObject(const SKGObjectBase& iObject);

    /**
     * Operator affectation
     * @param iObject the object to copy
     */
    virtual const SKGUnitValueObject& operator= (const SKGObjectBase &iObject);

    /**
     * Destructor
     */
    virtual ~SKGUnitValueObject();

    /**
     * Set the quantity for the date of this unit
     * @param iValue the quantity
     * @return an object managing the error
     *   @see SKGError
     */
    virtual SKGError setQuantity(double iValue);

    /**
     * Get the quantity for the date of this unit
     * @return the quantity
     */
    virtual double getQuantity() const;

    /**
     * Set date of this value
     * @param iDate the date
     * @return an object managing the error
     *   @see SKGError
     */
    virtual SKGError setDate(const QDate& iDate);

    /**
     * Get date of this value
     * @return the date
     */
    virtual QDate getDate() const;

    /**
     * Get the parent unit
     * @param oUnit the parent unit
     * @return an object managing the error
     *   @see SKGError
     */
    virtual SKGError getUnit(SKGUnitObject& oUnit) const;

protected:
    /**
     * Get where clause needed to identify objects.
     * For this class, the whereclause is based on date + unit
     * @return the where clause
     */
    virtual QString getWhereclauseId() const;
};
/**
 * Declare the class
 */
Q_DECLARE_TYPEINFO ( SKGUnitValueObject, Q_MOVABLE_TYPE );
#endif
