/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGDATEPICKERPOPUP_H
#define SKGDATEPICKERPOPUP_H
/** @file
 * A date edit with more features.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */

#include "skgbasegui_export.h"

#include <QDateTime>
#include <QMenu>

class KDatePicker;

/**
 * This file is a date edit with more features
 * based on SKGDatePickerPopup of PIM
 */
class SKGBASEGUI_EXPORT SKGDatePickerPopup: public QMenu
{
    Q_OBJECT
    /**
     * Mode of the picker
     */
    Q_ENUMS(ItemFlag);
public:
    /**
     * Mode of the picker
     */
    enum ItemFlag {
        NoDate = 1,
        DatePicker = 2,
        Words = 4
    };

    /**
     * Flags for the picker
     */
    Q_DECLARE_FLAGS( Items, ItemFlag );

    /**
     *  A constructor for the SKGDatePickerPopup.
     *  @param items List of all desirable items, separated with a bitwise OR.
     *  @param date Initial date of datepicker-widget.
     *  @param parent The object's parent.
     */
    explicit SKGDatePickerPopup( Items items = DatePicker,
                                 const QDate &date = QDate::currentDate(),
                                 QWidget *parent = 0 );

    /**
     * Get date picker
     * @return date picker
     */
    KDatePicker *datePicker() const;

    /**
     * Set date
     * @param date the date
     */
    virtual void setDate( const QDate &date );

    /**
     * Returns items
     * @return
     */
    virtual int items() const {
        return mItems;
    }

Q_SIGNALS:

    /**
     * This signal emits the new date (selected with datepicker or other
     * menu-items).
     */
    void dateChanged ( const QDate &date );

private Q_SLOTS:
    void slotDateChanged ( const QDate &date );
    void slotToday();
    void slotTomorrow();
    void slotNextWeek();
    void slotNextMonth();
    void slotNoDate();

private:
    void buildMenu();

    KDatePicker *mDatePicker;
    Items mItems;
};

Q_DECLARE_OPERATORS_FOR_FLAGS( SKGDatePickerPopup::Items )

#endif
