/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/

#include "skroogoidloader.h"
#include "ui_skroogoidloader.h"
#include <Plasma/Applet>
#include <QStandardItemModel>
#include <KMessageBox>

SkroogoidLoader::SkroogoidLoader(): KDialog()
{


    QWidget* widget = new QWidget(this);
    // setAttribute(Qt::WA_TintedBackground, true);
    //QPixmap pix = QPixmap("test.png");
    skg_ui = new Ui::SkroogoidLoader;
    skg_ui->setupUi(widget);
    setMainWidget(widget);
    QStandardItemModel* skroogoidmodel = new QStandardItemModel(this);
    const KPluginInfo::List skglist = Plasma::Applet::listAppletInfo("", "skrooge");
    foreach(const KPluginInfo & info, skglist) {
        QStandardItem* skroogoidName = new QStandardItem(KIcon(info.icon()), info.name());
        skroogoidName->setEditable(false);
        skroogoidName->setData(info.pluginName());
        skroogoidmodel->appendRow(skroogoidName);
    }
    //get geometry of application for adding applets in newspaper layout
    //QApplication::desktop()->screenGeometry(this).height();
    //QApplication::desktop()screenGeometry(this).width();
    skg_ui->skroogoids->setModel(skroogoidmodel);
    connect(skg_ui->skroogoids, SIGNAL(doubleClicked(QModelIndex)), SLOT(selected(QModelIndex)));
    //  connect(skg_ui->skroogoids,SIGNAL(activated(QModelIndex)),SLOT(selected(QModelIndex)));
}

SkroogoidLoader::~SkroogoidLoader()
{
    delete skg_ui;
}

void SkroogoidLoader::selected(const QModelIndex& id)
{
    //KMessageBox::information(this,id.data(Qt::UserRole+1).toString() );
    emit addApplet(id.data(Qt::UserRole + 1).toString());
}

#include "skroogoidloader.moc"
