/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for monthly report.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgmonthlyboardwidget.h"
#include "skgmonthlypluginwidget.h"
#include "skgtraces.h"
#include "skgdocumentbank.h"
#include "skgmainpanel.h"

#include <QDomDocument>

SKGMonthlyBoardWidget::SKGMonthlyBoardWidget(SKGDocument* iDocument)
    : SKGWidget(iDocument), m_mode(0)
{
    SKGTRACEIN(10, "SKGMonthlyBoardWidget::SKGMonthlyBoardWidget");

    ui.setupUi(this);

    m_timer.setSingleShot(true);
    connect(&m_timer, SIGNAL(timeout()), this, SLOT(onModified()));
    connect((const QObject*) getDocument(), SIGNAL(transactionSuccessfullyEnded(int)), this, SLOT(onModified()), Qt::QueuedConnection);
}

SKGMonthlyBoardWidget::~SKGMonthlyBoardWidget()
{
    SKGTRACEIN(10, "SKGMonthlyBoardWidget::~SKGMonthlyBoardWidget");
}

QString SKGMonthlyBoardWidget::getState()
{
    SKGTRACEIN(10, "SKGMonthlyBoardWidget::getState");
    QDomDocument doc("SKGML");
    QDomElement root = doc.createElement("parameters");
    doc.appendChild(root);

    //Get state
    root.setAttribute("mode", SKGServices::intToString(m_mode));

    return doc.toString();
}

void SKGMonthlyBoardWidget::setState(const QString& iState)
{
    SKGTRACEIN(10, "SKGMonthlyBoardWidget::setState");
    QDomDocument doc("SKGML");
    doc.setContent(iState);
    QDomElement root = doc.documentElement();

    //Set state
    QString modeS = root.attribute("mode");
    if(!modeS.isEmpty()) m_mode = SKGServices::stringToInt(modeS);

    m_timer.start(300);
}

void SKGMonthlyBoardWidget::onModified()
{
    SKGTRACEIN(10, "SKGMonthlyBoardWidget::onModified");
    QDate month = QDate::currentDate();
    month = month.addDays(-month.day() + 1).addMonths(-1);

    QDate previousMonth = month.addMonths(-1);

    SKGDocumentBank* doc = static_cast<SKGDocumentBank*>(getDocument());
    if(doc) {
        QString monthS = month.toString("yyyy-MM");
        if(m_mode == 0) {
            ui.kGroup->setTitle(i18nc("Report header",  "5 main categories of expenditure"));
            ui.kText->setText(doc->get5MainCategories(monthS, false));
        } else if(m_mode == 1) {
            ui.kGroup->setTitle(i18nc("Report header",  "5 main variations of %1", monthS));
            ui.kText->setText(doc->get5MainCategoriesVariation(monthS, previousMonth.toString("yyyy-MM")));
        } else if(m_mode == 2) {
            ui.kGroup->setTitle(i18nc("Report header",  "Budget of %1", monthS));
            QString budget = doc->getBudget(monthS);
            ui.kText->setText(budget.isEmpty() ? i18nc("Message", "No budget defined<br>on the <a href=\"___\">\"Budget\"</a> page.") : budget);
        }
    }

    //No widget if no account
    bool exist = false;
    getDocument()->existObjects("account", "", exist);
    if(parentWidget()) setVisible(exist);
}

void SKGMonthlyBoardWidget::onOpen(const QString& iLink)
{
    Q_UNUSED(iLink);
    QDomDocument doc("SKGML");
    doc.setContent(getDocument()->getParameter("SKGBUDGET_DEFAULT_PARAMETERS"));
    SKGMainPanel::getMainPanel()->openPage(SKGMainPanel::getMainPanel()->getPluginByName("Skrooge budget plugin"), -1, doc.toString());
}
#include "skgmonthlyboardwidget.moc"
