/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file is Plasma Applet for Estimated Interest Skroogoid
*
* @author Siddharth SHARMA
*/

#include "calculatorskroogoid.h"

#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgservices.h"
#include "skgaccountobject.h"
#include "skgunitobject.h"
#include "skgmainpanel.h"

#include <QGraphicsLinearLayout>

CalculatorSkroogoid::CalculatorSkroogoid(QObject *parent, const QVariantList &args)
    : Plasma::PopupApplet(parent, args)
{

    setAspectRatioMode(Plasma::IgnoreAspectRatio);
    resize(300, 300);
    gl_layout = new QGraphicsLinearLayout();
    setLayout(gl_layout);

    QString html;
    displayLabel = new Plasma::Label();
    SKGMainPanel* panel = SKGMainPanel::getMainPanel();
    SKGDocumentBank* doc = qobject_cast<SKGDocumentBank*>(panel->getDocument());
    SKGServices::SKGUnitInfo primary = doc->getPrimaryUnit();
    SKGObjectBase::SKGListSKGObjectBase objs;
    SKGError err = panel->getDocument()->getObjects("v_account", "t_close='N' AND EXISTS(select 1 from interest where interest.rd_account_id=v_account.id) ORDER BY t_name", objs);
    if(doc) {
        if(!err) {
            html += "<html><body>";
            int nb = objs.count();
            if(nb) {
                html += "<table>";
                double sum = 0;
                for(int i = 0; i < nb; ++i) {
                    SKGAccountObject obj = objs.at(i);
                    html += QString("<tr><td><a href=\"" % SKGServices::stringToHtml(obj.getName()) % "\">") % SKGServices::stringToHtml(obj.getName()) % "</a></td><td align=\"right\">";

                    QList<SKGAccountObject::SKGInterestItem> oInterestList;
                    double oInterests = 0;
                    obj.getInterestItems(oInterestList, oInterests);
                    sum += oInterests;

                    html += doc->formatMoney(oInterests, primary);
                    html += "</td></tr>";
                }
                html += "<tr><td><b>" % SKGServices::stringToHtml(i18nc("Noun, the numerical total of a sum of values", "Total")) % "</b></td>"
                        "<td align=\"right\"><b>" % doc->formatMoney(sum, primary) % "</b></td>"
                        "</tr>";
                html += "</table>";
            } else {
                html += i18nc("Message", "No interest defined for accounts<br>on the <a href=\"___\">\"Simulation\"</a> page.");
            }
            html += "</body></html>";
            displayLabel->setText(html);
            gl_layout->addItem(displayLabel);
        }
    }
}


CalculatorSkroogoid::~CalculatorSkroogoid()
{
}


#include "calculatorskroogoid.moc"
