/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file is Plasma Applet for Estimated Interest Skroogoid
*
* @author Siddharth SHARMA
*/

#include "fileskroogoid.h"

#include "skgdocument.h"
#include "skgwidget.h"
#include "skgmainpanel.h"

#include <QGraphicsGridLayout>
#include <QGraphicsLinearLayout>

#include <KTipDatabase>

FileSkroogoid::FileSkroogoid(QObject *parent, const QVariantList &args)
    : Plasma::PopupApplet(parent, args), m_layout()
{
    setAspectRatioMode(Plasma::IgnoreAspectRatio);
    resize(300, 300);

    heading = new Plasma::Label();
    heading->setText(i18n("<b>Did you know ...?</b>"));
    heading->setAlignment(Qt::AlignHCenter);
    displayLabel = new Plasma::Label();

    iconbutton = new Plasma::PushButton();
    iconbutton->setIcon(KIcon("ktip"));

    QGraphicsGridLayout* layout = new  QGraphicsGridLayout(this);
    QGraphicsLinearLayout* linearLayout = new QGraphicsLinearLayout(layout);
    linearLayout->addItem(heading);
    layout->addItem(linearLayout, 0, 0, 5, 1);
    layout->addItem(displayLabel, 1, 0, 1, 1);
    layout->addItem(iconbutton, 1, 1, 1, 1);


    KTipDatabase db(SKGMainPanel::getMainPanel()->getTipOfDayFileName());
    displayLabel->setText(SKGServices::htmlToString(db.tip()));

    connect(iconbutton, SIGNAL(clicked()), this, SLOT(iconClicked()));

}

void FileSkroogoid::iconClicked()
{

    KTipDatabase db(SKGMainPanel::getMainPanel()->getTipOfDayFileName());
    db.nextTip();
    displayLabel->setText(SKGServices::htmlToString(db.tip()));

}

FileSkroogoid::~FileSkroogoid()
{

}


#include "fileskroogoid.moc"
