/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGSCHEDULEDPLUGINWIDGET_H
#define SKGSCHEDULEDPLUGINWIDGET_H
/** @file
 * A skrooge plugin to manage scheduled operations
*
* @author Stephane MANKOWSKI
*/
#include "ui_skgscheduledpluginwidget_base.h"
#include "skgtabpage.h"

class SKGDocumentBank;

/**
 * A skrooge plugin to manage scheduled operations
 */
class SKGScheduledPluginWidget : public SKGTabPage
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     */
    SKGScheduledPluginWidget(SKGDocumentBank* iDocument);

    /**
     * Default Destructor
     */
    virtual ~SKGScheduledPluginWidget();

    /**
     * Get the current state
     * MUST BE OVERWRITTEN
     * @return a string containing all information needed to set the same state.
     * Could be an XML stream
     */
    virtual QString getState();

    /**
     * Set the current state
     * MUST BE OVERWRITTEN
     * @param iState must be interpreted to set the state of the widget
     */
    virtual void setState(const QString& iState);

    /**
     * Get attribute name to save the default state
     * MUST BE OVERWRITTEN
     * @return attribute name to save the default state.
     */
    virtual QString getDefaultStateAttribute();

    /**
     * Get the main widget
     * @return a widget
     */
    virtual QWidget* mainWidget() const;

protected:
    /**
     * Event filtering
     * @param object object
     * @param event event
     * @return In your reimplementation of this function, if you want to filter the event out, i.e. stop it being handled further, return true; otherwise return false.
     */
    virtual bool eventFilter(QObject* object, QEvent* event);

private Q_SLOTS:
    void onSelectionChanged();
    void onUpdate();
    void onProcess();
    void onNbOccurrenceChanged();
    void onJumpToTheOperation();

private:
    Q_DISABLE_COPY(SKGScheduledPluginWidget);

    Ui::skgscheduledplugin_base ui;

    KAction* m_jumpAction;
};

#endif // SKGSCHEDULEDPLUGINWIDGET_H
