/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGTABWIDGET_H
#define SKGTABWIDGET_H
/** @file
 * A KTabWidget with more features.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgbasegui_export.h"

#include <ktabwidget.h>

#include <QMap>
#include <QTimer>

class QPushButton;

/**
 * A KTabWidget with more features.
 */
class SKGBASEGUI_EXPORT SKGTabWidget : public KTabWidget
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     * @param parent the parent
     */
    SKGTabWidget(QWidget* parent = 0);

    /**
     * Default Destructor
     */
    virtual ~SKGTabWidget();

public Q_SLOTS:
    /**
     * Remove a tab
     * @param index the tab index
     */
    virtual void removeTab(int index);

private Q_SLOTS:
    void onCurrentChanged();
    void onRefreshSaveIcon();
    void onSaveRequested();
    void onMoveTab(int oldPos, int newPos);

private:
    QTimer m_timerSave;

    QMap<QWidget*, QPushButton*> m_tabIndexSaveButton;
};

#endif // SKGTABWIDGET_H
